/* -*- c++ -*- */
#ifndef AKAXISO_ANY_ARRAY_HANDLER_H__
#define AKAXISO_ANY_ARRAY_HANDLER_H__

/** @file akaxiso/parser/any_array_handler.h */

#include <akaxiso/parser/handler.h>

namespace aka2 {

  class any_array_handler : public handler {
  public:
    any_array_handler(const qname& tagname, any_array &an, 
		      int depth, const occurrence &occ,
		      parser_context &context);

    virtual ~any_array_handler();
    virtual parse_result query_element(const qname &tagname, const attribute_values &attrs);
    virtual parse_result end_element(const qname &tagname);
    virtual parse_result query_next(const qname &tagname, const attribute_values &attrs);
    virtual bool parse_entity(const std::string &entity);

    virtual node get_node();
    virtual void receive_child(const node &child);
    virtual bool can_skip();
    virtual void abort();
    
  private:
    any_array &anys_;
    const occurrence &occ_;
    any *any_;
  };

} // namespace aka2

#endif /* AKAXISO_ANY_ARRAY_HANDLER_H__ */
