#include "any_handler.h"

#include <cassert>
#include <sstream>

using namespace aka2;

any_handler::any_handler(const qname &tagname, any &an, int depth,
			 parser_context &context)  
  : handler(context, depth, tagname) , any_(an), child_(0) {
  any_.name_ = tagname;
}

any_handler::~any_handler() {
  abort();
}


parse_result any_handler::query_element(const qname &tagname, const attribute_values &attrs){
  child_ = new any;
  create_any_handler(tagname, *child_, depth_ + 1);
  return ok;
}

parse_result any_handler::query_next(const qname &tagname, const attribute_values &attrs){
  assert(!"Must not be called.");
  return error;
}



parse_result any_handler::end_element(const qname &tagname){
  return ok;
}


bool any_handler::parse_entity(const std::string &entity) {
  if (any_.value_.empty())
    any_.value_ = entity;
  return true;
}


node any_handler::get_node() {
  return node(&any_, aka2::any_op::dispatcher_);
}

void any_handler::receive_child(const node &child) {
  any_.children_.push_back(*child_);
  delete child_;
  child_ = 0;
}

bool any_handler::can_skip() {
  return false;
}

void any_handler::abort() {
  if (child_ != 0) {
    delete child_;
    child_ = 0;
  }
}

