/* -*- c++ -*- */
#ifndef AKAXISO_ARRAY_HANDLER_H__
#define AKAXISO_ARRAY_HANDLER_H__

/** @file akaxiso/parser/array_handler.h */

#include <akaxiso/parser/handler.h>

namespace aka2 {

  class array_handler : public handler {
  public:
    array_handler(const qname &tagname, void *ma, int depth,
		  const array_op &aop, const element_props &props,
		  bool is_element,
		  parser_context &context);
    virtual ~array_handler();
    virtual parse_result query_element(const qname &tagname, const attribute_values &attrs);
    virtual parse_result end_element(const qname &tagname);
    virtual parse_result query_next(const qname &tagname, const attribute_values &attrs);
    virtual bool parse_entity(const std::string &entity);

    virtual node get_node();
    virtual void receive_child(const node &child);

    virtual bool can_skip();
    virtual void abort(); 

  private:
    parse_result parse_element(const qname &tagname, const attribute_values &attrs);
    parse_result find_particle(const qname &tagname, const attribute_values &attrs);

    void *array_;
    void *e_;
    const array_op &aop_;
    const element_props &props_;
    bool is_element_;
    int count_;
  };

} // namespace aka2

#endif /* AKAXISO_ARRAY_HANDLER_H__ */
