#include "schemadatatypes.h"
#include "schemastructure.h"
#include "schema_xiso.h"



namespace xs {


  void maxOccursLeaf::write_text(const void *e, std::ostream &ostm,
				 const aka::global_attributes &gattrs) {
    const long &v = *static_cast<const long*>(e);
    if (v == aka::unbounded)
      ostm << "unbounded";
    else
      ostm << v;
  }

  void maxOccursLeaf::read_text(void *e, std::istringstream &istm, 
				const aka::global_attributes &gattrs) {
    long &v = *static_cast<long*>(e);
     if (istm.rdbuf()->str() == "unbounded") {
       v = aka::unbounded;
       return;
     }
     istm >> v;
     if (istm.fail())
       throw aka2::internal_error();
   }


   void appinfoLeaf::model() { // mixed = true.
     member(any, &appinfo::info_, 0, aka::unbounded);
     attribute("source", &appinfo::source_);
   }

   void documentationLeaf::model() {
     member(any, &documentation::anys_, 0, aka::unbounded);
     attribute("source", &documentation::source_);
     attribute("xml:lang", &documentation::lang_);
   }

   void openAttrsLeaf::model() {
     any_attribute(&openAttrs::attrs_);
   }

   void annotationContentsLeaf::model() {
     item("xs:appinfo", appinfoLeaf());
     item("xs:documentation", documentationLeaf());
   }

   void annotationLeaf::model() {
     member("&content", &annotation::contents_, 
	    annotationContentsLeaf(), 0, aka::unbounded); // appinfo, documentation.
     attribute("id", &annotation::id_); //attribute
     any_attribute(&openAttrs::attrs_);
   }

   void annotatedLeaf::model() {
     ptrmember("xs:annotation", &annotated::annotation_, annotationLeaf(), false);
     attribute("id", &annotated::id_);
     any_attribute(&openAttrs::attrs_);
   }

   void facetLeaf::model() {
     ptrmember("xs:annotation", &annotated::annotation_, annotationLeaf(), false);
     attribute("id", &annotated::id_);
     any_attribute(&openAttrs::attrs_);
     attribute("value", &facet::value_).required(true);
     attribute("fixed", &facet::fixed_).set_default("false");//optional.
   }

   void noFixedFacetLeaf::model() {
     ptrmember("xs:annotation", &annotated::annotation_, annotationLeaf(), false);
     attribute("id", &annotated::id_);
     any_attribute(&openAttrs::attrs_);
     attribute("value", &noFixedFacet::value_).required(true);
   }


   void numFacetLeaf::model() {
     ptrmember("xs:annotation", &annotated::annotation_, annotationLeaf(), false);
     attribute("id", &annotated::id_);
     any_attribute(&openAttrs::attrs_);
     attribute("value", &numFacet::value_).required(true);
     attribute("fixed", &numFacet::fixed_).required(false);
   }

   void totalDigitsLeaf::model() {
     ptrmember("xs:annotation", &annotated::annotation_, annotationLeaf(), false);
     attribute("id", &annotated::id_);
     any_attribute(&openAttrs::attrs_);
     attribute("value", &totalDigits::value_).required(true);
     attribute("fixed", &totalDigits::fixed_).required(false);
   }

   void whiteSpaceLeaf::model() {
     ptrmember("xs:annotation", &annotated::annotation_, annotationLeaf(), false);
     attribute("id", &annotated::id_);
     any_attribute(&openAttrs::attrs_);
     attribute("value", &whiteSpace::value_).required(true);   
     // "value" has 'preserve' or 'replace' or 'collapse'. !!!!!
     attribute("fixed", &whiteSpace::fixed_).required(false);
   }

 //   void simpleTypeLeaf::model() {
 //     ptrmember("xs:annotation", &annotated::annotation_, annotationLeaf(), false);
 //     attribute("id", &annotated::id_);
 //     any_attribute(&openAttrs::attrs_);
 //     member("&simpleDerivation", &simpleType::simpleDerivation_, simpleDerivationLeaf());
 //     attribute("xs:final", &simpleType::final_);
 //     attribute("xs:name", &simpleType::name_).required(false);
 //   }


   void simpleRestrictionModelLeaf::model() {
     ptrmember("xs:simpleType", &simpleRestrictionModel::simpleType_, 
	       localSimpleTypeLeaf(), false);
     member("&facets", &simpleRestrictionModel::facets_, facetsLeaf(), 
	    0, aka::unbounded);
   }


   void facetsLeaf::model() {
     item("xs:minExclusive", facetLeaf());
     item("xs:minInclusive", facetLeaf());
     item("xs:maxExclusive", facetLeaf());
     item("xs:maxInclusive", facetLeaf());
     item("xs:totalDigits", totalDigitsLeaf());
     item("xs:fractionDigits", numFacetLeaf());
     item("xs:length", numFacetLeaf());
     item("xs:minLength", numFacetLeaf());
     item("xs:maxLength", numFacetLeaf());
     item("xs:enumeration", noFixedFacetLeaf());
     item("xs:whiteSpace", whiteSpaceLeaf());
     item("xs:pattern", noFixedFacetLeaf());
   }

   void topLevelSimpleTypeLeaf::model() {
     ptrmember("xs:annotation", &annotated::annotation_, annotationLeaf(), false);
     attribute("id", &annotated::id_);
     any_attribute(&openAttrs::attrs_);
     member("&simpleDerivation", &simpleType::simpleDerivation_, simpleDerivationLeaf());
     attribute("xs:final", &simpleType::final_);
     attribute("xs:name", &simpleType::name_).required(true);
   }

   void localSimpleTypeLeaf::model() {
     ptrmember("xs:annotation", &annotated::annotation_, annotationLeaf(), false);
     attribute("id", &annotated::id_);
     any_attribute(&openAttrs::attrs_);
     member("&simpleDerivation", &simpleType::simpleDerivation_, simpleDerivationLeaf());
   }


   void listLeaf::model() {
     ptrmember("xs:annotation", &annotated::annotation_, annotationLeaf(), false);
     attribute("id", &annotated::id_);
     any_attribute(&openAttrs::attrs_);
     ptrmember("xs:simpleType", &list::simpleType_, localSimpleTypeLeaf(), false);
     attribute("itemType", &list::itemType_, QNameLeaf()).required(false);
   }


   void unionLeaf::model() {
     ptrmember("xs:annotation", &annotated::annotation_, annotationLeaf(), false);
     attribute("id", &annotated::id_);
     any_attribute(&openAttrs::attrs_);
     member("xs:simpleType", &_union::simpleTypes_, localSimpleTypesLeaf(),
	    0, aka::unbounded);
     attribute("memberTypes", &_union::memberTypes_).required(false);
   }


   void restrictionLeaf::model() {
     ptrmember("xs:annotation", &annotated::annotation_, annotationLeaf(), false);
     attribute("id", &annotated::id_);
     any_attribute(&openAttrs::attrs_);
     member("&simpleRestrictionModel", &restriction::simpleRestrictionModel_,
	    simpleRestrictionModelLeaf());
     attribute("base", &restriction::base_, QNameLeaf());
   }


   void simpleDerivationLeaf::model() {
     item("xs:restriction", restrictionLeaf());
     item("xs:list", listLeaf());
     item("xs:union", unionLeaf());
   }

   void typeDefParticleLeaf::model() {
     item("xs:group", groupRefLeaf());
     item("xs:all", allLeaf());
     item("xs:choice", explicitGroupLeaf());
     item("xs:sequence", explicitGroupLeaf());
   }


   void occursLeaf::model() {
     attribute("minOccurs", &occurs::minOccurs_).set_default("1");
     attribute("maxOccurs", &occurs::maxOccurs_, maxOccursLeaf()).set_default("1");
   }

   void nestedParticleLeaf::model() {
     item("xs:element", localElementLeaf());
     item("xs:group", groupRefLeaf());
     item("xs:choice", explicitGroupLeaf());
     item("xs:sequence", explicitGroupLeaf());
     item("xs:any", anyLeaf());
   }


   void particleLeaf::model() {
     item("xs:element", localElementLeaf());
     item("xs:group", groupRefLeaf());
     item("xs:all", allLeaf());
     item("xs:choice", explicitGroupLeaf());
     item("xs:sequence", explicitGroupLeaf());
     item("xs:any", anyLeaf());
   }


   void typeChoiceLeaf::model() {
     item("xs:simpleType", localSimpleTypeLeaf());
     item("xs:complexType", localComplexTypeLeaf());
   }


   void defRefLeaf::model() {
     attribute("name", &defRef::name_);
     attribute("ref", &defRef::ref_, QNameLeaf());
   }


   void attributeLeaf::model() {
     // annotated.
     ptrmember("xs:annotation", &annotated::annotation_, annotationLeaf(), false);
     attribute("id", &annotated::id_);
     any_attribute(&openAttrs::attrs_);

     ptrmember("xs:simpleType", &xs::attribute::simpleType_, 
	    localSimpleTypeLeaf(), false);

     // defRef group.
     attribute("name", &defRef::name_);
     attribute("ref", &defRef::ref_, QNameLeaf());

     attribute("type", &xs::attribute::type_, QNameLeaf());
     attribute("use", &xs::attribute::use_).set_default("optional");
     attribute("default", &xs::attribute::default_);
     attribute("fixed", &xs::attribute::fixed_);
     attribute("form", &xs::attribute::form_);
   }

   void attributeChoiceLeaf::model() {
     item("xs:attribute", attributeLeaf());
     item("xs:attributeGroup", attributeGroupLeaf());
   }

   void attrDeclsLeaf::model() {
     member("&attrChoice", &attrDecls::choice_, attributeChoiceLeaf(), 0, aka::unbounded);
     ptrmember("xs:anyAttribute", &attrDecls::anyAttribute_, false);
   }

   void restrictionContentLeaf::model() {
     item("&typeDefParticle", typeDefParticleLeaf());
     item("&simpmleRestrictionModel", simpleRestrictionModelLeaf());
   }

   void restrictionTypeLeaf::model() {
     // annotated.
     ptrmember("xs:annotation", &annotated::annotation_, annotatedLeaf(), false);
     attribute("id", &annotated::id_);
     any_attribute(&openAttrs::attrs_);
     member("&contents", &restrictionType::content_, restrictionContentLeaf());
     member("&attrDecls", &restrictionType::attrDecls_, attrDeclsLeaf());
     attribute("base", &restrictionType::base_, QNameLeaf()).required(true);
   }

   void simpleRestrictionTypeLeaf::model() {
     // annotated.
     ptrmember("xs:annotation", &annotated::annotation_, annotationLeaf(), false);
     attribute("id", &annotated::id_);
     any_attribute(&openAttrs::attrs_);
     ptrmember("&simpleRestrictionModel", &simpleRestrictionType::simpleRestrictionModel_, 
	    simpleRestrictionModelLeaf(), false);
     member("&attrDecls", &simpleRestrictionType::attrDecls_, attrDeclsLeaf());
     attribute("base", &simpleRestrictionType::base_, QNameLeaf()).required(true);
   }

   void topLevelAttributeLeaf::model() {
     // annotated.
     ptrmember("xs:annotation", &annotated::annotation_, annotationLeaf(), false);
     attribute("id", &annotated::id_);
     any_attribute(&openAttrs::attrs_);

     member("simpleType", &topLevelAttribute::simpleType_, localSimpleTypeLeaf());

     attribute("name", &defRef::name_).required(true);

     attribute("type", &topLevelAttribute::type_, QNameLeaf());
     attribute("default", &topLevelAttribute::default_);
     attribute("fixed", &topLevelAttribute::fixed_);
   }


   void extensionTypeLeaf::model() {
     // annotated.
     ptrmember("xs:annotation", &annotated::annotation_, annotationLeaf(), false);
     attribute("id", &annotated::id_);
     any_attribute(&openAttrs::attrs_);

     member("&typeDefParticle", &extensionType::typeDefParticle_, 
	    typeDefParticleLeaf(), 0, 1);
     member("&attrDecls", &extensionType::attrDecls_, attrDeclsLeaf());
     attribute("base", &extensionType::base_, QNameLeaf()).required(true);
   }

   void simpleExtensionTypeLeaf::model() {
     // annotated.
     ptrmember("xs:annotation", &annotated::annotation_, annotationLeaf(), false);
     attribute("id", &annotated::id_);
     any_attribute(&openAttrs::attrs_);

     member("&attrDecls", &simpleExtensionType::attrDecls_, attrDeclsLeaf());
     attribute("base", &simpleExtensionType::base_, QNameLeaf()).required(true);
   }

  void contentDefLeaf::model() {
    member("&typedefParticle", &contentDef::particle_, typeDefParticleLeaf(), 0, 1);
    member("&attrDecls", &contentDef::attrDecls_, attrDeclsLeaf());
  }

  void complexTypeModelLeaf::model() { //!!!!!!! wrong definition.
     item("xs:simpleContent", simpleContentLeaf());
     item("xs:complexContent", complexContentLeaf());
     item("&contentDef", contentDefLeaf());
   }

   void attributeGroupLeaf::model() {
     // annotated.
     ptrmember("xs:annotation", &annotated::annotation_, 
	       annotationLeaf(), false);
     attribute("id", &annotated::id_);
     any_attribute(&openAttrs::attrs_);

     member("&attrDecls", &attributeGroup::attrDecls_, attrDeclsLeaf());
     // defRef group.
     attribute("name", &defRef::name_);
     attribute("ref", &defRef::ref_, QNameLeaf());
   }


   void attributeGroupRefLeaf::model() {
     // annotated.
     ptrmember("xs:annotation", &annotated::annotation_, annotationLeaf(), false);
     attribute("id", &annotated::id_);
     any_attribute(&openAttrs::attrs_);
     attribute("ref", &attributeGroupRef::ref_, QNameLeaf());
   }





 //   void complexTypeLeaf::model() {
 //     // annotated.
 //     ptrmember("xs:annotation", &annotated::annotation_, 
 // 	      annotationLeaf(), false);
 //     attribute("id", &annotated::id_);
 //     any_attribute(&openAttrs::attrs_);

 //     member("&complexTypeModel", &complexType::model_, complexTypeModelLeaf());
 //     attribute("name", &complexType::name_);
 //     attribute("mixed", &complexType::mixed_).set_default("false");;
 //     attribute("abstract", &complexType::abstract_).set_default("false");;
 //     attribute("final", &complexType::final_);
 //     attribute("block", &complexType::block_);
 //   }

  void topLevelComplexTypeLeaf::model() {
    //annotated.
    ptrmember("xs:annotation", &annotated::annotation_, annotationLeaf(), false);
    attribute("id", &annotated::id_);
    any_attribute(&openAttrs::attrs_);
    
    member("&complexTypeModel", &topLevelComplexType::model_, complexTypeModelLeaf());
    attribute("name", &topLevelComplexType::name_).required(true);
    attribute("mixed", &topLevelComplexType::mixed_).set_default("false");;
    attribute("abstract", &topLevelComplexType::abstract_).set_default("false");;
    attribute("final", &topLevelComplexType::final_);
    attribute("block", &topLevelComplexType::block_);
  }
  
  void localComplexTypeLeaf::model() {
    // annotated.
    ptrmember("xs:annotation", &annotated::annotation_, annotationLeaf(), false);
    attribute("id", &annotated::id_);
    any_attribute(&openAttrs::attrs_);
    
    member("&complexTypeModel", &localComplexType::model_, complexTypeModelLeaf());
    attribute("mixed", &localComplexType::mixed_).set_default("false");;
  }


  void complexRestrictionTypeLeaf::model() {
    // annotated.
    ptrmember("xs:annotation", &annotated::annotation_, annotationLeaf(), false);
    attribute("id", &annotated::id_);
    any_attribute(&openAttrs::attrs_);
    
    member("&typeDefParticle", &complexRestrictionType::typeDefParticle_, 
	   typeDefParticleLeaf(), 0, 1);
    member("&attrDecls", &complexRestrictionType::attrDecls_, attrDeclsLeaf());
    attribute("base", &complexRestrictionType::base_, QNameLeaf()).required(true);
  }

  void complexContentContentsLeaf::model() {
    item("xs:restriction", complexRestrictionTypeLeaf());
    item("xs:extension", extensionTypeLeaf());
  }

  void complexContentLeaf::model() {
    // annotated.
    ptrmember("xs:annotation", &annotated::annotation_, 
	      annotationLeaf(), false);
    attribute("id", &complexContent::id_);
    any_attribute(&openAttrs::attrs_);
    
    member("&complexContentContents", &complexContent::contents_, complexContentContentsLeaf());
    attribute("mixed", &complexContent::mixed_);
  }


  void groupLeaf::model() {
    // annotated.
    ptrmember("xs:annotation", &annotated::annotation_, 
	      annotationLeaf(), false);
    attribute("id", &annotated::id_);
    any_attribute(&openAttrs::attrs_);
    
    member("&particle", &group::particle_, particleLeaf(), 
	   0, aka::unbounded);
    
    // defRef group.
    attribute("name", &defRef::name_);
    attribute("ref", &defRef::ref_, QNameLeaf());
    
    // occurs.
    attribute("minOccurs", &occurs::minOccurs_).set_default("1");
    attribute("maxOccurs", &occurs::maxOccurs_, maxOccursLeaf()).set_default("1");
  }


  void realGroupParticleLeaf::model() {
    item("xs:all", allLeaf());
    item("xs:choice", explicitGroupLeaf());
    item("xs:sequence", explicitGroupLeaf());
  }

  void realGroupLeaf::model() {
    ptrmember("xs:annotation", &realGroup::annotation_, 
	      annotationLeaf(), false);
    
    member("&particle", &realGroup::particle_, realGroupLeaf(), 0, 1);
    
    // defRef group.
    attribute("name", &defRef::name_);
    attribute("ref", &defRef::ref_, QNameLeaf());
    
    // occurs.
    attribute("minOccurs", &occurs::minOccurs_).set_default("1");
    attribute("maxOccurs", &occurs::maxOccurs_, maxOccursLeaf()).set_default("1");
  }


  void groupRefLeaf::model() {
    ptrmember("xs:annotation", &groupRef::annotation_, 
	      annotationLeaf(), false);
    
    // defRef group.
    attribute("ref", &groupRef::ref_, QNameLeaf());
    
    // occurs.
    attribute("minOccurs", &occurs::minOccurs_).set_default("1");
    attribute("maxOccurs", &occurs::maxOccurs_, maxOccursLeaf()).set_default("1");
  }

  void selectorLeaf::model() {
    // annotated.
    ptrmember("xs:annotation", &annotated::annotation_, annotationLeaf(), false);
    attribute("id", &annotated::id_);
    any_attribute(&openAttrs::attrs_);
      
    attribute("xpath", &selector::xpath_).required(true);
  }

  void fieldLeaf::model() {
    // annotated.
    ptrmember("xs:annotation", &annotated::annotation_, annotationLeaf(), false);
    attribute("id", &annotated::id_);
    any_attribute(&openAttrs::attrs_);
    
    attribute("xpath", &field::xpath_).required(true);
  }

  void keybaseLeaf::model() {
    ptrmember("xs:annotation", &annotated::annotation_, annotationLeaf(), false);
    attribute("id", &annotated::id_);
    any_attribute(&openAttrs::attrs_);
    member("xs:selector", &keybase::selector_, selectorLeaf());
    member("xs:field", &keybase::fields_, fieldsLeaf(), 0, aka::unbounded);
    attribute("name", &keybase::name_).required(true);
  }

  void keyrefLeaf::model() {
    ptrmember("xs:annotation", &annotated::annotation_, annotationLeaf(), false);
    attribute("id", &annotated::id_);
    any_attribute(&openAttrs::attrs_);

    member("xs:selector", &keybase::selector_, selectorLeaf());
    member("xs:field", &keybase::fields_, fieldsLeaf());
    attribute("name", &keybase::name_).required(true);
    attribute("refer", &keyref::refer_).required(true);
  }

  void identityConstraintLeaf::model() {
    item("xs:unique", keybaseLeaf());
    item("xs:key", keybaseLeaf());
    item("xs:keyref", keyrefLeaf());
  }


  //  void elementLeaf::model() {
//       // annotated.
//       ptrmember("xs:annotation", &annotated::annotation_, annotationLeaf(), false);
//       attribute("id", &annotated::id_);
//       any_attribute(&openAttrs::attrs_);

//       member("&typeChoice", &element::typeChoice_, typeChoiceLeaf(), 0, 1);
//       member("&identityConstraint", &element::identityConstraint_, 
// 	     identityConstraintLeaf(), 0, aka::unbounded);
      
//       // defRef group.
//       attribute("name", &defRef::name_);
//       attribute("ref", &defRef::ref_, QNameLeaf());

//       attribute("type", &element::type_, QNameLeaf());
//       attribute("substitutionGroup", &element::substitutionGroup_, QNameLeaf());

//       // occurs.
//       attribute("minOccurs", &element::minOccurs_).set_default("1");
//       attribute("maxOccurs", &element::maxOccurs_, maxOccursLeaf()).set_default("1");
      
//       attribute("default", &element::default_);
//       attribute("fixed", &element::fixed_);
//       attribute("nillable", &element::nillable_).set_default("false");
//       attribute("abstract", &element::abstract_).set_default("false");
//       attribute("final", &element::final_);
//       attribute("block", &element::block_);
//       attribute("form", &element::form_);
//     }


   void localElementLeaf::model() {
     // annotated.
     ptrmember("xs:annotation", &annotated::annotation_, annotationLeaf(), false);
     attribute("id", &annotated::id_);
     any_attribute(&openAttrs::attrs_);

     member("&typeChoice", &localElement::typeChoice_, typeChoiceLeaf(), 0, 1);
     member("&identityConstraint", &localElement::identityConstraint_, 
	    identityConstraintLeaf(), 0, aka::unbounded);

     // defRef group.
     attribute("name", &defRef::name_);
     attribute("ref", &defRef::ref_, QNameLeaf());

     attribute("type", &localElement::type_, QNameLeaf());

     // occurs.
     attribute("minOccurs", &localElement::minOccurs_).set_default("1");
     attribute("maxOccurs", &localElement::maxOccurs_, maxOccursLeaf()).set_default("1");

     attribute("default", &localElement::default_);
     attribute("fixed", &localElement::fixed_);
     attribute("nillable", &localElement::nillable_).set_default("false");
     attribute("block", &localElement::block_);
     attribute("form", &localElement::form_);
   }


  void topLevelElementLeaf::model() {
    // annotated.
    ptrmember("xs:annotation", &annotated::annotation_, annotationLeaf(), false);
    attribute("id", &annotated::id_);
    any_attribute(&openAttrs::attrs_);
    
    member("&typeChoice", &topLevelElement::typeChoice_, typeChoiceLeaf(), 0, 1);
    member("&identityConstraint", &topLevelElement::identityConstraint_, 
	   identityConstraintLeaf(), 0, aka::unbounded);
    
    // defRef group.
    attribute("name", &topLevelElement::name_, QNameLeaf());
    
    attribute("type", &topLevelElement::type_, QNameLeaf());
    attribute("substitutionGroup", &topLevelElement::substitutionGroup_, QNameLeaf());
    
    attribute("default", &topLevelElement::default_);
    attribute("fixed", &topLevelElement::fixed_);
    attribute("nillable", &topLevelElement::nillable_).set_default("false");
    attribute("abstract", &topLevelElement::abstract_).set_default("false");
    attribute("final", &topLevelElement::final_);
    attribute("block", &topLevelElement::block_);
  }

  void allModelElementLeaf::model() {
    // annotated.
    ptrmember("xs:annotation", &annotated::annotation_, annotationLeaf(), false);
    attribute("id", &annotated::id_);
    any_attribute(&openAttrs::attrs_);
    
    member("&typeChoice", &allModelElement::typeChoice_, typeChoiceLeaf(), 0, 1);
    member("&identityConstraint", &allModelElement::identityConstraint_, 
	   identityConstraintLeaf(), 0, aka::unbounded);
    
    // defRef group.
    attribute("name", &defRef::name_);
    attribute("ref", &defRef::ref_, QNameLeaf());
    
    attribute("type", &allModelElement::type_, QNameLeaf());
    
    // occurs.
    attribute("minOccurs", &allModelElement::minOccurs_).set_default("1"); // 0 or 1 !!!!!
    attribute("maxOccurs", &allModelElement::maxOccurs_, 
	      maxOccursLeaf()).set_default("1"); // 0 or 1 !!!!!
    
    attribute("default", &allModelElement::default_);
    attribute("fixed", &allModelElement::fixed_);
    attribute("nillable", &allModelElement::nillable_).set_default("false");
    attribute("block", &allModelElement::block_);
    attribute("form", &allModelElement::form_);
  }

  void explicitGroupLeaf::model() {
    // annotated.
    ptrmember("xs:annotation", &annotated::annotation_, 
	      annotationLeaf(), false);
    attribute("id", &annotated::id_);
    any_attribute(&openAttrs::attrs_);
    
    member("&particle", &explicitGroup::particle_, particleLeaf(), 0, aka::unbounded);
    
    // occurs.
    attribute("minOccurs", &occurs::minOccurs_).set_default("1");
    attribute("maxOccurs", &occurs::maxOccurs_, maxOccursLeaf()).set_default("1");
  }

  void simpleExplicitGroupLeaf::model() {
    // annotated.
    ptrmember("xs:annotation", &annotated::annotation_, annotatedLeaf(), false);
    attribute("id", &annotated::id_);
    any_attribute(&openAttrs::attrs_);
    
    member("&nestedParticle", &simpleExplicitGroup::particle_, 
	   nestedParticleLeaf(), 0, aka::unbounded);
  }

   void allModelLeaf::model() {
     ptrmember("xs:annotation", &allModel::annotation_, annotationLeaf(), false);
     member("&allModelElements", &allModel::elements_, allModelElementsLeaf(), 0, aka::unbounded);
   }

  
  void allLeaf::model() {
    // annotated.
    ptrmember("xs:annotation", &annotated::annotation_, annotationLeaf(), false);
    attribute("id", &annotated::id_);
    any_attribute(&openAttrs::attrs_);
    
    member("&allModel", &all::allModel_, allModelLeaf());
    
    // occurs.
    attribute("minOccurs", &occurs::minOccurs_).set_default("1"); // 0 or 1.
    attribute("maxOccurs", &occurs::maxOccurs_, 
	      maxOccursLeaf()).set_default("1"); // must be 1.!!!!!
  }

  void namedGroupLeaf::model() {
    ptrmember("xs:annotation", &namedGroup::annotation_, annotationLeaf(), false);
    member("&particle", &namedGroup::particle_, particleLeaf());
    attribute("name", &namedGroup::name_);
  }

  void redefinableLeaf::model() {
    item("xs:simpleType", topLevelSimpleTypeLeaf());
    item("xs:complexType", topLevelComplexTypeLeaf());
    item("xs:group", groupLeaf());
    item("xs:attributeGroup", attributeGroupLeaf());
  }

  void wildcardLeaf::model() {
    attribute("namespace", &wildcard::namespaceList_).set_default("##any");
    attribute("processContents", &wildcard::processContents_).set_default("strict");
  }

  void anyLeaf::model() {
    attribute("namespace", &wildcard::namespaceList_).set_default("##any");
    attribute("processContents", &wildcard::processContents_).set_default("strict");
    attribute("minOccurs", &occurs::minOccurs_).set_default("1");
    attribute("maxOccurs", &occurs::maxOccurs_, maxOccursLeaf()).set_default("1");
  }

  void simpleContentChoiceLeaf::model() {
    item("xs:restriction", simpleRestrictionTypeLeaf());
    item("xs:extension", simpleExtensionTypeLeaf());
  }

  void simpleContentLeaf::model() {
    // annotated.
    ptrmember("xs:annotation", &annotated::annotation_, annotationLeaf(), false);
    attribute("id", &annotated::id_);
    any_attribute(&openAttrs::attrs_);
    
    member("&value_type", &simpleContent::value_type_, simpleContentChoiceLeaf());
  }

  void anyTypeLeaf::model() {
    member(any, &anyType::anys_, 0, aka::unbounded);
  }

  void notationLeaf::model() {
    // annotated.
    ptrmember("xs:annotation", &annotated::annotation_, annotationLeaf(), false);
    attribute("id", &annotated::id_);
    any_attribute(&openAttrs::attrs_);

    attribute("name", &notation::name_).required(true);
    attribute("public", &notation::public_).required(true);
    attribute("system", &notation::system_);
  }

  void namedAttributeGroupLeaf::model() {
    // annotated.
    ptrmember("xs:annotation", &annotated::annotation_, annotationLeaf(), false);
    attribute("id", &annotated::id_);
    any_attribute(&openAttrs::attrs_);
    
    attribute("name", &namedAttributeGroup::name_).required(true);
  }

  void includeLeaf::model() {
    // annotated.
    ptrmember("xs:annotation", &annotated::annotation_, annotationLeaf(), false);
    attribute("id", &annotated::id_);
    any_attribute(&openAttrs::attrs_);
    
    attribute("schemaLocation", &_include::schemaLocation_);
  }

  void redefineContentsLeaf::model() {
    item("xs:annotation", annotationLeaf());
    item("&redefinable", redefinableLeaf());
  }

  void redefineLeaf::model() {
    any_attribute(&openAttrs::attrs_);
    member("&redefineContent", &redefine::contents_, redefineContentsLeaf());
  }

  void importLeaf::model() {
    // annotated.
    ptrmember("xs:annotation", &annotated::annotation_, annotationLeaf(), false);
    attribute("id", &annotated::id_);
    any_attribute(&openAttrs::attrs_);
    
    attribute("namespace", &import::namespace_);
    attribute("schemaLocation", &import::schemaLocation_);
  }

  void directivesLeaf::model() {
    item("xs:include", includeLeaf());
    item("xs:import", importLeaf());
    item("xs:redefined", redefineLeaf());
    item("xs:annotation", annotationLeaf());
  }

  void schemaTopLeaf::model() {
    item("&redifinable", redefinableLeaf());
    item("xs:element", topLevelElementLeaf());
    item("xs:attribute", attributeLeaf());
    item("xs:notation", notationLeaf());
  }

  void annotatedSchemaTopLeaf::model() {
    member("&schemaTop", &annotatedSchemaTop::schemaTop_, schemaTopLeaf());
    member("xs:annotation", &annotatedSchemaTop::annotations_, annotationsLeaf(), 
	   0, aka::unbounded);
  }

  void instantiate_xiso() {
#define NS_XMLSCHEMA "http://www.w3.org/2001/XMLSchema"
#define NS_XML "http://www.w3.org/XML/1998/namespace"
#define NS_HFP "http://www.w3.org/2001/XMLSchema-hasFacetAndProperty"
    aka::xmlns("xml", NS_XML);
    aka::xmlns("xs", NS_XMLSCHEMA);
    aka::xmlns("hfp", NS_HFP);
    aka::doctype("xs:minExclusive", facetLeaf());
    aka::doctype("xs:minInclusive", facetLeaf());
    aka::doctype("xs:maxExclusive", facetLeaf());
    aka::doctype("xs:maxInclusive", facetLeaf());
    aka::doctype("xs:fractionDigits", numFacetLeaf());
    aka::doctype("xs:length", numFacetLeaf());
    aka::doctype("xs:minLength", numFacetLeaf());
    aka::doctype("xs:maxLength", numFacetLeaf());
    aka::doctype("xs:enumeration", noFixedFacetLeaf());
    aka::doctype("xs:whiteSpace", whiteSpaceLeaf());
    aka::doctype("xs:pattern", noFixedFacetLeaf());
    aka::doctype("xs:simpleType", topLevelSimpleTypeLeaf());
    aka::doctype("xs:schema", schemaLeaf());
  }

  void schemaLeaf::model() {
    member("&directives", &schema::directives_, directivesLeaf(), 0, aka::unbounded);
    member("&annotatedSchemaTops", &schema::annotatedSchemaTops_, 
	   annotatedSchemaTopsLeaf(), 0, aka::unbounded);
    attribute("targetNamespace", &schema::anyURI_);
    attribute("version", &schema::version_);
    attribute("finalDefault", &schema::finalDefault_);
    attribute("blockDefault", &schema::blockDefault_);
    attribute("attributeFormDefault", &schema::attributeFormDefault_).set_default("unqualified");
    attribute("elementFormDefault", &schema::elementFormDefault_).set_default("unqualified");
    attribute("id", &schema::id_);
    attribute("xml:lang", &schema::lang_);
  }

}
