#!/bin/bash
SJISSOURCES="apple.csv babel.cpp babel.h cp932.csv euc-uni.csv scoremap.csv sjis-euc.csv utc.csv ygg.cpp ygg.h ygg_test.cpp"

clean()
{
    rm -f *.dat
    rm -f ${SJISSOURCES} test.sox test.xml csv.sox
    rm -f *.sjis
}


extract()
{
    clean
    unzip ygg.zip
    unzip babel.zip
}

convert()
{
    for FILE in $SJISSOURCES
      do
      echo converting $FILE to euc-jp.
      SJISFILE=${FILE}.sjis
      if [ ! -f $SJISFILE ]
	  then
	  EUCFILE=${FILE}
	  mv $EUCFILE $SJISFILE
	  nkf --unix $SJISFILE > $EUCFILE
      fi
    done
}    


usage()
{
    echo sjisutil.sh
}

OPTION=$1
if [ -z $OPTION ]
then
    usage
    exit 1
fi

case $OPTION in
    "convert")
	convert
    ;;
    "clean")
	clean
    ;;
    "extract")
	extract
    ;;
    *)
	usage
    ;;
esac

exit 0

