/* -*- c++ -*- */
#ifndef BASKET_H__
#define BASKET_H__

#include <akaxiso/content_model.h>
#include <list>

struct basket : std::list<aka::item> {};
typedef std::string fruit;
typedef std::string vesitable; 

struct egg {
  egg(){}
  egg(float weight) : weight_(weight){}
  float weight_;
};

typedef std::list<egg> eggs;


// leaves.

struct fruit_leaf : aka::simpletype<std::string, fruit_leaf> {};
struct vesitable_leaf : aka::simpletype<std::string, vesitable_leaf> {};


namespace xiso {

  template<> struct leaf<eggs> : public aka::sequential_array<eggs> {  };

  template<> struct leaf<egg> : public aka::simplecontent<egg> {
    void model() {
      attribute("weight", &egg::weight_);
    }
  };

  template<>
  struct leaf<basket> : public aka::sequential_choice<basket> {
    void model() {
      item("fruit", fruit_leaf());
      item("vesitable", vesitable_leaf());
      item("egg", leaf<eggs>(), 0, aka::unbounded);
    }
  };

}



#endif
