/* -*- c++ -*- */
#ifndef AKAXISO_ALL_H__
#define AKAXISO_ALL_H__

/** @file akaxiso/classes/all.h */

#include <akaxiso/classes/simpletype.h>
#include <akaxiso/classes/attribute.h>
#include <akaxiso/classes/memberdef.h>

namespace aka2 {

  template<class L>
  class all_op_dispatcher : public all_op {
  public:
    virtual schematype_id get_schematype() const { return all_id; }
    virtual const qname& get_typename() const { return L::typename_; }
    /** creatable */
    virtual void construct(void *e) const {  L::construct(e); }
    virtual void copy_construct(void *e, const void *src) const { L::copy_construct(e, src); }
    virtual void destruct(void *e) const { L::destruct(e); }
    virtual size_t class_size() const { return L::class_size(); }
    virtual bool equals(const void *lhs, const void *rhs) const {
      return L::equals(lhs, rhs);
    }

    /** attribute_info getter. */
    virtual const attribute_types *get_attribute_types() const {
      return &L::attribute_types_;
    }
    virtual const any_member *get_anyattr_type() const { return 0; }
    /** all_info getter. */
    virtual const member_map &get_member_map() const {
      return L::member_map_;
    }
  };

  template<class L, class T>
  struct all_statics {
    static member_map member_map_;
    static qname typename_;
    static all_op_dispatcher<L> dispatcher_;
    static occurrence occ_;
  };

  template<class L, class T>
  member_map all_statics<L, T>::member_map_;

  template<class L, class T>
  qname all_statics<L, T>::typename_;

  template<class L, class T>
  aka2::occurrence all_statics<L, T>::occ_;

  template<class L, class T>
  all_op_dispatcher<L> all_statics<L, T>::dispatcher_;

  
  template<class T, class L=xiso::leaf<T> >
  class all : public all_statics<L, T>, 
	      public attributes<L, T>,
	      public memberdef<L, T> {
  public:
    typedef T value_type;
    
    virtual ~all(){}
    
    static member_type* register_membertype(const member_type &mtype) {
      std::pair<member_map::iterator, bool> res =
    	L::member_map_.insert(member_map::value_type(mtype.get_name(), mtype));
      if (!res.second)
	throw internal_error();
      return &res.first->second;
    }
    
    static void initialize() {
      if (!system_type_registry().add(L()))
      	return;
      L::member_map_.clear();
      L::attribute_types_.clear();
      L l; l.model(); // VC6 does not accept L().model();
    }

    static void uninitialize() {
      L::member_map_.clear();
      L::attribute_types_.clear();
    }

    static void construct(void *e) {
      new (e) T();
      all_construct(e, L::dispatcher_);
    }
    static void copy_construct(void *e, const void *src) {
      new (e) T(*static_cast<const T*>(src));
    }
    static size_t class_size() { return sizeof(T); }
    static void destruct(void *elm) { static_cast<T*>(elm)->~T(); }

    static bool equals(const void *lhs, const void *rhs) {
      return all_equals(lhs, rhs, L::dispatcher_);
    }

    static element_op* get_attribute_dispatcher() { return &L::dispatcher_; }
    static default_op* create_default_op() { return 0; }

    static void occurrence(int minOccurs, int maxOccurs) {
      aka::occurrence occ(minOccurs, maxOccurs);
      if (!is_all_occurrence(occ))
	throw internal_error();
      L::occ_ = occ;
    }

    static void xmltype(const std::string &name) {
      L::typeinfo_.set_name(qname(name));
    }
  };

} // namespace aka2

#endif /* AKAXISO_ALL_H__ */
