/* -*- c++ -*- */
#ifndef OSIXAKA_H__
#define OSIXAKA_H__

#include <akaxiso/akaxiso.h>
#include "processor.h"
#include "exception.h"
#include "akaxisonizer.h"

class osixaka {
  bool do_dump_;
  bool verbose_;
  std::ostream &ostm_;
  registry registry_;
  akaxisonizer akaxisonizer_;
  std::string dirpath_;
  aka::shared_ptr<xs::schema> target_schema_;
public:
  osixaka(std::ostream &ostm, 
	  bool do_dump = false, bool verbose = false)
    : do_dump_(do_dump), 
      verbose_(verbose), ostm_(ostm),
      akaxisonizer_(registry_, verbose),
      target_schema_(0) {}
  int parse(const std::string &filepath);
  int process();
  void akaxisonize();
  static void initialize();
  void reset();
  void generate(const std::string &outputdir);
};

#endif
