//CUPPA:include=+
#include <akaxiso/akaxiso.h>
#include <akaxiso/content_model.h>
//CUPPA:include=-
#include <cppunit/extensions/HelperMacros.h>
#include <cppunit/TestAssert.h>



//CUPPA:namespace=+
//CUPPA:namespace=-


namespace {

  struct seq1 {
    std::string value_;
  };

  typedef std::list<seq1> seq1array;

  struct seq {
    seq1array seq1_;
  };

  struct seq1_leaf : aka::sequence<seq1, seq1_leaf> {
    void model() {
      member("ns2:value", &seq1::value_);
    }
  }; 
  typedef aka2::sequential_array<seq1array, seq1_leaf> seq1array_leaf;

  struct seq_leaf : aka::sequence<seq, seq_leaf> {
    void model() {
      member("ns1:seq1", &seq::seq1_, seq1array_leaf(), 
	     0, aka2::unbounded);
    }
  }; 

  void initialize_() {
    aka2::initialize();
    aka2::xmlns("ns1", "testns1");
    aka2::xmlns("ns2", "testns2");
    aka2::doctype("test", seq_leaf());
  }

  void uninitialize_() {
    aka2::uninitialize();
  }
}


class namespaceTest : public CppUnit::TestFixture {
  CPPUNIT_TEST_SUITE(namespaceTest);
//CUPPA:suite=+
  CPPUNIT_TEST(test_ok);
  CPPUNIT_TEST(test_error);
//CUPPA:suite=-
  CPPUNIT_TEST_SUITE_END();
private:

public:

  virtual void setUp() { 
    initialize_();
  }

  virtual void tearDown(){
    uninitialize_();
  }

//CUPPA:decl=+
  void test_parse_ok(const std::string &doc) {
    std::string err;
    try {
      aka2::xerces_parser xp;
      xp.parse(doc);
      aka2::yggxml_parser yp;
      yp.parse(doc);
    }
    catch ( const std::exception &e) {
      err = e.what();
    }
    CPPUNIT_ASSERT_MESSAGE("Failed to handle default namespace.", err.empty());
  }

  void test_parse_ng(const std::string &doc) {
    std::string xerces_err;
    std::string ygg_err;
    try {
      aka2::xerces_parser xp;
      xp.parse(doc);
    }
    catch ( std::exception &e ) {
      xerces_err = e.what();
    }
    try {
      aka2::yggxml_parser yp;
      yp.parse(doc);
    }
    catch (const std::exception &e) {
      ygg_err = e.what();
    }
    CPPUNIT_ASSERT_MESSAGE("Failed to handle default namespace.", 
			   !xerces_err.empty() && !ygg_err.empty());
  }

  void test_ok() {
    const char nested_def_ns[] = 
      "<?xml version=\"1.0\"?>"
      "<!-- test for nested default xmlns attribtes. -->"
      "<test>"
      "<seq1 xmlns=\"testns1\">"
      "<value xmlns=\"testns2\">test</value>"
      "</seq1>"
      "</test>";

    test_parse_ok(nested_def_ns);
  }

  void test_error() {
    const char nsdef_e0[] =
      "<?xml version=\"1.0\"?>"
      "<!-- test for nested default xmlns attribtes. -->"
      "<test>"
      "<seq1 xmlns:ns1=\"testns1\" xmlns=\"testns1\">"
      "<value xmlns:ns2=\"testns2\">test</value>"
      "</seq1>"
      "</test>";

    const char nsdef_e1[] =
      "<?xml version=\"1.0\"?>"
      "<!-- test for nested default xmlns attribtes. -->"
      "<test>"
      "<seq1 xmlns:ns1=\"testns1\" xmlns=\"testns1\">"
      "<ns2:value xmlns=\"testns2\">test</ns2:value>"
      "</seq1>"
      "</test>";

    const char nsdef_e2[] =
      "<?xml version=\"1.0\"?>"
      "<!-- test for nested default xmlns attribtes. -->"
      "<test>"
      "<seq1 xmlns:ns1=\"testns1\" xmlns:ns2=\"testns1\" "
      " ns2:attr=\"attr\" ns1:attr=\"attr\">"
      "</seq1>"
      "</test>";

    const char dup_attribute[] =
      "<?xml version=\"1.0\"?>"
      "<!-- test for nested default xmlns attribtes. -->"
      "<test>"
      "<seq1 xmlns:ns1=\"testns1\" xmlns:ns2=\"testns1\" "
      "ns2:attr=\"attr\" ns1:attr=\"attr\">"
      "</seq1>"
      "</test>";


    test_parse_ng(nsdef_e0);
    test_parse_ng(nsdef_e1);
    test_parse_ng(nsdef_e2);
    test_parse_ng(dup_attribute);
  }


//CUPPA:decl=-
};

//CUPPA:impl=+
//CUPPA:impl=-

CPPUNIT_TEST_SUITE_REGISTRATION(namespaceTest);
