#include <akaxiso/akaxiso.h>
#include <akaxiso/content_model.h>
#include <iostream>

#include "tutorial6.h"

int main() {

  aka::initialize();
  instantiate_xiso();

  {
    aka::xml_parser parser;
    aka::document doc = parser.parse_stdin();
    std::cout << "Document (" << doc.get_name() << ") is parsed." << std::endl;
    
    assert(aka::document_of(doc, "menu"));

    menu *root = aka::root_cast<menu>(doc);

    std::cout << "Menu" << std::endl
	      << " Breakfast : " << root->breakfast_ << std::endl
	      << " Lunch     : " << root->lunch_ << std::endl
	      << " Dinner    : " << root->dinner_ << std::endl;
  }
    
  aka::uninitialize();
}
