/* -*- c++ -*- */
#ifndef AKAXISO_CLASSES_ANY_OP_H__
#define AKAXISO_CLASSES_ANY_OP_H__

#include <akaxiso/classes/any.h>
#include <assert.h>

namespace aka2 {
  struct default_op;


  class any_attributes_op : public element_op {
  public:
    virtual schematype_id get_schematype() const { return any_attribute_id; }
    virtual const qname& get_typename() const { 
      if (typename_.qualified().empty())
	typename_ = qname("xs:anyAttribute");  /** !!!!!! */
      return typename_;
    }
    virtual bool equals(const void *lhs, const void *rhs) const;
    
    /** creatable */
    virtual void construct(void *e) const { 
      new (e) any_attributes();
    }
    virtual void copy_construct(void *e, const void *src) const { 
      new (e) any_attributes(*static_cast<const any_attributes*>(src));
    }
    virtual void destruct(void *e) const { assert(!"Must not reach here.");  }
    virtual size_t class_size() const { assert(!"Must not reach here."); return 0; }
    
    /** attribute_info getter. */
    virtual const attribute_types *get_attribute_types() const { 
      assert(!"Must not be called.");
      return 0; 
    }
    virtual const any_member *get_anyattr_type() const {
      assert(!"Must not be called.");
      return 0; 
    }

    static any_attributes_op dispatcher_;
    static qname typename_;
  };



  class any_op : public element_op {
  public:
    static void initialize();
    static void uninitialize();

    virtual schematype_id get_schematype() const { return any_id; }
    virtual const qname& get_typename() const { return typename_; }
    /** attribute_types getter. */
    virtual const attribute_types *get_attribute_types() const { 
      return 0; 
    }
    virtual const any_member *get_anyattr_type() const {
      return &attributes_;
    }
    virtual bool equals(const void *lhs, const void *rhs) const;

    virtual void construct(void *e) const { new (e) any(); }
    virtual void copy_construct(void *e, const void *src) const { 
      new (e) any(*static_cast<const any*>(src));
    }
    virtual void destruct(void *e) const { 
      static_cast<any*>(e)->~any();
    }
    virtual size_t class_size() const { return sizeof(any); }

    static default_op* create_default_op() { return 0; }
    
    static qname typename_;
    static any_op dispatcher_;
    static any_member attributes_;
  };


  class any_array_op : public element_op {
  public:
    static void initialize();
    static void uninitialize();

    virtual schematype_id get_schematype() const { return any_array_id; }
    virtual const qname& get_typename() const { return typename_; }
    
    /** creatable */
    virtual void construct(void *e) const { new (e) any_array(); }
    virtual void copy_construct(void *e, const void *src) const { 
      new (e) any_array(*static_cast<const any_array*>(src));
    }
    virtual void destruct(void *e) const { 
      static_cast<any_array*>(e)->~any_array();
    }
    virtual size_t class_size() const { return sizeof(any_array); }

    virtual bool equals(const void *lhs, const void *rhs) const;
    
    /** attribute_info getter. */
    virtual const attribute_types *get_attribute_types() const { 
      assert(!"Must not be called.");
      return 0; 
    }
    virtual const any_member *get_anyattr_type() const {
      assert(!"Must not be called.");
      return 0; 
    }

    static default_op* create_default_op() { return 0; }

    static qname typename_;
    static any_array_op dispatcher_;
  };


}

#endif
