#include "parser.h"

#ifdef USE_XERCESC
# include "xerces/xerces_parser.h"
#else
# include "yggdrasil/ygg_parser.h"
#endif

using namespace aka2;

document aka2::parse(std::istream &istm) {
  xml_parser parser;
  return parser.parse(istm);
}

document aka2::parse(const char *document) {
  xml_parser parser;
  return parser.parse(document);
}

document aka2::parse(const std::string &document) {
  xml_parser parser;
  return parser.parse(document);
}

document parse_stdin() {
  xml_parser parser;
  return parser.parse_stdin();
}

document parse_file(const std::string &filename) {
  xml_parser parser;
  return parser.parse_file(filename);
}
