#include "simpletype_handler.h"
#include <cassert>
#include <sstream>

using namespace aka2;


simpletype_handler::simpletype_handler(const qname &tagname, 
				       void *e, 
				       int depth,
				       const simpletype_op &sop, 
				       parser_context &context) 
  : handler(context, depth, tagname), elm_(e), sop_(sop) {}


parse_result simpletype_handler::query_element(const qname &tagname, 
					       const attribute_values &attrs) {
  assert(!"Must not be called.");
  return ok;
}

parse_result simpletype_handler::query_next(const qname &tagname, 
					       const attribute_values &attrs) {
  assert(!"Must not be called.");
  return ok;
}


parse_result simpletype_handler::end_element(const qname &tagname){
  return ok;
}

bool simpletype_handler::parse_entity(const std::string &entity) {
  std::istringstream istm(entity);
  try {
    sop_.read_text(elm_, istm, context_.get_preconditions());
    return true;
  }
  catch ( const std::exception &e ) {
    context_.report(e.what(), __FILE__, __LINE__);
  }
  catch ( ... ) {
    context_.report("Unhandled parse error on parsing entity.", __FILE__, __LINE__);
  }
  return false;
}


// Mainly used for choices.
node simpletype_handler::get_node(){
  return node(elm_, sop_);
}

void simpletype_handler::receive_child(const node &child){
  assert(!"Must not be called.");
  assert(&sop_ == &child.op());
}

bool simpletype_handler::can_skip() {
  return false;
}

void simpletype_handler::abort() {
}
