/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.wizards;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.model.SiteBookmark;
import org.eclipse.update.internal.ui.model.UpdateModel;

public class NewUpdateSiteDialog
extends Dialog {
    protected Text name;
    protected Text url;
    private Button okButton;

    public NewUpdateSiteDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.okButton.setEnabled(false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.widthHint = 350;
        composite.setLayoutData((Object)data);
        Label label = new Label(composite, 0);
        label.setText(UpdateUI.getString("NewUpdateSiteDialog.name"));
        this.name = new Text(composite, 2048);
        this.name.setLayoutData((Object)new GridData(768));
        this.name.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewUpdateSiteDialog.this.verifyComplete();
            }
        });
        label = new Label(composite, 0);
        label.setText(UpdateUI.getString("NewUpdateSiteDialog.url"));
        this.url = new Text(composite, 2048);
        this.url.setLayoutData((Object)new GridData(768));
        this.url.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewUpdateSiteDialog.this.verifyComplete();
            }
        });
        this.initializeFields();
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void initializeFields() {
        this.url.setText("http://");
    }

    protected void okPressed() {
        this.update();
        super.okPressed();
    }

    protected void update() {
        try {
            UpdateModel model = UpdateUI.getDefault().getUpdateModel();
            SiteBookmark bookmark = new SiteBookmark(this.name.getText(), new URL(this.url.getText()), false);
            model.addBookmark(bookmark);
            model.saveBookmarks();
        }
        catch (MalformedURLException malformedURLException) {}
    }

    private void verifyComplete() {
        if (this.okButton == null) {
            return;
        }
        if (this.name.getText().trim().length() == 0 || this.url.getText().trim().length() == 0) {
            this.okButton.setEnabled(false);
            return;
        }
        try {
            URL newURL = new URL(URLDecoder.decode(this.url.getText().trim(), "UTF-8"));
            if (this.url.getEditable()) {
                this.okButton.setEnabled(!newURL.getProtocol().equals("file"));
            } else {
                this.okButton.setEnabled(true);
            }
        }
        catch (Exception exception) {
            this.okButton.setEnabled(false);
        }
    }
}

