/**
 * CSVDataAcquireModule.java
 * Created on 2003/10/12
 * Copyright (c) by es , All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND 
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
 * PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE 
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY 
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF 
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package net.prixdami.alexis.dataaccess.csv;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

import net.prixdami.alexis.logic.Message;
import net.prixdami.alexis.logic.MessageChunk;
import net.prixdami.alexis.dataaccess.DataAcquireModule;
import net.prixdami.alexis.util.SM;

/**
 * CSVt@C̃f[^擾NX
 * @author es
 * @deprecated Â̂ŏĂ
 */
public class CSVDataAcquireModule extends DataAcquireModule {

	private Properties myProp;

    public void init(Properties prop) {
		myProp = prop;
    }

    public Message[] acquire(String target, int start, int max) throws IOException {
		String filename = myProp.getProperty(target + ".logFileName");

        Message[] mc;
        List l;

        int count = 0;
        while (SM.getWriteCount() > 0 && count < 10) {
            try {
                java.lang.Thread.sleep(200);
            } catch (Exception e) {
                count = 10;
                break;
            }
            count++;
        }

        if (SM.getWriteCount() > 0) {
            throw new IOException("lock faild : timeout");
        }

        try {
            SM.addReadCount();
            l = getLog(filename);
        } finally {
            SM.delReadCount();
        }

        int mcSize = 0;
        int logSize = l.size();

        if (start <= 0) {
            start = 0;
        }

        if (logSize >= start) {
            if (logSize - start >= max && max > 0) {
                mcSize = max;
            } else {
                mcSize = logSize - start;
            }
        }

        mc = new Message[mcSize];
        for (int i = 0; i < mc.length; i++) {
            mc[i] = new MessageChunk((String) l.get(logSize - start - i - 1));
        }

        return mc;
    }

    private synchronized List getLog(String filename) throws IOException {
        ArrayList al;
        BufferedReader in;

        try {
            al = new ArrayList();
            in = new BufferedReader(new FileReader(filename));

            int i = 0;
            for (boolean b = false; !b;) {
                String buff = in.readLine();
                if (buff == null) {
                    b = true;
                } else {
                    al.add(buff);
                }
            }
            in.close();
        } finally {
            in = null;
        }
        return al;
    }

}