/**
 * CSVDataStoreModule.java
 * Created on 2003/10/13
 * Copyright (c) by es , All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND 
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
 * PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE 
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY 
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF 
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package net.prixdami.alexis.dataaccess.csv;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;

import net.prixdami.alexis.logic.Message;
import net.prixdami.alexis.util.SM;

/**
 * CSVt@Cւ̃f[^i[NX
 * @author es
 * @deprecated Â
 */
public class CSVDataStoreModule extends net.prixdami.alexis.dataaccess.DataStoreModule {

    private Properties myProp;

    /* ( Javadoc)
     * @see net.prixdami.alexis.logic.module.DataStoreModule#init(java.util.Properties)
     */
    public synchronized void init(Properties prop) {
        myProp = prop;
    }

    public void store(String target, Message mc) throws IOException {
        String filename = myProp.getProperty(target + ".logFileName");
        int max = Integer.parseInt(myProp.getProperty(target + ".maxStoreMessage"));

        FileWriter fw = null;

        int count = 0;
        while ((SM.getWriteCount() > 0 || SM.getReadCount() > 0) && count < 5) {
            try {
                Thread.sleep(200);
            } catch (Exception e) {
                count = 5;
                break;
            }
            count++;
        }

        if (SM.getWriteCount() > 0 || SM.getReadCount() > 0) {
            throw new IOException("lock faild : timeout");
        }

        try {
            SM.addWriteCount();
            logArray(filename, max, mc.toString());
        } finally {
            SM.delWriteCount();
            fw = null;
        }
    }

    /**
     * VKOǉ.
     * ߍs̐؎̂ɍs
     * @param filename Ot@C
     * @param maxCount JEg
     * @param append ǉs
     * @throws IOException
     */
    private synchronized void logArray(String filename, int maxCount, String append) throws IOException {
        ArrayList al;
        BufferedReader in;

        try {
            al = new ArrayList(maxCount);
            in = new BufferedReader(new FileReader(filename));

            int i = 0;
            for (boolean b = false; !b;) {
                String buff = in.readLine();
                if (buff == null) {
                    b = true;
                } else {
                    al.add(buff);
                    i++;
                    if (i >= maxCount) {
                        al.remove(0);
                    }
                }
            }
            in.close();
            al.add(append);

            BufferedWriter out = new BufferedWriter(new FileWriter(filename, false));
            for (int j = 0; j < al.size(); j++) {
                out.write((String) al.get(j));
                out.newLine();
            }
            out.close();
            out = null;
        } finally {
            al = null;
            in = null;
        }
    }

}