/**
 * LogicParameter.java
 * Created on 2003/10/07
 * Copyright (c) by es , All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND 
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
 * PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE 
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY 
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF 
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package net.prixdami.alexis.logic;

import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import net.prixdami.alexis.Const;
import net.prixdami.alexis.system.SystemParameter;

/**
 * Logicpp[^NX
 * HttpServletRequest烊NGXg̃p[^AHTTPϐ܂Ƃ߂ăbv
 * @author es
 */
public class LogicParameter {

	public static final String PARAM_IP = "http_remort_addr";
	public static final String PARAM_HOST = "http_remort_host";
	public static final String PARAM_REF = "http_referer";
	private static final String encoding = SystemParameter.getSystemProperty(Const.SYSTEM_CHARSET);

    private Map params;

    public LogicParameter() {
        params = new HashMap();
    }

    public LogicParameter(HttpServletRequest request) {
        this();
		String enc = request.getCharacterEncoding();
        
        Map tempmap = request.getParameterMap();
        for (Iterator i = tempmap.keySet().iterator(); i.hasNext();) {
            String key = (String) i.next();
            String[] data = (String[]) tempmap.get(key);
            if (data == null || data.length == 0) {
                params.put(key, "");
            } else if (data.length == 1) {
            	String hoge = null;
                try {
					byte[] b = ((String[]) data)[0].getBytes("iso-8859-1");
                    hoge = new String(b, 0, b.length, encoding);
                } catch (UnsupportedEncodingException e) {
                    // TODO ܂߂ɂ
                    e.printStackTrace();
                }
                params.put(key, hoge);
            } else {
                params.put(key, data);
            }
        }
        for(Enumeration e = request.getHeaderNames(); e.hasMoreElements();) {
        	String headerkey = ((String)e.nextElement()).toLowerCase();
			params.put("http_" + headerkey, request.getHeader(headerkey));
        }
		params.put(PARAM_IP, request.getRemoteAddr());
		params.put(PARAM_HOST, request.getRemoteHost());
    }

    public LogicParameter(Map request) {
        params = new HashMap(request);
    }

	public Map getMap() {
		return params;
	}

    public void clear() {
        params.clear();
    }

    public Iterator iterator() {
        return params.keySet().iterator();
    }

    public void put(String key, String data) {
        params.put(key, data);
    }

    public void put(String key, String[] data) {
        params.put(key, data);
    }

    public boolean containsKey(String key) {
        return params.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return params.containsValue(value);
    }

	public String get(String key) {
		Object obj = params.get(key);
		if (obj == null) {
			return null;
		}
		if (obj instanceof String[]) {
			return ((String[]) obj)[0];
		}
		if (obj instanceof String) {
			return (String) obj;
		}
		return obj.toString();
	}

	public String get(String key, boolean killNull) {
		String obj = get(key);
		if(killNull) {
			return obj == null ? "" : obj;
		} else {
			return obj;
		}
	}

	public Object getObject(String key) {
		Object obj = params.get(key);
		if (obj == null) {
			return null;
		}
		return obj;
	}

    public String[] gets(String key) {
        Object obj = params.get(key);
        if (obj == null) {
            return null;
        }
        if (obj instanceof String[]) {
            return (String[]) obj;
        }
        return new String[] {((String) obj)};
    }

}
