/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.el;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import javax.faces.el.EvaluationException;
import javax.faces.el.PropertyNotFoundException;
import javax.faces.el.PropertyResolver;
import javax.faces.el.ReferenceSyntaxException;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertyResolverImpl
extends PropertyResolver {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$myfaces$el$PropertyResolverImpl == null ? (class$org$apache$myfaces$el$PropertyResolverImpl = PropertyResolverImpl.class$("org.apache.myfaces.el.PropertyResolverImpl")) : class$org$apache$myfaces$el$PropertyResolverImpl));
    private static final Object[] NO_ARGS = new Object[0];
    static /* synthetic */ Class class$org$apache$myfaces$el$PropertyResolverImpl;
    static /* synthetic */ Class class$java$lang$Object;

    public Object getValue(Object base, Object property) throws EvaluationException, PropertyNotFoundException {
        try {
            if (base == null || property == null || property instanceof String && ((String)property).length() == 0) {
                return null;
            }
            if (base instanceof Map) {
                return ((Map)base).get(property);
            }
            return PropertyResolverImpl.getProperty(base, property.toString());
        }
        catch (RuntimeException e) {
            log.error((Object)("Exception getting value of property " + property + " of bean " + base != null ? base.getClass().getName() : "NULL"), (Throwable)e);
            throw e;
        }
    }

    public Object getValue(Object base, int index) throws EvaluationException, PropertyNotFoundException {
        try {
            if (base == null) {
                return null;
            }
            try {
                if (base.getClass().isArray()) {
                    return Array.get(base, index);
                }
                if (base instanceof List) {
                    return ((List)base).get(index);
                }
            }
            catch (IndexOutOfBoundsException e) {
                return null;
            }
            throw new ReferenceSyntaxException("Must be array or List. Bean: " + base.getClass().getName() + ", index " + index);
        }
        catch (RuntimeException e) {
            log.error((Object)("Exception getting value for index " + index + " of bean " + base != null ? base.getClass().getName() : "NULL"), (Throwable)e);
            throw e;
        }
    }

    public void setValue(Object base, Object property, Object newValue) throws EvaluationException, PropertyNotFoundException {
        try {
            if (base == null) {
                throw new PropertyNotFoundException("Null bean, property: " + property);
            }
            if (property == null || property instanceof String && ((String)property).length() == 0) {
                throw new PropertyNotFoundException("Bean: " + base.getClass().getName() + ", null or empty property name");
            }
            if (base instanceof Map) {
                ((Map)base).put(property, newValue);
                return;
            }
            PropertyResolverImpl.setProperty(base, property.toString(), newValue);
        }
        catch (RuntimeException e) {
            log.error((Object)("Exception setting property " + property + " of bean " + base != null ? base.getClass().getName() : "NULL"), (Throwable)e);
            throw e;
        }
    }

    public void setValue(Object base, int index, Object newValue) throws EvaluationException, PropertyNotFoundException {
        try {
            if (base == null) {
                throw new PropertyNotFoundException("Null bean, index: " + index);
            }
            try {
                if (base.getClass().isArray()) {
                    Array.set(base, index, newValue);
                    return;
                }
                if (base instanceof List) {
                    ((List)base).set(index, newValue);
                    return;
                }
            }
            catch (IndexOutOfBoundsException e) {
                throw new PropertyNotFoundException("Bean: " + base.getClass().getName() + ", index " + index, e);
            }
            throw new EvaluationException("Bean must be array or List. Bean: " + base.getClass().getName() + ", index " + index);
        }
        catch (RuntimeException e) {
            log.error((Object)("Exception setting value of index " + index + " of bean " + base != null ? base.getClass().getName() : "NULL"), (Throwable)e);
            throw e;
        }
    }

    public boolean isReadOnly(Object base, Object property) {
        try {
            if (base == null || property == null || property instanceof String && ((String)property).length() == 0) {
                return false;
            }
            if (base instanceof Map) {
                return false;
            }
            PropertyDescriptor propertyDescriptor = PropertyResolverImpl.getPropertyDescriptor(base, property.toString());
            return propertyDescriptor.getWriteMethod() == null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isReadOnly(Object base, int index) {
        try {
            if (base == null) {
                return false;
            }
            if (base instanceof List || base.getClass().isArray()) {
                return false;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Class getType(Object base, Object property) {
        try {
            if (base == null || property == null || property instanceof String && ((String)property).length() == 0) {
                return null;
            }
            if (base instanceof Map) {
                Object value = ((Map)base).get(property);
                Class clazz = value == null ? (class$java$lang$Object == null ? (class$java$lang$Object = PropertyResolverImpl.class$("java.lang.Object")) : class$java$lang$Object) : value.getClass();
                return clazz;
            }
            PropertyDescriptor propertyDescriptor = PropertyResolverImpl.getPropertyDescriptor(base, property.toString());
            return propertyDescriptor.getPropertyType();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Class getType(Object base, int index) {
        try {
            if (base == null) {
                return null;
            }
            if (base.getClass().isArray()) {
                return base.getClass().getComponentType();
            }
            if (base instanceof List) {
                Object value = ((List)base).get(index);
                return value != null ? value.getClass() : (class$java$lang$Object == null ? (class$java$lang$Object = PropertyResolverImpl.class$("java.lang.Object")) : class$java$lang$Object);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void setProperty(Object base, String name, Object newValue) {
        PropertyDescriptor propertyDescriptor = PropertyResolverImpl.getPropertyDescriptor(base, name);
        Method m = propertyDescriptor.getWriteMethod();
        if (m == null) {
            throw new PropertyNotFoundException("Bean: " + base.getClass().getName() + ", property: " + name);
        }
        if ((m = MethodUtils.getAccessibleMethod((Method)m)) == null) {
            throw new PropertyNotFoundException("Bean: " + base.getClass().getName() + ", property: " + name + " (not accessible!)");
        }
        try {
            m.invoke(base, newValue);
        }
        catch (Throwable t) {
            throw new EvaluationException("Bean: " + base.getClass().getName() + ", property: " + name, t);
        }
    }

    public static Object getProperty(Object base, String name) {
        PropertyDescriptor propertyDescriptor = PropertyResolverImpl.getPropertyDescriptor(base, name);
        Method m = propertyDescriptor.getReadMethod();
        if (m == null) {
            throw new PropertyNotFoundException("Bean: " + base.getClass().getName() + ", property: " + name);
        }
        if ((m = MethodUtils.getAccessibleMethod((Method)m)) == null) {
            throw new PropertyNotFoundException("Bean: " + base.getClass().getName() + ", property: " + name + " (not accessible!)");
        }
        try {
            return m.invoke(base, NO_ARGS);
        }
        catch (Throwable t) {
            throw new EvaluationException("Bean: " + base.getClass().getName() + ", property: " + name, t);
        }
    }

    public static PropertyDescriptor getPropertyDescriptor(Object base, String name) {
        PropertyDescriptor propertyDescriptor;
        try {
            propertyDescriptor = PropertyResolverImpl.getPropertyDescriptor(Introspector.getBeanInfo(base.getClass()), name);
        }
        catch (IntrospectionException e) {
            throw new PropertyNotFoundException("Bean: " + base.getClass().getName() + ", property: " + name, e);
        }
        return propertyDescriptor;
    }

    public static PropertyDescriptor getPropertyDescriptor(BeanInfo beanInfo, String propertyName) {
        PropertyDescriptor[] propDescriptors = beanInfo.getPropertyDescriptors();
        if (propDescriptors != null) {
            int len = propDescriptors.length;
            for (int i = 0; i < len; ++i) {
                if (!propDescriptors[i].getName().equals(propertyName)) continue;
                return propDescriptors[i];
            }
        }
        throw new PropertyNotFoundException("Bean: " + beanInfo.getBeanDescriptor().getBeanClass().getName() + ", property: " + propertyName);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

