/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jsf;

import java.util.ResourceBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import tk.eclipse.plugin.jsf.JSFPlugin;
import tk.eclipse.plugin.jsf.wizards.JSPWizard;
import tk.eclipse.plugin.jsf.wizards.ManagedBeanWizard;

public class Util {
    public static IEditorPart getActiveEditor() {
        IWorkbenchPage page = Util.getActivePage();
        IEditorPart editorPart = page.getActiveEditor();
        return editorPart;
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        return page;
    }

    public static void openJSPWizard(Object container, String fileName) {
        JSPWizard wizard = new JSPWizard();
        wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)new StructuredSelection(container));
        wizard.setFileName(fileName);
        Shell shell = Display.getCurrent().getActiveShell();
        WizardDialog dialog = new WizardDialog(null, (IWizard)wizard);
        dialog.open();
    }

    public static void openManagedBeanWizard(Object container, String className) {
        ManagedBeanWizard wizard = new ManagedBeanWizard();
        wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)new StructuredSelection(container));
        wizard.setClassName(className);
        Shell shell = Display.getCurrent().getActiveShell();
        WizardDialog dialog = new WizardDialog(null, (IWizard)wizard);
        dialog.open();
    }

    public static void openErrorDialog(Throwable ex) {
        Object status = null;
        status = ex instanceof CoreException ? ((CoreException)ex).getStatus() : new Status(4, "tk.eclipse.plugin.jsf", 0, ex.toString(), ex);
        ResourceBundle resource = JSFPlugin.getDefault().getResourceBundle();
        Shell shell = Display.getCurrent().getActiveShell();
        ErrorDialog.openError((Shell)shell, (String)resource.getString("errorDialog.caption"), (String)resource.getString("errorDialog.message"), (IStatus)status);
        Util.logException(ex);
    }

    public static void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, "tk.eclipse.plugin.jsf", 0, message, null);
        throw new CoreException((IStatus)status);
    }

    public static void logDebug(String message) {
        ILog log = JSFPlugin.getDefault().getLog();
        Status status = new Status(1, "tk.eclipse.plugin.jsf", 0, message, null);
        log.log((IStatus)status);
    }

    public static void logError(String message) {
        ILog log = JSFPlugin.getDefault().getLog();
        Status status = new Status(4, "tk.eclipse.plugin.jsf", 0, message, null);
        log.log((IStatus)status);
    }

    public static void logException(Throwable ex) {
        ILog log = JSFPlugin.getDefault().getLog();
        Object status = null;
        status = ex instanceof CoreException ? ((CoreException)ex).getStatus() : new Status(4, "tk.eclipse.plugin.jsf", 0, ex.toString(), ex);
        log.log(status);
        ex.printStackTrace();
    }

    public static String createMessage(String message, String[] params) {
        int i = 0;
        while (i < params.length) {
            message = message.replaceAll("\\{" + i + "\\}", params[i]);
            ++i;
        }
        return message;
    }

    public static void openAlertDialog(String message) {
        ResourceBundle resource = JSFPlugin.getDefault().getResourceBundle();
        MessageBox box = new MessageBox(Display.getCurrent().getActiveShell(), 1);
        box.setMessage(message);
        box.setText(resource.getString("errorDialog.caption"));
        box.open();
    }
}

