/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jsf.validator;

import java.io.InputStream;
import java.util.HashMap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.FuzzyXMLParser;
import jp.aonir.fuzzyxml.XPath;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import tk.eclipse.plugin.htmleditor.HTMLProjectParams;
import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.jsf.FacesConfigResolver;
import tk.eclipse.plugin.jsf.JSFPlugin;
import tk.eclipse.plugin.jsf.Util;
import tk.eclipse.plugin.xmleditor.editors.XMLValidationHandler;

public class FacesConfigValidator {
    private IFile file;
    private IJavaProject project;
    private String contents;
    private FuzzyXMLDocument doc;
    private HTMLProjectParams params;

    public FacesConfigValidator(IFile file) {
        this.file = file;
        this.project = JavaCore.create((IProject)file.getProject());
    }

    public void doValidate() {
        try {
            SAXParserFactory spfactory = SAXParserFactory.newInstance();
            spfactory.setValidating(true);
            SAXParser parser = spfactory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            reader.setEntityResolver(new FacesConfigResolver());
            reader.setErrorHandler((ErrorHandler)new XMLValidationHandler((IResource)this.file));
            reader.parse(new InputSource(this.file.getContents()));
        }
        catch (Exception spfactory) {
            // empty catch block
        }
        try {
            this.params = new HTMLProjectParams(this.file.getProject());
            this.contents = new String(HTMLUtil.readStream((InputStream)this.file.getContents()));
            this.contents = this.contents.replaceAll("\r\n", " \n");
            this.contents = this.contents.replaceAll("\r", "\n");
            this.doc = new FuzzyXMLParser().parse(this.file.getContents());
            FuzzyXMLNode[] rules = XPath.selectNodes((FuzzyXMLElement)this.doc.getDocumentElement(), (String)"/faces-config/navigation-rule");
            this.validateNavigationRules(rules);
            FuzzyXMLNode[] beans = XPath.selectNodes((FuzzyXMLElement)this.doc.getDocumentElement(), (String)"/faces-config/managed-bean");
            this.validateManagedBeans(beans);
        }
        catch (Exception ex) {
            Util.logException(ex);
        }
    }

    private void validateNavigationRules(FuzzyXMLNode[] rules) {
        int i = 0;
        while (i < rules.length) {
            FuzzyXMLElement rule = (FuzzyXMLElement)rules[i];
            FuzzyXMLNode[] children = rule.getChildren();
            int j = 0;
            while (j < children.length) {
                String fromViewID;
                FuzzyXMLElement element;
                if (children[j] instanceof FuzzyXMLElement && (element = (FuzzyXMLElement)children[j]).getName().equals("from-view-id") && (fromViewID = element.getValue().trim()) != null && !this.existsJSP(fromViewID, true)) {
                    this.addMarker(this.getLineAtOffset(element.getOffset()), Util.createMessage(JSFPlugin.getResourceString("error.notexists"), new String[]{fromViewID}), 1);
                }
                ++j;
            }
            FuzzyXMLNode[] cases = XPath.selectNodes((FuzzyXMLElement)rule, (String)"/navigation-case");
            int j2 = 0;
            while (j2 < cases.length) {
                children = ((FuzzyXMLElement)cases[j2]).getChildren();
                int k = 0;
                while (k < children.length) {
                    String toViewID;
                    FuzzyXMLElement element;
                    if (children[k] instanceof FuzzyXMLElement && (element = (FuzzyXMLElement)children[k]).getName().equals("to-view-id") && (toViewID = element.getValue().trim()) != null && !this.existsJSP(toViewID, false)) {
                        this.addMarker(this.getLineAtOffset(element.getOffset()), Util.createMessage(JSFPlugin.getResourceString("error.notexists"), new String[]{toViewID}), 1);
                    }
                    ++k;
                }
                ++j2;
            }
            ++i;
        }
    }

    private void validateManagedBeans(FuzzyXMLNode[] beans) {
        int i = 0;
        while (i < beans.length) {
            FuzzyXMLElement bean = (FuzzyXMLElement)beans[i];
            FuzzyXMLNode[] children = bean.getChildren();
            int j = 0;
            while (j < children.length) {
                String className;
                FuzzyXMLElement element;
                if (children[j] instanceof FuzzyXMLElement && (element = (FuzzyXMLElement)children[j]).getName().equals("managed-bean-class") && (className = element.getValue().trim()) != null && !className.equals("") && !this.existsClass(className)) {
                    this.addMarker(this.getLineAtOffset(element.getOffset()), Util.createMessage(JSFPlugin.getResourceString("error.notexists"), new String[]{className}), 1);
                }
                ++j;
            }
            ++i;
        }
    }

    private void addMarker(int line, String message, int type) {
        try {
            IMarker marker = this.file.createMarker("org.eclipse.core.resources.problemmarker");
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("severity", new Integer(type));
            map.put("message", message);
            map.put("lineNumber", new Integer(line));
            marker.setAttributes(map);
        }
        catch (Exception ex) {
            Util.logException(ex);
        }
    }

    private int getLineAtOffset(int offset) {
        String text = this.contents.substring(0, offset);
        return text.split("\n").length;
    }

    private boolean existsJSP(String viewID, boolean fromView) {
        if (fromView && viewID.indexOf("*") >= 0) {
            return true;
        }
        IFile jsp = this.file.getProject().getFile(new Path(this.params.getRoot()).append(viewID));
        return jsp.exists();
    }

    private boolean existsClass(String className) {
        try {
            IType type = this.project.findType(className);
            if (type.isClass() && type.exists()) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

