/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jsf.validator;

import java.io.InputStream;
import java.util.HashMap;
import jp.aonir.fuzzyxml.FuzzyXMLAttribute;
import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.FuzzyXMLParser;
import jp.aonir.fuzzyxml.XPath;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.jsf.JSFPlugin;
import tk.eclipse.plugin.jsf.JSFProject;
import tk.eclipse.plugin.jsf.JSFTagDefinition;
import tk.eclipse.plugin.jsf.ManagedBean;
import tk.eclipse.plugin.jsf.Util;
import tk.eclipse.plugin.jspeditor.editors.JSPInfo;
import tk.eclipse.plugin.jspeditor.editors.JSPValidator;
import tk.eclipse.plugin.jspeditor.editors.TLDInfo;

public class FacesJSPValidator {
    private JSFProject project;
    private IFile file;
    private String contents;
    private FuzzyXMLDocument doc;
    private String htmlPrefix;
    private String corePrefix;

    public FacesJSPValidator(JSFProject project, IFile file) {
        this.project = project;
        this.file = file;
        try {
            this.contents = new String(HTMLUtil.readStream((InputStream)file.getContents()));
            JSPInfo info = new JSPInfo(file, this.contents);
            TLDInfo[] tlds = info.getTLDInfo();
            int i = 0;
            while (i < tlds.length) {
                if (tlds[i].getTaglibUri().equals("http://java.sun.com/jsf/core")) {
                    this.corePrefix = tlds[i].getPrefix();
                } else if (tlds[i].getTaglibUri().equals("http://java.sun.com/jsf/html")) {
                    this.htmlPrefix = tlds[i].getPrefix();
                }
                ++i;
            }
            this.contents = this.contents.replaceAll("\r\n", " \n");
            this.contents = this.contents.replaceAll("\r", "\n");
        }
        catch (Exception ex) {
            Util.logException(ex);
        }
    }

    public void doValidate() {
        try {
            this.removeMaker((IResource)this.file);
            new JSPValidator(this.file).doValidate();
            String source = new String(HTMLUtil.readStream((InputStream)this.file.getContents()));
            source = HTMLUtil.scriptlet2space((String)source, (boolean)false);
            this.doc = new FuzzyXMLParser().parse(source);
            if (this.doc == null) {
                return;
            }
            FuzzyXMLElement root = this.doc.getDocumentElement();
            this.validateElement((FuzzyXMLElement)XPath.selectSingleNode((FuzzyXMLElement)root, (String)"*"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void validateElement(FuzzyXMLElement element) throws CoreException {
        String[] names;
        String name = element.getName();
        if (name.startsWith(String.valueOf(this.htmlPrefix) + ":") && (names = name.split(":")).length > 1) {
            FuzzyXMLAttribute[] attrs = element.getAttributes();
            int i = 0;
            while (i < attrs.length) {
                String attrName = attrs[i].getName();
                String attrValue = attrs[i].getValue();
                String type = JSFTagDefinition.getAttributeInfo(names[1], attrName);
                if (type != null && attrValue.startsWith("#{")) {
                    if (!(attrValue = attrValue.replaceFirst("^#\\{", "")).endsWith("}")) {
                        this.createAttributeValueMarker(attrs[i], this.createMessage("validation.message.requireClose", attrs[i].getName()));
                    } else {
                        attrValue = attrValue.replaceFirst("\\}$", "");
                        String[] dim = attrValue.split("\\.");
                        ManagedBean bean = this.project.getManagedBean(dim[0]);
                        if (attrValue.indexOf(46) > 0 && dim.length == 1) {
                            this.createAttributeValueMarker(attrs[i], JSFPlugin.getResourceString("validation.message.notSpecified"));
                        } else if (bean == null && attrValue.indexOf(46) > 0) {
                            this.createAttributeValueMarker(attrs[i], this.createMessage("validation.message.notDefined", attrValue));
                        } else if (dim.length != 1 && bean != null) {
                            if (type == "action") {
                                if (!bean.hasActionMethod(dim[1])) {
                                    this.createAttributeValueMarker(attrs[i], this.createMessage("validation.message.notDefined", attrValue));
                                }
                            } else if (type == "actionListener") {
                                if (!bean.hasActionListenerMethod(dim[1])) {
                                    this.createAttributeValueMarker(attrs[i], this.createMessage("validation.message.notDefined", attrValue));
                                }
                            } else if (type == "valudaChangeListener") {
                                if (!bean.hasValueChangeListenerMethod(dim[1])) {
                                    this.createAttributeValueMarker(attrs[i], this.createMessage("validation.message.notDefined", attrValue));
                                }
                            } else if (type == "validater") {
                                if (!bean.hasValidaterMethod(dim[1])) {
                                    this.createAttributeValueMarker(attrs[i], this.createMessage("validation.message.notDefined", attrValue));
                                }
                            } else if (type == "prop" && !bean.hasProperty(dim[1])) {
                                this.createAttributeValueMarker(attrs[i], this.createMessage("validation.message.notDefined", attrValue));
                            }
                        }
                    }
                }
                ++i;
            }
        }
        FuzzyXMLNode[] children = element.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof FuzzyXMLElement) {
                this.validateElement((FuzzyXMLElement)children[i]);
            }
            ++i;
        }
    }

    private int getLineAtOffset(int offset) {
        String text = this.contents.substring(0, offset);
        return text.split("\n").length;
    }

    private void removeMaker(IResource resouce) throws CoreException {
        resouce.deleteMarkers("org.eclipse.core.resources.problemmarker", false, 0);
    }

    private String createMessage(String key, String param) {
        String message = JSFPlugin.getResourceString(key);
        return Util.createMessage(message, new String[]{param});
    }

    private int getAttrValueOffset(int offset) {
        int valueStart = 0;
        valueStart = this.contents.indexOf("\"", offset);
        if (valueStart == -1) {
            valueStart = this.contents.indexOf("=") + 1;
        }
        return valueStart;
    }

    private void createAttributeValueMarker(FuzzyXMLAttribute attr, String message) throws CoreException {
        this.createMarker(this.getAttrValueOffset(attr.getOffset() + 1), attr.getOffset() + attr.getLength(), this.getLineAtOffset(attr.getOffset() + 1), message);
    }

    private void createMarker(int start, int end, int line, String message) throws CoreException {
        IMarker marker = this.file.createMarker("org.eclipse.core.resources.problemmarker");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("severity", new Integer(2));
        map.put("message", message);
        map.put("lineNumber", new Integer(line));
        map.put("charStart", new Integer(start));
        map.put("charEnd", new Integer(end));
        marker.setAttributes(map);
    }
}

