/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jsf.wizards;

import java.util.ResourceBundle;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionValidator;
import tk.eclipse.plugin.jsf.JSFPlugin;
import tk.eclipse.plugin.jsf.Util;

public class JSFSupportWizardPage
extends WizardPage {
    private Button library;
    private Button facesConfig;
    private Button webXml;
    private Text containerText;
    private ISelection selection;
    private ResourceBundle resource = JSFPlugin.getDefault().getResourceBundle();

    public JSFSupportWizardPage(ISelection selection) {
        super("wizardPage");
        this.setTitle(this.resource.getString("wizard.jsfSupport.title"));
        this.setDescription(this.resource.getString("wizard.jsfSupport.decription"));
        this.selection = selection;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        Label label = new Label(container, 0);
        label.setText(this.resource.getString("wizard.label.webappRoot"));
        this.containerText = new Text(container, 2052);
        GridData gd = new GridData(768);
        this.containerText.setLayoutData((Object)gd);
        this.containerText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JSFSupportWizardPage.this.dialogChanged();
            }
        });
        Button button = new Button(container, 8);
        button.setText(this.resource.getString("wizard.label.browse"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JSFSupportWizardPage.this.handleBrowse();
            }
        });
        this.library = new Button(container, 32);
        this.library.setText(this.resource.getString("wizard.label.addJSFLibrary"));
        this.library.setSelection(true);
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.library.setLayoutData((Object)gd);
        this.facesConfig = new Button(container, 32);
        this.facesConfig.setText(this.resource.getString("wizard.label.createFacesConfig"));
        this.facesConfig.setSelection(true);
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.facesConfig.setLayoutData((Object)gd);
        this.webXml = new Button(container, 32);
        this.webXml.setText(this.resource.getString("wizard.label.createWebXML"));
        this.webXml.setSelection(true);
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.webXml.setLayoutData((Object)gd);
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)container);
    }

    private void initialize() {
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)this.selection;
            if (ssel.size() > 1) {
                return;
            }
            Object obj = ssel.getFirstElement();
            if (obj instanceof IJavaProject) {
                this.containerText.setText(((IJavaProject)obj).getProject().getFullPath().toString());
            } else if (obj instanceof IJavaElement) {
                this.containerText.setText(((IJavaElement)obj).getJavaProject().getProject().getFullPath().toString());
            }
        }
    }

    private void handleBrowse() {
        Object[] result;
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, this.resource.getString("wizard.message.selectWebAppRoot"));
        dialog.setValidator(new ISelectionValidator(){

            public String isValid(Object selection) {
                try {
                    IWorkspaceRoot root;
                    IResource resource;
                    if (selection != null && (resource = (root = ResourcesPlugin.getWorkspace().getRoot()).findMember((IPath)selection)) != null && resource.getProject().hasNature("org.eclipse.jdt.core.javanature")) {
                        return null;
                    }
                    return JSFSupportWizardPage.this.resource.getString("error.noJavaProject");
                }
                catch (Exception ex) {
                    return ex.toString();
                }
            }
        });
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            this.containerText.setText(((Path)result[0]).toString());
        }
    }

    private void dialogChanged() {
        String container = this.getWebAppRoot();
        if (container.length() == 0) {
            this.updateStatus(Util.createMessage(this.resource.getString("error.required"), new String[]{this.resource.getString("message.project")}));
            return;
        }
        this.updateStatus(null);
    }

    public String getWebAppRoot() {
        return this.containerText.getText();
    }

    public boolean getCreateFacesConfigXML() {
        return this.facesConfig.getSelection();
    }

    public boolean getCreateWebXML() {
        return this.webXml.getSelection();
    }

    public boolean getAddStrutsLibraries() {
        return this.library.getSelection();
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }
}

