/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jsf.wizards;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import tk.eclipse.plugin.jsf.JSFPlugin;
import tk.eclipse.plugin.jsf.Util;
import tk.eclipse.plugin.jsf.wizards.JSPWizardPage;

public class JSPWizard
extends Wizard
implements INewWizard {
    private JSPWizardPage page;
    private ISelection selection;
    private String fileName = "newfile.jsp";
    private ResourceBundle resource = JSFPlugin.getDefault().getResourceBundle();

    public JSPWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(this.resource.getString("wizard.jsp.title"));
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void addPages() {
        this.page = new JSPWizardPage(this.selection, this.fileName);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        final String containerName = this.page.getContainerName();
        final String fileName = this.page.getFileName();
        final boolean useMyFaces = this.page.getUseMyFacesComponents();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        JSPWizard.this.doFinish(containerName, fileName, useMyFaces, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var3_5 = null;
                }
                monitor.done();
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            Util.openErrorDialog(realException);
            return false;
        }
        return true;
    }

    private void doFinish(String containerName, String fileName, boolean useMyFaces, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(Util.createMessage(this.resource.getString("wizard.message.creation"), new String[]{fileName}), 2);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(containerName));
        if (!resource.exists() || !(resource instanceof IContainer)) {
            Util.throwCoreException(Util.createMessage(this.resource.getString("error.notexists"), new String[]{containerName}));
        }
        IContainer container = (IContainer)resource;
        final IFile file = container.getFile((IPath)new Path(fileName));
        String charset = null;
        try {
            charset = file.getProject().getDefaultCharset();
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        try {
            InputStream stream = this.openContentStream(useMyFaces, charset);
            if (file.exists()) {
                file.setContents(stream, true, true, monitor);
            } else {
                file.create(stream, true, monitor);
            }
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        monitor.worked(1);
        monitor.setTaskName(this.resource.getString("wizard.message.openfile"));
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
                catch (PartInitException partInitException) {
                    // empty catch block
                }
            }
        });
        monitor.worked(1);
    }

    private InputStream openContentStream(boolean useMyFaces, String charset) {
        StringBuffer sb = new StringBuffer();
        if (charset == null) {
            sb.append("<%@ page contentType=\"text/html\" %>\n");
        } else {
            sb.append("<%@ page contentType=\"text/html; charset=" + charset + "\" %>\n");
        }
        sb.append("<%@ taglib uri=\"http://java.sun.com/jsf/html\" prefix=\"h\" %>\n");
        sb.append("<%@ taglib uri=\"http://java.sun.com/jsf/core\" prefix=\"f\" %>\n");
        if (useMyFaces) {
            sb.append("<%@ taglib uri=\"http://myfaces.sourceforge.net/tld/myfaces_ext_0_9.tld\" prefix=\"x\" %>\n");
        }
        sb.append("<html>\n");
        sb.append("\t<head>\n");
        sb.append("\t\t<meta http-equiv=\"Content-Type\" content=\"text/html");
        if (charset != null) {
            sb.append("; charset=" + charset);
        }
        sb.append("\"/>\n");
        sb.append("\t\t<title></title>\n");
        sb.append("\t</head>\n");
        sb.append("\t<body>\n");
        sb.append("\t\t<f:view>\n");
        sb.append("\t\t\t<h:form>\n");
        sb.append("\t\t\t</h:form>\n");
        sb.append("\t\t</f:view>\n");
        sb.append("\t</body>\n");
        sb.append("</html>\n");
        return new ByteArrayInputStream(sb.toString().getBytes());
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }
}

