/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.struts;

import java.io.InputStream;
import java.util.Iterator;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import tk.eclipse.plugin.htmleditor.HTMLProjectParams;
import tk.eclipse.plugin.struts.StrutsConfigResolver;
import tk.eclipse.plugin.struts.StrutsPlugin;
import tk.eclipse.plugin.struts.TilesDefsSAXHandler;
import tk.eclipse.plugin.struts.Util;
import tk.eclipse.plugin.struts.editors.models.PluginModel;
import tk.eclipse.plugin.struts.editors.models.RootModel;
import tk.eclipse.plugin.struts.editors.models.TilesRootModel;
import tk.eclipse.plugin.struts.properties.Properties;

public class TilesDefsXML2Model {
    private static final String TILES_PLUGIN_CLASSNAME = "org.apache.struts.tiles.TilesPlugin";
    private static final String TILES_PLUGIN_DEFINITION_CONFIG_PROPERTY = "definitions-config";

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TilesRootModel createModel(IProject project, RootModel strutsModel) {
        TilesRootModel tilesModel = new TilesRootModel();
        StrutsPlugin.getDefault().setCanFirePropertyChangeEvent(false);
        try {
            try {
                String[] tilesFilenames = TilesDefsXML2Model.getTilesDefsFilenames(strutsModel);
                if (tilesFilenames != null) {
                    SAXParserFactory spfactory = SAXParserFactory.newInstance();
                    spfactory.setValidating(false);
                    HTMLProjectParams params = new HTMLProjectParams(project);
                    int i = 0;
                    while (i < tilesFilenames.length) {
                        IPath path = new Path(params.getRoot()).append(tilesFilenames[i]);
                        IFile file = project.getFile(path);
                        InputStream in = file.getContents();
                        SAXParser parser = spfactory.newSAXParser();
                        XMLReader reader = parser.getXMLReader();
                        TilesDefsSAXHandler handler = new TilesDefsSAXHandler();
                        reader.setEntityResolver(new StrutsConfigResolver());
                        reader.setContentHandler(handler);
                        reader.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
                        reader.parse(new InputSource(in));
                        tilesModel.merge(handler.getModel());
                        ++i;
                    }
                }
            }
            catch (Exception ex) {
                Util.logException(ex);
            }
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            StrutsPlugin.getDefault().setCanFirePropertyChangeEvent(true);
            throw throwable;
        }
        {
            Object var13_16 = null;
            StrutsPlugin.getDefault().setCanFirePropertyChangeEvent(true);
            return tilesModel;
        }
    }

    public static String[] getTilesDefsFilenames(RootModel root) {
        Iterator it = root.getChildren().iterator();
        while (it.hasNext()) {
            PluginModel plugin;
            Object model = it.next();
            if (!(model instanceof PluginModel) || !TILES_PLUGIN_CLASSNAME.equals((plugin = (PluginModel)model).getClassName())) continue;
            Properties props = plugin.getProperties();
            int i = 0;
            while (i < props.size()) {
                if (TILES_PLUGIN_DEFINITION_CONFIG_PROPERTY.equals(props.getName(i))) {
                    return props.getValue(i).split(",");
                }
                ++i;
            }
            return new String[0];
        }
        return null;
    }
}

