/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.struts.editors;

import java.util.ArrayList;
import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IFileEditorInput;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.HTMLProjectParams;
import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.htmleditor.assist.AssistInfo;
import tk.eclipse.plugin.htmleditor.assist.AttributeInfo;
import tk.eclipse.plugin.htmleditor.assist.HTMLAssistProcessor;
import tk.eclipse.plugin.struts.StrutsConfigResolver;
import tk.eclipse.plugin.xmleditor.editors.XMLAssistProcessor;
import tk.eclipse.plugin.xmleditor.editors.XMLConfiguration;
import tk.eclipse.plugin.xmleditor.editors.XMLEditor;

public class TilesXMLEditor
extends XMLEditor {
    public TilesXMLEditor() {
        super((XMLConfiguration)new TilesConfiguration());
        this.addDTDResolver(new StrutsConfigResolver());
        this.setValidation(false);
    }

    private static class TilesConfiguration
    extends XMLConfiguration {
        public TilesConfiguration() {
            super(HTMLPlugin.getDefault().getColorProvider());
        }

        protected HTMLAssistProcessor createAssistProcessor() {
            return new TilesAssistProcessor();
        }
    }

    private static class TilesAssistProcessor
    extends XMLAssistProcessor {
        private IProject project;

        TilesAssistProcessor() {
        }

        public void update(IFileEditorInput input, String source) {
            super.update(input, source);
            this.project = input.getFile().getProject();
        }

        protected AssistInfo[] getAttributeValues(String tagName, String value, AttributeInfo info) {
            if (tagName.equals("definition") && info.getAttributeName().equals("path")) {
                return this.getFiles(value);
            }
            if (tagName.equals("definition") && info.getAttributeName().equals("extends")) {
                return this.getDefinitionNames();
            }
            if (tagName.equals("put") && info.getAttributeName().equals("value")) {
                return this.getFiles(value);
            }
            return super.getAttributeValues(tagName, value, info);
        }

        private AssistInfo[] getDefinitionNames() {
            FuzzyXMLDocument doc = this.getDocument();
            FuzzyXMLNode[] nodes = HTMLUtil.selectXPathNodes((FuzzyXMLElement)doc.getDocumentElement(), (String)"//tiles-definitions/definition");
            ArrayList<String> defNames = new ArrayList<String>();
            int i = 0;
            while (i < nodes.length) {
                FuzzyXMLElement element = (FuzzyXMLElement)nodes[i];
                defNames.add(element.getAttributeNode("name").getValue());
                ++i;
            }
            AssistInfo[] assist = new AssistInfo[defNames.size()];
            int i2 = 0;
            while (i2 < assist.length) {
                assist[i2] = new AssistInfo((String)defNames.get(i2));
                ++i2;
            }
            return assist;
        }

        private AssistInfo[] getFiles(String value) {
            Path path = null;
            String parent = null;
            if (value.startsWith("/")) {
                try {
                    HTMLProjectParams params = new HTMLProjectParams(this.project);
                    path = new Path(params.getRoot());
                }
                catch (Exception ex) {
                    HTMLPlugin.logException((Throwable)ex);
                }
            } else {
                return new AssistInfo[0];
            }
            int index = value.lastIndexOf(47);
            if (index >= 0) {
                path = path.append(value.substring(0, index));
                parent = String.valueOf(value.substring(0, index)) + "/";
            } else {
                parent = "";
            }
            IResource resource = this.project.findMember((IPath)path);
            if (resource != null && resource.exists() && resource instanceof IContainer) {
                try {
                    IContainer container = (IContainer)resource;
                    IResource[] children = container.members();
                    ArrayList<AssistInfo> list = new ArrayList<AssistInfo>();
                    int i = 0;
                    while (i < children.length) {
                        if (!(children[i].getName().startsWith(".") || children[i] instanceof IFile && !children[i].getName().endsWith(".jsp"))) {
                            Image image = null;
                            image = children[i] instanceof IContainer ? HTMLPlugin.getDefault().getImageRegistry().get("_icon_folder") : this.getFileImage(children[i].getName().toLowerCase());
                            list.add(new AssistInfo(String.valueOf(parent) + children[i].getName(), children[i].getName(), image));
                        }
                        ++i;
                    }
                    return list.toArray(new AssistInfo[list.size()]);
                }
                catch (Exception ex) {
                    HTMLPlugin.logException((Throwable)ex);
                }
            }
            return new AssistInfo[0];
        }

        private Image getFileImage(String name) {
            if (name.endsWith(".jsp")) {
                return HTMLPlugin.getDefault().getImageRegistry().get("_icon_jsp");
            }
            return HTMLPlugin.getDefault().getImageRegistry().get("_icon_file");
        }
    }
}

