/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.struts.editors.editparts;

import java.beans.PropertyChangeListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.ui.IFileEditorInput;
import tk.eclipse.plugin.struts.StrutsProject;
import tk.eclipse.plugin.struts.editors.GraphicalStrutsConfigEditor;
import tk.eclipse.plugin.struts.editors.editparts.ActionEditPart;
import tk.eclipse.plugin.struts.editors.editparts.DirectForwardEditPart;
import tk.eclipse.plugin.struts.editors.editparts.ExceptionEditPart;
import tk.eclipse.plugin.struts.editors.editparts.ForwardEditPart;
import tk.eclipse.plugin.struts.editors.editparts.IncludeEditPart;
import tk.eclipse.plugin.struts.editors.editparts.InputEditPart;
import tk.eclipse.plugin.struts.editors.editparts.PageEditPart;
import tk.eclipse.plugin.struts.editors.editparts.RootEditPart;
import tk.eclipse.plugin.struts.editors.models.ActionModel;
import tk.eclipse.plugin.struts.editors.models.DirectForwardModel;
import tk.eclipse.plugin.struts.editors.models.ExceptionModel;
import tk.eclipse.plugin.struts.editors.models.ForwardModel;
import tk.eclipse.plugin.struts.editors.models.IncludeModel;
import tk.eclipse.plugin.struts.editors.models.InputModel;
import tk.eclipse.plugin.struts.editors.models.PageModel;
import tk.eclipse.plugin.struts.editors.models.RootModel;

public class StrutsConfigEditPartFactory
implements EditPartFactory {
    private IFile file;
    private String moduleName;

    public StrutsConfigEditPartFactory(GraphicalStrutsConfigEditor editor) {
        IFileEditorInput input = (IFileEditorInput)editor.getEditorInput();
        this.file = input.getFile();
        this.moduleName = "";
        StrutsProject project = new StrutsProject(this.file.getProject());
        String[] modules = project.getModuleNames();
        int i = 0;
        while (i < modules.length) {
            IFile[] files = project.getStrutsConfigXML(modules[i]);
            int j = 0;
            while (j < files.length) {
                if (files[j].equals((Object)this.file)) {
                    this.moduleName = modules[i];
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    public EditPart createEditPart(EditPart context, Object model) {
        PropertyChangeListener part = null;
        if (model instanceof RootModel) {
            part = new RootEditPart();
        } else if (model instanceof ActionModel) {
            part = new ActionEditPart(this.file);
        } else if (model instanceof PageModel) {
            part = new PageEditPart(this.file, this.moduleName);
        } else if (model instanceof ForwardModel) {
            part = new ForwardEditPart();
        } else if (model instanceof ExceptionModel) {
            part = new ExceptionEditPart();
        } else if (model instanceof DirectForwardModel) {
            part = new DirectForwardEditPart();
        } else if (model instanceof IncludeModel) {
            part = new IncludeEditPart();
        } else if (model instanceof InputModel) {
            part = new InputEditPart();
        } else {
            return null;
        }
        part.setModel(model);
        return part;
    }
}

