/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.struts.properties;

import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import tk.eclipse.plugin.struts.properties.AbstractPropertiesDialog;
import tk.eclipse.plugin.struts.properties.Properties;
import tk.eclipse.plugin.struts.properties.PropertyDialog;

public class PropertiesDialog
extends AbstractPropertiesDialog {
    private Properties props;

    public PropertiesDialog(Shell parentShell, Properties props) {
        super(parentShell);
        this.props = props;
    }

    protected void okPressed() {
        this.props = new Properties();
        TableItem[] items = this.table.getItems();
        int i = 0;
        while (i < items.length) {
            this.props.addProperty(items[i].getText(0), items[i].getText(1), "");
            ++i;
        }
        super.okPressed();
    }

    public Properties getProperties() {
        return this.props;
    }

    protected void addPressed() {
        PropertyDialog dialog = new PropertyDialog(this.getShell());
        if (dialog.open() == 0) {
            TableItem item = new TableItem(this.table, 0);
            item.setText(new String[]{dialog.getName(), dialog.getValue()});
        }
    }

    protected void editPressed() {
        TableItem[] sel = this.table.getSelection();
        if (sel == null || sel.length == 0) {
            return;
        }
        String name = sel[0].getText(0);
        String value = sel[0].getText(1);
        PropertyDialog dialog = new PropertyDialog(this.getShell(), name, value);
        if (dialog.open() == 0) {
            sel[0].setText(new String[]{dialog.getName(), dialog.getValue()});
        }
    }

    protected void initDialog() {
        this.getShell().setText("Properties");
        int i = 0;
        while (i < this.props.size()) {
            TableItem item = new TableItem(this.table, 0);
            String[] text = new String[]{this.props.getName(i), this.props.getValue(i)};
            item.setText(text);
            ++i;
        }
    }

    protected void removePressed() {
        this.table.remove(this.table.getSelectionIndices());
    }
}

