/*** INST-SYSCNST.C ***/				#include	"main.h"
/************************************************************************************************/
// INST_SYSCNST() installs System Pre-Defined Constant(s).
// (1) S_ARGC & S_ARGV[] are already adjusted for TT-Script.
// (2) Temporary Assignment Parameter(s) will be adjusted later.
/************************************************************************************************/
void inst_syscnst(int s_argc,char *s_argv[]){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/

tint	dbl_mantsize;					/* (dbl) Mantissa Size [Bit]							*/
tint	dbl_exposize;					/* (dbl) Exponent Size [Bit]							*/

// TT-Script基本定数＆基本情報
	wr_dtab(GL_DTAB,"NULL"          ,'P',0,NULL                     );
	wr_dtab(GL_DTAB,"TRUE"          ,'I',0,(tint)TRUE               );
	wr_dtab(GL_DTAB,"FALS"          ,'I',0,(tint)FALS               );
                                          
	wr_dtab(GL_DTAB,"VER"           ,'I',0,atoi2(TTdeAM_VER)        );
	wr_dtab(GL_DTAB,"BIT"           ,'I',0,(tint)(sizeof(tint)*8)   );

//（内部データビット数）
	dbl_mantsize = (tint)DBL_MANT_DIG;
	dbl_exposize = (tint)rint (log2 ( DBL_MAX_EXP-DBL_MIN_EXP+3));	// +3 = Exp0 + 0.0 + (NaN|Inf)
	if( dbl_mantsize+dbl_exposize==32 || dbl_mantsize+dbl_exposize==64 || dbl_mantsize+dbl_exposize==128 )
		dbl_mantsize--;												// -1 = Hidden Bit

	wr_dtab(GL_DTAB,"INT_SIZE"      ,'I',0,(tint)(sizeof(tint  )*8) );
	wr_dtab(GL_DTAB,"DBL_SIZE"      ,'I',0,(tint)(sizeof(tdbl  )*8) );
	wr_dtab(GL_DTAB,"PTR_SIZE"      ,'I',0,(tint)(sizeof(void *)*8) );
	wr_dtab(GL_DTAB,"DBL_MANTSIZE"  ,'I',0,(tint)dbl_mantsize       );
	wr_dtab(GL_DTAB,"DBL_EXPOSIZE"  ,'I',0,(tint)dbl_exposize       );
                                          
// コマンドライン引数＆環境変数
	wr_dtab(GL_DTAB,"ARGC"          ,'I',ATTR_IGNR,(tint)s_argc     );
	wr_dtab(GL_DTAB,"ARGR"          ,'I',ATTR_IGNR,(tint)0          );	// Temp Asgn!!
	wr_dtab(GL_DTAB,"ARGV"          ,'P',ATTR_IGNR,s_argv           );
	wr_dtab(GL_DTAB,"ARGS"          ,'P',ATTR_IGNR,NULL             );	// Temp Asgn!!
	wr_dtab(GL_DTAB,"CMD"           ,'P',ATTR_IGNR,NULL             );	// Temp Asgn!!
	wr_dtab(GL_DTAB,"ENV"           ,'P',ATTR_IGNR,environ          );	// Temp Asgn!!

	reinit_argcmd();	/*** Set Up!! (Adjust) ***/
	reinit_env();		/*** Set Up!! (Adjust) ***/

// ファイルポインタ
	wr_dtab(GL_DTAB,"STDIN"         ,'P',ATTR_IGNR          ,stdin  );
	wr_dtab(GL_DTAB,"STDOUT"        ,'P',ATTR_IGNR          ,stdout );
	wr_dtab(GL_DTAB,"STDERR"        ,'P',ATTR_IGNR          ,stderr );
	wr_dtab(GL_DTAB,":CODE"         ,'P',ATTR_IGNR|ATTR_FPCD,NULL   );	// Temp Asgn!!
	wr_dtab(GL_DTAB,":DATA"         ,'P',ATTR_IGNR|ATTR_FPCD,NULL   );	// Temp Asgn!!

// システムパラメータ
	wr_dtab(GL_DTAB,"EXT_SHELL"     ,'S',0,"/bin/bash"              );
	wr_dtab(GL_DTAB,"$out"          ,'U',0,0                        );
	wr_dtab(GL_DTAB,"$err"          ,'U',0,0                        );
	wr_dtab(GL_DTAB,"SYS_ANGLE"     ,'D',0,(tdbl)1.0                );
	wr_dtab(GL_DTAB,"RAD"           ,'D',0,(tdbl)1.0                );
	wr_dtab(GL_DTAB,"DEG"           ,'D',0,(tdbl)(180.0/M_PIx)      );
	wr_dtab(GL_DTAB,"LTZ_OFFSET"    ,'I',0,(tint)(00*60*60)         );	// Temp Asgn!!
                                          
	wr_dtab(GL_DTAB,"FMT_S2S"       ,'S',0,"%s"                     );
	wr_dtab(GL_DTAB,"FMT_I2S"       ,'S',0,"%d"                     );
	wr_dtab(GL_DTAB,"FMT_D2S"       ,'S',0,"%+f"                    );
	wr_dtab(GL_DTAB,"FMT_P2S"       ,'S',0,"%p"                     );
	wr_dtab(GL_DTAB,"FMT_N2S"       ,'S',0,"NULL"                   );
	wr_dtab(GL_DTAB,"FMT_SDATE"     ,'S',0,"%Y-%m-%d"               );
	wr_dtab(GL_DTAB,"FMT_STIME"     ,'S',0,"%H:%M:%S"               );

	wr_dtab(GL_DTAB,"RAW_SOCKET"    ,'I',0,0                        );
	wr_dtab(GL_DTAB,"UDP_SOCKET"    ,'I',0,0                        );
	wr_dtab(GL_DTAB,"TCP_SOCKET"    ,'I',0,0                        );
	wr_dtab(GL_DTAB,"L&A_SOCKET"    ,'I',0,0                        );
	wr_dtab(GL_DTAB,"RAW_TIMEOUT"   ,'D',0,(tdbl)HUGE_VAL           );
	wr_dtab(GL_DTAB,"UDP_TIMEOUT"   ,'D',0,(tdbl)HUGE_VAL           );
	wr_dtab(GL_DTAB,"TCP_TIMEOUT"   ,'D',0,(tdbl)HUGE_VAL           );
	wr_dtab(GL_DTAB,"FMT_IP2STR"    ,'S',0,"%3d.%3d.%3d.%3d"        );

// (AWK関連)
	wr_dtab(GL_DTAB,"$"             ,'P',0,NULL                     );	// Set By X_AWKS()
	wr_dtab(GL_DTAB,"NR"            ,'I',0,0                        );	// Set By X_AWKS()
	wr_dtab(GL_DTAB,"NF"            ,'I',0,0                        );	// Set By X_AWKS()

// 日付＆時刻
	wr_dtab(GL_DTAB,"LTZ"           ,'S',0,"LTZ"                    );	// Temp Asgn!!
	reinit_ltz();		/*** Set Up!! (Adjust) ***/

// 整数＆実数
	wr_dtab(GL_DTAB,"INT_MAX"       ,'I',0,(tint)INT_MAX            );
	wr_dtab(GL_DTAB,"INT_MIN"       ,'I',0,(tint)INT_MIN            );
	wr_dtab(GL_DTAB,"DBL_MAX"       ,'D',0,(tdbl)(+DBL_MAX)         );
	wr_dtab(GL_DTAB,"DBL_MIN"       ,'D',0,(tdbl)(-DBL_MAX)         );
                                          
	wr_dtab(GL_DTAB,"INT_QUANT"     ,'I',0,(tint)1                  );
	wr_dtab(GL_DTAB,"INT_EPSILON"   ,'I',0,(tint)1                  );
	wr_dtab(GL_DTAB,"DBL_QUANT"     ,'D',0,(tdbl)DBL_MIN            );
	wr_dtab(GL_DTAB,"DBL_EPSILON"   ,'D',0,(tdbl)DBL_EPSILON        );
                                          
	wr_dtab(GL_DTAB,"INF"           ,'D',0,(tdbl)HUGE_VAL           );
	wr_dtab(GL_DTAB,"NAN"           ,'D',0,(tdbl)nan("")            );

// 数学定数＆物理定数                    
	wr_dtab(GL_DTAB,"M_E"           ,'D',0,(tdbl)M_Ex               );
	wr_dtab(GL_DTAB,"M_PI"          ,'D',0,(tdbl)M_PIx              );
	wr_dtab(GL_DTAB,"C_MPS"         ,'D',0,(tdbl)2.99792458E+8      );	// 真空中の光速 [m/s]
	wr_dtab(GL_DTAB,"E_FPM"         ,'D',0,(tdbl)(1.0E+7/(4.0*M_PIx*299792458.0*299792458.0))); // 真空中の誘電率 [F/m]
	wr_dtab(GL_DTAB,"U_HPM"         ,'D',0,(tdbl)(4.0*M_PIx*1.0E-7                          )); // 真空中の透磁率 [H/m]
	wr_dtab(GL_DTAB,"K_JPK"         ,'D',0,(tdbl)1.3806503E-23      );	// ボルツマン定数 [J/K]
	wr_dtab(GL_DTAB,"H_JS"          ,'D',0,(tdbl)6.6260755E-34      );	// プランク定数 [Js]
                                          
	wr_dtab(GL_DTAB,"RE_M"          ,'D',0,(tdbl)( 6378.137*1000 )  );	// 地球の半径(GRS80&WGS84) [m]
	wr_dtab(GL_DTAB,"RS_M"          ,'D',0,(tdbl)(42164.0*1000   )  );	// 静止軌道の半径 [m]
	wr_dtab(GL_DTAB,"FE_GRS80"      ,'D',0,(tdbl)(1/298.257222101)  );	// 地球の偏平率(GRS80) b=a*(1-f)
	wr_dtab(GL_DTAB,"FE_WGS84"      ,'D',0,(tdbl)(1/298.257223563)  );	// 地球の偏平率(WGS84) b=a*(1-f)

// ＡＮＳＩカラー
// ( Attr:     00=none 01=bold 04=underscore 05=blink 07=reverse 08=concealed					)
// ( FG-Color: 30=black 31=red 32=green 33=yellow 34=blue 35=magenta 36=cyan 37=white			)
// ( BG-Color: 40=black 41=red 42=green 43=yellow 44=blue 45=magenta 46=cyan 47=white			)

	wr_dtab(GL_DTAB,"C_BLA",'S',0,"\e[00;01;30m"   );
	wr_dtab(GL_DTAB,"C_RED",'S',0,"\e[00;01;31m"   );
	wr_dtab(GL_DTAB,"C_GRE",'S',0,"\e[00;01;32m"   );
	wr_dtab(GL_DTAB,"C_YEL",'S',0,"\e[00;01;33m"   );
	wr_dtab(GL_DTAB,"C_BLU",'S',0,"\e[00;01;34m"   );
	wr_dtab(GL_DTAB,"C_MAG",'S',0,"\e[00;01;35m"   );
	wr_dtab(GL_DTAB,"C_CYA",'S',0,"\e[00;01;36m"   );
	wr_dtab(GL_DTAB,"C_WHI",'S',0,"\e[00;01;37m"   );

	wr_dtab(GL_DTAB,"R_BLA",'S',0,"\e[00;01;07;30m");
	wr_dtab(GL_DTAB,"R_RED",'S',0,"\e[00;01;07;31m");
	wr_dtab(GL_DTAB,"R_GRE",'S',0,"\e[00;01;07;32m");
	wr_dtab(GL_DTAB,"R_YEL",'S',0,"\e[00;01;07;33m");
	wr_dtab(GL_DTAB,"R_BLU",'S',0,"\e[00;01;07;34m");
	wr_dtab(GL_DTAB,"R_MAG",'S',0,"\e[00;01;07;35m");
	wr_dtab(GL_DTAB,"R_CYA",'S',0,"\e[00;01;07;36m");
	wr_dtab(GL_DTAB,"R_WHI",'S',0,"\e[00;01;07;37m");

	wr_dtab(GL_DTAB,"C_DEF",'S',0,"\e[00m"         );
	wr_dtab(GL_DTAB,"R_DEF",'S',0,"\e[00m"         );	/* Alias */

/* 4-bit Color */
	wr_dtab(GL_DTAB,"c_bla",'S',0,"\e[00;90m"      );
	wr_dtab(GL_DTAB,"c_red",'S',0,"\e[00;91m"      );
	wr_dtab(GL_DTAB,"c_gre",'S',0,"\e[00;92m"      );
	wr_dtab(GL_DTAB,"c_yel",'S',0,"\e[00;93m"      );
	wr_dtab(GL_DTAB,"c_blu",'S',0,"\e[00;94m"      );
	wr_dtab(GL_DTAB,"c_mag",'S',0,"\e[00;95m"      );
	wr_dtab(GL_DTAB,"c_cya",'S',0,"\e[00;96m"      );
	wr_dtab(GL_DTAB,"c_whi",'S',0,"\e[00;97m"      );
                                                                                                      
	wr_dtab(GL_DTAB,"r_bla",'S',0,"\e[00;30;100m"  );
	wr_dtab(GL_DTAB,"r_red",'S',0,"\e[00;30;101m"  );
	wr_dtab(GL_DTAB,"r_gre",'S',0,"\e[00;30;102m"  );
	wr_dtab(GL_DTAB,"r_yel",'S',0,"\e[00;30;103m"  );
	wr_dtab(GL_DTAB,"r_blu",'S',0,"\e[00;30;104m"  );
	wr_dtab(GL_DTAB,"r_mag",'S',0,"\e[00;30;105m"  );
	wr_dtab(GL_DTAB,"r_cya",'S',0,"\e[00;30;106m"  );
	wr_dtab(GL_DTAB,"r_whi",'S',0,"\e[00;30;107m"  );

	wr_dtab(GL_DTAB,"c_def",'S',0,"\e[00m"         );
	wr_dtab(GL_DTAB,"r_def",'S',0,"\e[00m"         );	/* Alias */

// プロセス定数
	wr_dtab(GL_DTAB,"PID"           ,'I',0,(tint)getpid()           );
	wr_dtab(GL_DTAB,"$$"            ,'I',0,(tint)getpid()           );
	wr_dtab(GL_DTAB,"$?"            ,'I',0,0                        );

// シグナル定数
	wr_dtab(GL_DTAB,"SIG_DFL"       ,'P',0,SIG_DFL                  );
	wr_dtab(GL_DTAB,"SIG_IGN"       ,'P',0,SIG_IGN                  );
	wr_dtab(GL_DTAB,"SIG_ERR"       ,'P',0,NULL                     );

	wr_dtab(GL_DTAB,"NSIG"          ,'I',0,(tint)NSIG               );

	wr_dtab(GL_DTAB,"SIGABRT"       ,'I',0,(tint)SIGABRT            );	// POSIX.1-1990 Standard
	wr_dtab(GL_DTAB,"SIGALRM"       ,'I',0,(tint)SIGALRM            );	// POSIX.1-1990 Standard
	wr_dtab(GL_DTAB,"SIGCHLD"       ,'I',0,(tint)SIGCHLD            );	// POSIX.1-1990 Standard
	wr_dtab(GL_DTAB,"SIGCONT"       ,'I',0,(tint)SIGCONT            );	// POSIX.1-1990 Standard
	wr_dtab(GL_DTAB,"SIGFPE"        ,'I',0,(tint)SIGFPE             );	// POSIX.1-1990 Standard
	wr_dtab(GL_DTAB,"SIGHUP"        ,'I',0,(tint)SIGHUP             );	// POSIX.1-1990 Standard
	wr_dtab(GL_DTAB,"SIGILL"        ,'I',0,(tint)SIGILL             );	// POSIX.1-1990 Standard
	wr_dtab(GL_DTAB,"SIGINT"        ,'I',0,(tint)SIGINT             );	// POSIX.1-1990 Standard
	wr_dtab(GL_DTAB,"SIGKILL"       ,'I',0,(tint)SIGKILL            );	// POSIX.1-1990 Standard
	wr_dtab(GL_DTAB,"SIGPIPE"       ,'I',0,(tint)SIGPIPE            );	// POSIX.1-1990 Standard
	wr_dtab(GL_DTAB,"SIGQUIT"       ,'I',0,(tint)SIGQUIT            );	// POSIX.1-1990 Standard
	wr_dtab(GL_DTAB,"SIGSEGV"       ,'I',0,(tint)SIGSEGV            );	// POSIX.1-1990 Standard
	wr_dtab(GL_DTAB,"SIGSTOP"       ,'I',0,(tint)SIGSTOP            );	// POSIX.1-1990 Standard
	wr_dtab(GL_DTAB,"SIGTERM"       ,'I',0,(tint)SIGTERM            );	// POSIX.1-1990 Standard
	wr_dtab(GL_DTAB,"SIGTSTP"       ,'I',0,(tint)SIGTSTP            );	// POSIX.1-1990 Standard
	wr_dtab(GL_DTAB,"SIGTTIN"       ,'I',0,(tint)SIGTTIN            );	// POSIX.1-1990 Standard
	wr_dtab(GL_DTAB,"SIGTTOU"       ,'I',0,(tint)SIGTTOU            );	// POSIX.1-1990 Standard
	wr_dtab(GL_DTAB,"SIGUSR1"       ,'I',0,(tint)SIGUSR1            );	// POSIX.1-1990 Standard
	wr_dtab(GL_DTAB,"SIGUSR2"       ,'I',0,(tint)SIGUSR2            );	// POSIX.1-1990 Standard
}
