/*** DTSUP.C ***/						#include	"main.h"

/************************************************************************************************/
// IDX2CDX(), CDX2SCP(), CDX2IDX()	-> Convert {E|G|S|L}+Idx into CDX, CDX into {E|G|S|L} or Idx.
// DEREF()  , DEREF_A()				-> DeRefer 'R' DTAB ( S[I] or P[I] -> I ) | Return Addr.
// CDX2P_DTAB()|_DRAW()|_PREV()|_ORIG()	-> Convert CDX into Pointer to DTAB on XX_DTAB or DS[].
// CTR2P_DTAB()|_DRAW()|_PREV()|_ORIG()	-> Convert CTR into Pointer to DTAB on XX_DTAB or DS[].
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
tint idx2cdx(int scope,int index){		// 'SCOPE' + Index => CDX
tint	cdx = ( ((scope&0xFF)<<24) | (index&0xFFFFFF) );	return(cdx); }

/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
int cdx2scp(tint cdx){					// CDX => 'SCOPE'
int		scope = ( (cdx>>24)&0xFF );							return(scope); }

/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
int cdx2idx(tint cdx){					// CDX => Index
int		index = ( (cdx)&0xFFFFFF );							return(index); }

/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
dtab *deref(dtab *p_refs){				// P_DTAB => P_DTAB
dtab	*p_vals;				tint	idx;
/* NULL or NoRefs */
	if( p_refs==NULL || p_refs->type!='R' ){ return p_refs; }	// Return AsIs !!
/* Do DeRef !! */
	idx = p_refs->ival;
	if( p_refs->attr!=INVA && idx<0 ){ idx += p_refs->attr; }	// STR[-1] => STR[LEN-1]
	if( p_refs->attr!=INVA && ( idx<0 || (p_refs->attr)<idx ) ){ flag_exerr=E_REFIDX; return(NULL); }
	p_vals       = X_MALL(sizeof(dtab)); init_dtab(p_vals);
	p_vals->name = X_SDUP("(DeRef)");
	p_vals->type = 'I';
	p_vals->ival = ((p_refs->str)[idx])&0xFF;					// Disable Sign Extension
	return p_vals;
}

/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
char *deref_a(dtab *p_refs){			// P_DTAB => Addr
tint	idx;
/* Do DeRef !! */
	idx = p_refs->ival;
	if( p_refs->attr!=INVA && idx<0 ){ idx += p_refs->attr; }	// STR[-1] => STR[LEN-1]
	if( p_refs->attr!=INVA && ( idx<0 || (p_refs->attr)<idx ) ){ flag_exerr=E_REFIDX; return(NULL); }
	return &((p_refs->str)[idx]);
}

/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
dtab *cdx2p_dtab(tint cdx){				// CDX => P_DTAB		( @ Curr Frame					)
dtab	*p_dtab;
// Index of CDX for (GL_DTAB|ST_DTAB|LC_DTAB) always starts with 1 because of { Admin }.
// 1) GL_DTAB & ST_DTAB also have { Admin }, so we don't need to adjust it here.
// 2) DS[] (LC_DTAB) also have { Admin }, but offset from DP_BASE start with 0. ( Must Adjust )
	switch( cdx2scp(cdx) ){				/* SCOPE */
		case 'G': p_dtab = mem[GL_DTAB                        ]; p_dtab += cdx2idx(cdx); break;
		case 'S': p_dtab = mem[mp_base         +ST_DTAB       ]; p_dtab += cdx2idx(cdx); break;
		case 'L': p_dtab = &ds[dp_base         +cdx2idx(cdx)-1];                         break;
		default:
			return NULL;
	}
	return( deref(p_dtab) );
}

/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
dtab *cdx2p_draw(tint cdx){				// CDX => P_DTAB		( @ Curr Frame + W/O DeRef !!	)
dtab	*p_dtab;
	switch( cdx2scp(cdx) ){				/* SCOPE */
		case 'G': p_dtab = mem[GL_DTAB                        ]; p_dtab += cdx2idx(cdx); break;
		case 'S': p_dtab = mem[mp_base         +ST_DTAB       ]; p_dtab += cdx2idx(cdx); break;
		case 'L': p_dtab = &ds[dp_base         +cdx2idx(cdx)-1];                         break;
		default:
			return NULL;
	}
	return( p_dtab );					/*** W/O DeRef !! ***/
}

/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
dtab *cdx2p_prev(tint cdx){				// CDX => P_DTAB		( @ Prev Frame					)
dtab	*p_dtab;
	switch( cdx2scp(cdx) ){				/* SCOPE */
		case 'G': p_dtab = mem[GL_DTAB                        ]; p_dtab += cdx2idx(cdx); break;
		case 'S': p_dtab = mem[rs[rp-1].mp_base+ST_DTAB       ]; p_dtab += cdx2idx(cdx); break;
		case 'L': p_dtab = &ds[rs[rp-1].dp_base+cdx2idx(cdx)-1];                         break;
		default:
			return NULL;
	}
	return( deref(p_dtab) );
}

/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
dtab *cdx2p_orig(tint cdx){				// CDX => P_DTAB		( @ Orig LC_DTAB, Not DS[]		)
dtab	*p_dtab;
	switch( cdx2scp(cdx) ){				/* SCOPE */
		case 'G': p_dtab = mem[GL_DTAB                        ]; p_dtab += cdx2idx(cdx); break;
		case 'S': p_dtab = mem[mp_base         +ST_DTAB       ]; p_dtab += cdx2idx(cdx); break;
		case 'L': p_dtab = mem[mp_base         +LC_DTAB       ]; p_dtab += cdx2idx(cdx); break;
		default:
			return NULL;
	}
	return( deref(p_dtab) );
}

/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
dtab *ctr2p_dtab   (ctree *ptr){		// CTR => P_DTAB
dtab	*p_dtab;
	if( ptr==NULL || (ptr->op!=0x00&&ptr->op!=0xFF) )
		return NULL;
	p_dtab = ( ptr->op==0x00 ? cdx2p_dtab((tint)(ptr->x)) : (dtab *)(ptr->x) );
	return( deref(p_dtab) );
}

/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
dtab *ctr2p_draw   (ctree *ptr){		// CTR => P_DTAB
dtab	*p_dtab;
	if( ptr==NULL || (ptr->op!=0x00&&ptr->op!=0xFF) )
		return NULL;
	p_dtab = ( ptr->op==0x00 ? cdx2p_draw((tint)(ptr->x)) : (dtab *)(ptr->x) );
	return( p_dtab );					/*** W/O DeRef !! ***/
}

/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
dtab *ctr2p_prev(ctree *ptr){			// CTR => P_DTAB
dtab	*p_dtab;
	if( ptr==NULL || (ptr->op!=0x00&&ptr->op!=0xFF) )
		return NULL;
	p_dtab = ( ptr->op==0x00 ? cdx2p_prev((tint)(ptr->x)) : (dtab *)(ptr->x) );
	return( deref(p_dtab) );
}

/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
dtab *ctr2p_orig(ctree *ptr){			// CTR => P_DTAB
dtab	*p_dtab;
	if( ptr==NULL || (ptr->op!=0x00&&ptr->op!=0xFF) )
		return NULL;
	p_dtab = ( ptr->op==0x00 ? cdx2p_orig((tint)(ptr->x)) : (dtab *)(ptr->x) );
	return( deref(p_dtab) );
}

static dtab *do_dupbar(dtab *s_bar);

/************************************************************************************************/
// CPY_DTAB()	-> Copy DTAB from SRC to DST Except "Name"&"Ukey" ( DST <- SRC ).
// EQL_DTAB()	-> Compare DTAB and check equality, then return TRUE/FALS.
/************************************************************************************************/
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
void cpy_dtab(dtab *dst,dtab *src){		// CPY_DTAB() assumes I_ASGN()
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
dtab	*e_dst,*e_src;	int		i;		/* Pointer to DTAB ( DST & SRC )						*/
/* Self Copy */
	if( dst==src ){ return; }			/* Skip Self Copy										*/
/* Name & Ukey */
	;
/* Type & Attr */
	dst->type = src->type;
	if( dst->attr & ATTR_IGNR )			/* Preserve ATTR_IGNR for consistency					*/
		dst->attr = ( src->attr | ATTR_IGNR );
	else								/* Copy AsIs anyway, you can modify it later.			*/
		dst->attr = ( src->attr             );
/* Data (Str/Ival/Dval/Ptr/Ptr2) */
	dst->str  = (src->type=='S') ? X_SDUP(src->str) : NULL;
	dst->ival = src->ival;
	dst->dval = src->dval;
	dst->ptr  = src->ptr;				/* Should share PTR  each other!! ('S'=>FILE|'P'=>ARRY)	*/
	dst->ptr2 = src->ptr2;				/* Should share PTR2 each other!! ('S'=>/RE/|'P'=>HASH)	*/
/* ( Strt.Id ) */						/* ??? ( Func Param(s): SRC->PTR2==NULL ) ???			*/
	if( src->type=='A' && ((src->attr)&ATTR_STID) && src->ptr !=NULL ){	/* Std.Arry[] */
	/* >Alloc & Copy Dtab BAR */
		dst->ptr = do_dupbar(src->ptr);
	}
	if( src->type=='A' && ((src->attr)&ATTR_STID) && src->ptr2!=NULL ){	/* Ext.Hash[] */
	/* >Alloc & Copy Dtab BAR */
		e_src = src->ptr2;
		e_dst = dst->ptr2 = X_MALL(sizeof(dtab)*MAX_EHIDX);
		memcpy( e_dst , e_src , sizeof(dtab)*MAX_EHIDX );
	/* >Alloc & Copy ELMT(s) */
		for( i=0 ; i<MAX_EHIDX ; i++ ){
			if(e_dst[i].link!=NULL){
				e_dst[i].link = X_MALL(sizeof(dtab)*e_dst[i].ival);
				memcpy( e_dst[i].link , e_src[i].link , sizeof(dtab)*e_dst[i].ival );
			}
		}
	}
}

/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
static dtab *do_dupbar(dtab *s_bar){
dtab	*d_bar,*e;		int		i;
/* Dup Self */
	d_bar = X_MALL(sizeof(dtab)*MAX_SAIDX);
	memcpy( d_bar , s_bar , sizeof(dtab)*MAX_SAIDX );
/* Dup Chld */
	for( i=0 ; i<MAX_SAIDX ; i++ ){
		e = &d_bar[i];
		if(e->link!=NULL)
			e->link = do_dupbar(e->link);
	}
/* Return */
	return(d_bar);
}

/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
int eql_dtab(dtab *dst,dtab *src){		// EQL_DTAB() compares "Type"&"Data"
/* Name & Ukey */
	;
/* Type & Attr */
	if( dst->type != src->type )
		return(FALS);
/* Data (Str/Ival/Dval/Ptr/Ptr2) */
	switch( dst->type ){
		case 'U':	return(TRUE);
		case 'S': if( strcmp(dst->str,src->str)==0 ){ return(TRUE); } break;
		case 'I': if( dst->ival == src->ival ){ return(TRUE); } break;
		case 'D': if( dst->dval == src->dval ){ return(TRUE); } break;
		case 'P': if( dst->ptr  == src->ptr  ){ return(TRUE); } break;
		case 'X': if((dst->attr == src->attr)&&(dst->ptr  == src->ptr )){ return(TRUE); } break;
		case 'A': if((dst->ptr  == src->ptr )&&(dst->ptr2 == src->ptr2)){ return(TRUE); } break;
	}
/* Diff */
	return(FALS);
}

// *** NOTE *** Dtab の Link は、Std.Arry[] の Elmt であって、かつ、Deep Elmt を持つもの、及び、
// Ext.Hash[] の Dtab Bar でのみ使用される。（他は、全て NULL となる。）
// なお、Dtab Data を同時に持ち得るのは前者のみである。（後者は Dtab Data を同時に持ち得ない。）

// CPY_DTAB(): Dtab Data のコピー時に使用。
// > DST に Link が有る時は、Std.Arry[] Elmt with Deep Elmt であるので、Link の上書きはNG !!
// > SRC に Link が有る時も、Std.Arry[] Elmt with Deep Elmt であるので、Link のコピーもNG !!
// > 結局、Link はコピーしてはいけない。

/************************************************************************************************/
// INIT_DTAB(): Dtab Data の完全初期化時  に使用。（ Link=NULL とする為、 Elmt データに使用不可。）
// UDEF_DTAB(): Dtab Data の 'U'      化時に使用。（ Link 操作はしない為、Elmt データに使用可能。）
// NULL_DTAB(): Dtab Data の 'P' NULL 化時に使用。（ Link 操作はしない為、Elmt データに使用可能。）
// VOID_DTAB(): Dtab Data の 'U' VOID 化時に使用。（ Link 操作はしない為、Elmt データに使用可能。）
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
void init_dtab(dtab *p_dtab){
/* Name & Ukey */
	;
/* Type & Attr */
	p_dtab->type='U'; p_dtab->attr &= ATTR_IGNR;	/* Reset ATTR except for ATTR_IGNR				*/
/* Data */
	p_dtab->str=NULL; p_dtab->ival=0; p_dtab->dval=0.0; p_dtab->ptr=NULL; p_dtab->ptr2=NULL; p_dtab->link=NULL;
}

/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
void udef_dtab(dtab *p_dtab){
/* Name & Ukey */
	;
/* Type & Attr */
	p_dtab->type='U'; p_dtab->attr &= ATTR_IGNR;	/* Reset ATTR except for ATTR_IGNR				*/
/* Data */
	p_dtab->str=NULL; p_dtab->ival=0; p_dtab->dval=0.0; p_dtab->ptr=NULL; p_dtab->ptr2=NULL;/*p_dtab->link=NULL;*/
}

/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
void void_dtab(dtab *p_dtab){
/* Name & Ukey */
	p_dtab->name=X_SDUP("(void)");
/* Type & Attr */
	p_dtab->type='U'; p_dtab->attr &= ATTR_IGNR;	/* Reset ATTR except for ATTR_IGNR				*/
/* Data */
	p_dtab->str=NULL; p_dtab->ival=0; p_dtab->dval=0.0; p_dtab->ptr=NULL; p_dtab->ptr2=NULL;/*p_dtab->link=NULL;*/
}

/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
void null_dtab(dtab *p_dtab){
/* Name & Ukey */
	;
/* Type & Attr */
	p_dtab->type='P'; p_dtab->attr &= ATTR_IGNR;	/* Reset ATTR except for ATTR_IGNR				*/
/* Data */
	p_dtab->str=NULL; p_dtab->ival=0; p_dtab->dval=0.0; p_dtab->ptr=NULL; p_dtab->ptr2=NULL;/*p_dtab->link=NULL;*/
}

/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
void true_dtab(dtab *p_dtab){
/* Name & Ukey */
	;
/* Type & Attr */
	p_dtab->type='I'; p_dtab->attr &= ATTR_IGNR;	/* Reset ATTR except for ATTR_IGNR				*/
/* Data */
	p_dtab->str=NULL; p_dtab->ival=TRUE; p_dtab->dval=0.0; p_dtab->ptr=NULL; p_dtab->ptr2=NULL;/*p_dtab->link=NULL;*/
}

/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
void fals_dtab(dtab *p_dtab){
/* Name & Ukey */
	;
/* Type & Attr */
	p_dtab->type='I'; p_dtab->attr &= ATTR_IGNR;	/* Reset ATTR except for ATTR_IGNR				*/
/* Data */
	p_dtab->str=NULL; p_dtab->ival=FALS; p_dtab->dval=0.0; p_dtab->ptr=NULL; p_dtab->ptr2=NULL;/*p_dtab->link=NULL;*/
}

/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
int isdef (dtab *p_dtab){ return( p_dtab->type!='U'                                           ); }
int isnull(dtab *p_dtab){ return( p_dtab->type=='P' && p_dtab->ptr==NULL                      ); }
int isvoid(dtab *p_dtab){ return( p_dtab->type=='U' && p_dtab->name!=NULL && strcmp(p_dtab->name,"(void)")==0 ); }
int issptr(dtab *p_dtab){ return( p_dtab->type=='S' ||                      p_dtab->type=='P' ); }
int isiptr(dtab *p_dtab){ return( p_dtab->type=='I' ||                      p_dtab->type=='P' ); }
int isdptr(dtab *p_dtab){ return( p_dtab->type=='I' || p_dtab->type=='D' || p_dtab->type=='P' ); }
int isdigv(dtab *p_dtab){ return( p_dtab->type=='I' || p_dtab->type=='D'                      ); }
int isinfv(dtab *p_dtab){ return( p_dtab->type=='D' && isinf(p_dtab->dval)                    ); }

int isstr (dtab *p_dtab){ return( p_dtab->type=='S' ); }
int isint (dtab *p_dtab){ return( p_dtab->type=='I' ); }
int isdbl (dtab *p_dtab){ return( p_dtab->type=='D' ); }
int isptr (dtab *p_dtab){ return( p_dtab->type=='P' ); }
int isfunc(dtab *p_dtab){ return( p_dtab->type=='F' ); }
int isarry(dtab *p_dtab){ return( p_dtab->type=='A' ); }

/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
int istrue(dtab *p_dtab){				// TRUE => !( 'P'=NULL || 'I'=0 || 'D'=0.0 )
	if( p_dtab->type=='U' ) return(FALS);
	return( (isnull(p_dtab)||(p_dtab->type=='I'&&cint(p_dtab)==0)||(p_dtab->type=='D'&&cint(p_dtab)==0)) ? FALS:TRUE);
}
int isfals(dtab *p_dtab){				// FALS =>  ( 'P'=NULL || 'I'=0 || 'D'=0.0 )
	if( p_dtab->type=='U' ) return(FALS);
	return( (isnull(p_dtab)||(p_dtab->type=='I'&&cint(p_dtab)==0)||(p_dtab->type=='D'&&cint(p_dtab)==0)) ? TRUE:FALS);
}

/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
int ismatx(dtab *p_dtab){ return( p_dtab->type=='A' && (p_dtab->attr&ATTR_MAID)               ); }
int ismatv(dtab *p_dtab){ return( p_dtab->type=='I' || p_dtab->type=='P' || p_dtab->type=='D' ); }

int ismatx_allelmt(dtab *p_dtab){
dtab	*mx;			int		xi,xj,xv;		// Matrix Parameter
/* Quick Check */
	if( !ismatx(p_dtab) ) return FALS;
/* Set Params & Flags */
	xi = matx_getrow(p_dtab);
	xj = matx_getcol(p_dtab);
	xv = ( xi==0&&xj!=0 );						// Vector Flag (T/F)
/* For All Elmt */
	for( int i=0 ; i<xi || (i==0&&xv) ; i++ ){	// Matrix|Vector
		for ( int j=0 ; j<xj ; j++ ){
			mx = ( xv ? di2p_dtab(p_dtab,j) : dm2p_dtab(p_dtab,i,j) );
			if( !ismatv(mx) ) return FALS;
		}
	}
	return TRUE;
}
