/*** GCSUP.C ***/						#include	"main.h"

#define	ga(MSG,SIZE)	if( flag_debug&DF_GCLIB){ ga_cntr++; ga_size+=SIZE; /*** GC-ALLOC ***/\
	eprin("[%sGc%s] %s (%d) [A=%"PRIdTINT"(%"PRIdTINT"MB)/F=%"PRIdTINT"(%"PRIdTINT"MB)]\n",\
	C_YEL(2), C_DEF(2), MSG, SIZE, ga_cntr, ga_size/(1024*1024), gf_cntr, gf_size/(1024*1024));\
}
#define	gf(MSG,SIZE)	if( flag_debug&DF_GCLIB){ gf_cntr++; gf_size+=SIZE; /*** GC-FREE  ***/\
	eprin("[%sGc%s] %s (%d) [A=%"PRIdTINT"(%"PRIdTINT"MB)/F=%"PRIdTINT"(%"PRIdTINT"MB)]\n",\
	C_YEL(2), C_DEF(2), MSG, SIZE, ga_cntr, ga_size/(1024*1024), gf_cntr, gf_size/(1024*1024));\
}

/************************************************************************************************/
// X_FREE(),X_ATOM(),X_MALL(),X_RALL() - FREE(),MALLOC(),REALLOC() with error checking in BoehmDW-GC world.
// X_SDUP(),X_NDUP() - STRDUP(),STRDUP.MaxN() with error checking in BoehmDW-GC world.
// X_SCAT(),X_NCAT() - STRCAT(),STRCAT.MaxN() with error checking in BoehmDW-GC world.
/************************************************************************************************/
void X_FREE(void *ptr){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/

/* Do X_FREE()!! */						gf("X_FREE()",(int)strlen2(ptr));
	GC_FREE(ptr);
}

void *X_ATOM(int size){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
void	*ptr;

/* Do X_ATOM()!! */						ga("X_ATOM()",size);
	if( (ptr=GC_MALLOC_ATOMIC(size)) == NULL )	// The memory is *NOT* cleared!!
		dying("Panic!! - GC_MALLOC_ATOMIC() Error!! [Func=%s(),Size=%d]\n",__func__,size);
	*((char *)ptr)='\0';
/* Return */
	return(ptr);
}

void *X_MALL(int size){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
void	*ptr;

/* Do X_MALL()!! */						ga("X_MALL()",size);
	if( (ptr=GC_MALLOC(size)) == NULL )			// The memory is cleared!!
		dying("Panic!! - GC_MALLOC() Error!! [Func=%s(),Size=%d]\n",__func__,size);
/* Return */
	return(ptr);
}

/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
void *X_RALL(void *ptr,int size){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/

/* Do X_RALL()!! - Allow NULL - */		ga("X_RALL()",size);
	if( (ptr=GC_REALLOC(ptr,size)) == NULL )
		dying("Panic!! - GC_REALLOC() Error!! [Func=%s(),Addr=%p,Size=%d]\n",__func__,ptr,size);
/* Return */
	return(ptr);
}

/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
char *X_SDUP(char *org){				// ATOMIC !! Don't include POINTER !!
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
char	*ptr;			int		len = strlen2(org);

/* Do X_SDUP()!! - Allow NULL - */		ga("X_SDUP()",len);
	if( (ptr=GC_MALLOC_ATOMIC(len+1)) == NULL )	// GC_MALLOC_ATOMIC() - THE MEMORY IS NOT CLEARED !!
		dying("Panic!! - GC_MALLOC_ATOMIC() Error!! [Func=%s(),Size=%d]\n",__func__,len+1);
	ptr[0]='\0'; strcpy2(ptr,org);
/* Return */
	return(ptr);
}

/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
char *X_NDUP(char *org,int n){			// ATOMIC !! Don't include POINTER !!
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
char	*ptr;			int		len = n;

/* Do X_NDUP()!! - Allow NULL - */		ga("X_NDUP()",len);
	if( (ptr=GC_MALLOC_ATOMIC(len+1)) == NULL )	// GC_MALLOC_ATOMIC() - THE MEMORY IS NOT CLEARED !!
		dying("Panic!! - GC_MALLOC_ATOMIC() Error!! [Func=%s(),Size=%d]\n",__func__,len+1);
	ptr[0]='\0'; strncpy2(ptr,org,n);
/* Return */
	return(ptr);
}

/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
char *X_SCAT(char *dst,char *src){		// ATOMIC !! Don't include POINTER !!
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
char	*ptr;			int		len = strlen2(dst)+strlen2(src);

/* Do X_SCAT()!! - Allow NULL - */		ga("X_SCAT()",len);
	if( (ptr=GC_MALLOC_ATOMIC(len+1)) == NULL )	// GC_MALLOC_ATOMIC() - THE MEMORY IS NOT CLEARED !!
		dying("Panic!! - GC_MALLOC_ATOMIC() Error!! [Func=%s(),Size=%d]\n",__func__,len+1);
	ptr[0]='\0'; strcpy2(ptr,dst); strcat2(ptr,src);
/* Return */
	return(ptr);
}

/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
char *X_NCAT(char *dst,char *src,int n){// ATOMIC !! Don't include POINTER !!
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
char	*ptr;			int		len = strlen2(dst)+n;

/* Do X_NCAT()!! - Allow NULL - */		ga("X_NCAT()",len);
	if( (ptr=GC_MALLOC_ATOMIC(len+1)) == NULL )	// GC_MALLOC_ATOMIC() - THE MEMORY IS NOT CLEARED !!
		dying("Panic!! - GC_MALLOC_ATOMIC() Error!! [Func=%s(),Size=%d]\n",__func__,len+1);
	ptr[0]='\0'; strcpy2(ptr,dst); strncat2(ptr,src,n);
/* Return */
	return(ptr);
}

/************************************************************************************************/
// X_SSUB() s/STR1/STR2/1 in STR0 with error checking, then returns X_SDUP()ed result.
// X_GSUB() s/STR1/STR2/g in STR0 with error checking, then returns X_SDUP()ed result.
// X_EXPN() expands TAB into SP(s)                   , then returns X_SDUP()ed result.
/************************************************************************************************/
char *X_SSUB(char *str0,char *str1,char *str2){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
char	*dup,*ps,*pe;	int		len;

/* SSUB /str1/str2/ - Allow NULL - */
	if( str0==NULL ) return NULL;
	ps = strstr(str0,str1);
	pe = ps+strlen2(str1);
	if( ps==NULL )						/*** Not Found!!	***/
		dup = X_SDUP(str0);
	else{								/***     Found!!	***/
		len = strlen2(str0)-strlen2(str1)+strlen2(str2);
		if( (dup=GC_MALLOC(len+1)) == NULL )
			dying("Panic!! - GC_MALLOC() Error!! [Func=%s(),Size=%d]\n",__func__,len+1);
		strncpy2(dup,str0,ps-str0); strcat2(dup,str2); strcat2(dup,pe);
	}
/* Return */
	return(dup);
}

/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
char *X_GSUB(char *str0,char *str1,char *str2){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
char	*dup = X_SDUP(str0);

/* GSUB /str1/str2/ - Allow NULL - */
	if( str0==NULL ) return NULL;
	while( strstr(dup,str1)!=NULL ){ dup=X_SSUB(dup,str1,str2); }
/* Return */
	return(dup);
}

/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
char *X_EXPN(char *str,int n){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
char	buf[BUFSIZ];	int		s,d,i;

/* Expand STR - Allow NULL - */
	if( str==NULL ) return NULL;
	for( s=0,d=0 ; (buf[d]=str[s])!='\0' ; s++,d++ ){
		if( buf[d]=='\t' ){
			for( i=d ; i<(d/n+1)*n ; i++ ){ buf[i]=' '; }
			d=i-1;
		}
	}
/* Return */
	return(X_SDUP(buf));
}

/************************************************************************************************/
// X_GETS() reads 1 line data from (FILE *)FP, then returns X_SDUP()ed string or NULL.
/************************************************************************************************/
char *X_GETS(FILE *fp){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
char	buf[BUFSIZ],*ans=NULL;			/* Buffer & Pointer to Result							*/
int		clen=0,tlen=0;					/* Current/Total Length									*/

/* Read Line Loop */
	while( fgets(buf,BUFSIZ,fp)!=NULL ){
		clen=strlen2(buf); tlen+=clen; ans=X_SCAT(ans,buf);
		if( clen!=BUFSIZ-1 || buf[clen-1]=='\n' )
			break;						/*** End Of 1 Line ***/
	}
/* Return */
	return(ans);
}

/************************************************************************************************/
// ISREG() checks whether given DTAB is "/RE/o" or not.  (T/F)
/************************************************************************************************/
int isreg(dtab *p_dtab){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/

	if( p_dtab->type=='S' && p_dtab->ptr2!=NULL )
		return(TRUE);
	return(FALS);
}

/************************************************************************************************/
// REGCC() compiles "/RE/o" string stored in P_DTAB->STR and saves the result into P_DTAB->PTR2.
/************************************************************************************************/
void regcc(dtab *p_dtab){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
char	*re_str;		int	re_opt;		/* Pointer to [RE] String & [i] Option in "/RE/i"		*/
int		len = strlen2(p_dtab->str);
regex_t	preg;							/* /RE/ Compiled Pattern Buffer  ( POSIX Standard )		*/
int		errcode;						/* /RE/ Error Code               ( POSIX Standard )		*/
char	errbuf[BUFSIZ];					/* /RE/ Error Message Buffer     ( POSIX Standard )		*/

/* CASE: "/RE/"  */
	if( len>=2 && (p_dtab->str)[0]=='/' && (p_dtab->str)[len-1]=='/' ){
		re_opt = (REG_EXTENDED|REG_NEWLINE          );		/*** No Option ***/
		re_str = X_NDUP( &((p_dtab->str)[1]), len-2 );
	}
/* CASE: "/RE/i" */
	else if( len>=3 && (p_dtab->str)[0]=='/' && (p_dtab->str)[len-2]=='/' && (p_dtab->str)[len-1]=='i' ){
		re_opt = (REG_EXTENDED|REG_NEWLINE|REG_ICASE);		/*** /i Option ***/
		re_str = X_NDUP( &((p_dtab->str)[1]), len-3 );
	}
/* CASE: "RE"    */
	else{
		re_opt = (REG_EXTENDED|REG_NEWLINE          );		/*** No Option ***/
		re_str = p_dtab->str;
	}
/* Compile "RE" with Option */
	errcode = regcomp(&preg,re_str,re_opt);
	if( errcode!=0 ){
		regerror(errcode,&preg,errbuf,BUFSIZ);
		msg_r("Error - /RE/ Compile Error!! [/RE/=\"%s\",ErrCode=%d]\n",p_dtab->str,errcode);
		flag_exerr=E_REGEXP; return;
	}
/* Save Compiled /RE/ Pattern */
	p_dtab->ptr2 = X_ATOM(sizeof(preg));		// Compile & Save /RE/
	*((regex_t *)(p_dtab->ptr2)) = preg;
}
