/*** HELP.C ***/

#include	"main.h"					/* "TwinTail_de_AngelMode!!" System Header File			*/

char *manall_title = "【全部】";
char *colcmd_title = ":コマンド < Runtime Command >";
char *langfv_title[] = {
	"基本事項 ( データ型 と 変数の定義＆関数の定義 )",
	"コマンドライン引数 と 環境変数",
	"ファイル入出力 と 書式付き出力＆簡易出力",
	"文字列の操作 と データの操作",
	"ネットワーク(TCP/IP,UDP/IP,RAW)",
	"日付(Date) と 時刻(Time)",
	"数学関数 と 整数＆実数",
	"プロセス と 割り込み ＋ メモリ管理",
	NULL
};

/************************************************************************************************/
// DISP_USAGE() - Display TT-Engine Usage.
/************************************************************************************************/
void disp_usage(void){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
	eprin("\n");
	eprin("Usage: %s %s %s [ %sOption%s ]  [ %sFileName%s | %sScript%s ]\n",R_BLU(2),TTdeAM_CMD,C_DEF(2),cya,mag,mag);
	eprin("\n");
	eprin("  %s-h%s | %s-?%s = Display Usage   Information ( This Page ) && Exit\n"		,cya,cya		);
	eprin("  %s-v     %s = Display Version Information               && Exit\n"			,cya			);
	eprin("  %s-i     %s = Execute in Interactive Mode\n"								,cya			);
	eprin("  %s-e     %s = Execute in OneLiner    Mode\n"								,cya			);
	eprin("  %s-t%s | %s-x%s = Enable Trace for Debug [ %s-t -tt -ttt%s | %s-x%s ]\n"	,cya,cya,cya,cya);
	eprin("  %s-c%s | %s-m%s = { Color | Mono } Text Mode ( Default: Auto )\n"			,cya,cya		);
	eprin("\n");
	eprin("!!! %sDisplay Manual%s !!!\n",gre);
			eprin("  %s-%c%s = %s\n",C_GRE(2),'*',C_DEF(2),manall_title     );
			eprin("  %s-%c%s = %s\n",C_GRE(2),':',C_DEF(2),colcmd_title     );
		for( int idx=0 ; langfv_title[idx]!=NULL ; idx++ )
			eprin("  %s-%d%s = %s\n",C_GRE(2),idx,C_DEF(2),langfv_title[idx]);
	eprin("\n");
	eprin("!!! %sDebug Option%s !!!\n"	,yel);
	eprin("  \"--\"Dummy \"-C\"kOnly \"-F\"lex \"-B\"ison \"-M\"em \"-G\"c \"-N\"et \"-^\"Sig \"-!\"Ctr\n");
	eprin("\n");
}

/************************************************************************************************/
// DISP_VERNO() - Display TT-Engine Version.
/************************************************************************************************/
void disp_verno(void){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
	eprin("\n");
	eprin("TwinTail_de_AngelMode!! Ver.%s%s%s",C_BLU(2),TTdeAM_VER,C_DEF(2));
	eprin(" (Int=%s%zu%s[Bit]/Dbl=%s%zu%s[Bit]/Ptr=%s%zu%s[Bit])\n",
		C_GRE(2),sizeof(tint )*8,C_DEF(2),C_GRE(2),sizeof(tdbl )*8,C_DEF(2),C_GRE(2),sizeof(void*)*8,C_DEF(2));
	eprin("Copyright (C) 2011.08.15-2023 \"%sNekoMimi(F)%s\" <twintail@angelmode.net>\n",red);
	eprin("\n");
}

/************************************************************************************************/
// DISP_MANUAL() display ":CMD" Help & TT-Lang Manual.
/************************************************************************************************/
void disp_manual(int mode){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
	if( mode=='*' ){					// '*' All Manual
		for( int idx=0 ; langfv_title[idx]!=NULL ; idx++ )
			disp_manual('0'+idx);
	}
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
	if( mode==':' ){					// ':' List :CMD
		eprin("*** %s *** [ \'%s:%s\' must be 1st column ]\n"		,colcmd_title,red);
		eprin("  %s:h | :?     %s -> Display %s ( This Page )\n"	,red,colcmd_title);
		eprin("  %s:r[ead] FILE%s -> Read  TT-Script       from FILE.\n"			,red);
		eprin("  %s:w[rit] FILE%s -> Write Command History into FILE.\n"			,red);
		eprin("  %s:d[ata]     %s -> Set Start of Embedded DATA.\n"					,red);
		eprin("  %s:q[uit]     %s -> Quit TT-Engine ASAP!! ( = Ctrl+C )\n"			,red);
		eprin("\n");
		eprin("!!! %sDebug Command%s !!!\n"											,yel);
		eprin("  %s:t[race] | :not[race]%s -> {Enable|Disable} TT-Script Trace\n"	,yel);
		eprin("  %s:cpu  :mem  :dt ##  :ct ## ( ## = {Dec|Hex} )%s\n"				,yel);
		eprin("%s", mode=='?' ? "\n" : "" );
	}
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
	if( mode=='0' ){					// DataType + Vari&Func
		eprin("%s[Manual表題]%s %s\n",r_blu,langfv_title[mode-'0']);
		eprin("  基本データ型  : U=未定義  S=文字列  I=整数型  D=実数型  P=ポインタ  X=関数型\n"  );
		eprin("  派生データ型  : A=配列型と構造体  A[x]  B[x,y,z]  C.z  配列リテラル  E={x,y,z}\n");
		eprin("  変数の定義    : {global|static|*local*} V=初期値 (*default* ,型は代入値)\n");
		eprin("  関数の定義    : def F(x,y){ ... }                (常にglobal,型は戻り値)\n");
		eprin("\n%s[System変数]%s\n",r_gre);
		eprin("  NULL(P) / TRUE(I) / FALS(I) / VER(I) / {INT|DBL|PTR}_SIZE(I) / DBL_{MANT|EXPO}SIZE(I)\n");
		eprin("\n%s[System関数]%s\n",r_red);
		eprin("  データ型の種別: I=type  (*)    ### 型文字 ###\n");
		eprin("  データ型の判定: I=isnull(*)    I=istrue(*)    I=isfals(*)    I=isstr (*)    i=isint (*)\n");
		eprin("                  I=isdbl (*)    I=isptr (*)    I=isfunc(*)    I=isarry(*)\n"               );
		eprin("  定義判定＆消去: I=isdef (*)    U=erase (*)\n"                                             );
	}
	if( mode=='1' ){					// CmdLine & Environ
		eprin("%s[Manual表題]%s %s\n",r_blu,langfv_title[mode-'0']);
		eprin("\n%s[System変数]%s\n",r_gre);
		eprin("  コマンドライン引数 = argc(I) / argv(A) / argr(I) / args(S) / cmd(S)\n");
		eprin("  環境変数           = env(A)\n");
		eprin("\n%s[System関数]%s\n",r_red);
		eprin("  コマンドライン引数の取得: S=shift([*])   S=optshift([*])\n");
		eprin("  コマンドライン引数の返却:                I=unshift (   )\n");
	}
	if( mode=='2' ){					// FileI/O & *Print*
		eprin("%s[Manual表題]%s %s\n",r_blu,langfv_title[mode-'0']);
		eprin("\n%s[System変数]%s\n",r_gre);
		eprin("  ファイルポインタ   = stdin(P) / stdout(P) / stderr(P) / :code(P) / :data(P)\n");
		eprin("  色彩( ANSI Color ) = {C|B|U|R}_{BLA|RED|GRE|YEL|BLU|MAG|CYA|WHI|DEF}(S)\n");
		eprin("  Default書式[ p() ] = FMT_{S2S|I2S|D2S|P2S|N2S}(S)\n");
		eprin("\n%s[System関数]%s\n",r_red);
		eprin("  １文字単位 I/O: I=getc([F])      I=putc([F,]I)    I=ungetc([F,]I)\n");
		eprin("  １行  単位 I/O: S=gets([F])      I=puts([F,]S)    I=ungets([F,]S)\n");
		eprin("  １行[Max=N]I/O: S=getn([F],N)    I=putn([F,]S,N)  I=ungetn([F,]S,N)\n");
		eprin("  Binary(RAW)I/O: (P,N)=read([F,]N) & N=write([F,]P,N)\n");
		eprin("  Fileポインタ  : P=open(F,S)      I=close(F)       I=flush(F)\n");
		eprin("  File位置管理  : I=getpos(F)      I=setpos(F,I)    I=movpos(F,I)    I=rewind(F)\n");
		eprin("  書式付き出力  : I= print(S...)   I=eprint(S...)   S=sprint(S...)   I=fprint(F,s...)\n");
		eprin("  書式付き終了  : U= dying(S...)\n");
		eprin("  簡易＆詳細出力: U= p    (*...)  又は、変数名      U= d    (*...)\n");
	}
	if( mode=='3' ){					// String & DataProc
		eprin("%s[Manual表題]%s %s\n",r_blu,langfv_title[mode-'0']);
		eprin("\n%s[System変数]%s\n",r_gre);
		eprin("\n%s[System関数]%s\n",r_red);
		eprin("  文字列の比較  : I=strcmp[i](S1,S2)            I=strncmp[i](S1,S2,I)\n");
		eprin("  文字列内の検索: I=str[r]chr(S,chr)            I=str[r]str (S,str)           (Is,Ie)=strreg(S,/RE/)\n");
		eprin("  文字列内の置換: S={s|g}sub(S,@1,@2)           S={e|r}valesc(S)              {S|I}={uc|lc}(S|I)\n");
		eprin("  改行(等)の削除: S=strip (S)                   S={h|t}strip (S)\n");
		eprin("  部分文字(列)  : I=subchr(S,I)                 S=substr(S,Is,Ie)\n");
		eprin("  文字列の配列化: {A|S}=[p]split(S,@[,I])       {A|S}=[p]scan(S,@[,I])\n");
		eprin("  文字の種別    : I=is{alnum|alpha|ascii|blank|cntrl|digit|graph|lower|print|punct|space|upper|xdigit}(I)\n");
		eprin("  データの変換  : I=int(*)       D=dbl(*)       {I|D}=atov(*)  S=str(*)       P=ptr(*)       /RE/=regexp(S)\n");
		eprin("                : I={bin|oct|dec|hex}(S)\n");
		eprin("  消去複製サイズ: U=erase(*)     *=dup  (*)     I=size (*)     I=strlen(S)\n");
		eprin("  配列の変換計測: A=vals (A)     A=keys (A)     I=ndim (A)     A=shape(A)\n");
//                             : |--------------|--------------|--------------|--------------|--------------|
//                             : |--------------|--------------|--------------|--------------|--------------|
	}
	if( mode=='4' ){					// Networking(TCP/IP)
		eprin("%s[Manual表題]%s %s\n",r_blu,langfv_title[mode-'0']);
		eprin("> IPアドレス例: ip   = 127.0.0.1 or 0xFF000001 or \"localhost\"\n");
		eprin("> Port番号  例: port = 7                       or \"echo\"\n");
		eprin("\n%s[System変数]%s\n",r_gre);
		eprin("  {UDP|TCP|RAW}_SOCKET / {UDP|TCP|RAW}_TIMEOUT [Sec]\n");
		eprin("\n%s[System関数]%s\n",r_red);
		eprin("UDPソケット作成: sock = udp_socket([ip,port])   ### Client=不要,Server=必要 ###\n");
		eprin("  UDPデータ送信:     len               = tx_udp([sock,]ip,port,buf[,len])      \n");
		eprin("  UDPデータ受信:     (ip,port,buf,len) = rx_udp([sock])                        \n");
		eprin("TCPソケット作成: sock = tcp_socket([ip,port])   ### Client=不要,Server=必要 ###\n");
		eprin("  *Server側準備: sock = listen ([sock]        )                                \n");
		eprin("  *Client側準備: sock = connect([sock,]ip,port)                                \n");
		eprin("  TCPデータ送信:     len               = tx_tcp([sock,]        buf[,len])      \n");
		eprin("  TCPデータ受信:     (buf,len)         = rx_tcp([sock])                        \n");
		eprin("RAWソケット作成: sock = raw_socket([ip])                                       \n");
		eprin("  Ping送信&受信:     sec = ping(ip)                                            \n");
		eprin("共通 Socket情報: (l_ip,s,l_port,s,l_type,r_ip,s,r_port,s,r_type)=sockinfo(sock)\n");
		eprin("共通 IpAddr変換: s =   ip2str({i|s})        i =   ip2int({i|s})                \n");
		eprin("共通 PortNo変換: s = port2str(Proto,{i|s})  i = port2int(Proto,{i|s})          \n");
	}
	if( mode=='5' ){					// Date & Time
		eprin("%s[Manual表題]%s %s\n",r_blu,langfv_title[mode-'0']);
		eprin("  UNIX時刻値(D): 1970/01/01 00:00:00 経過秒\n");
		eprin("  時刻構造体(A): tm.{year|mon|day|hour|min|sec|wday|yday|isdst}\n");
		eprin("%s[System変数]%s\n",r_gre);
		eprin("  LTZ(\"JST\")  LTZ_OFFSET(+32400)  FMT_SDATE(\"%%Y-%%m-%%d\")  FMT_STIME=(\"%%H:%%M:%%S\")\n");
		eprin("%s[System関数]%s\n",r_red);
		eprin("  現在時刻の取得: *UNIX* D=time()    *PROC* A=ptime() -> A.ptime,A.utime,A.stime    [ ****** ]\n");
		eprin("  UNIX値<>数  値: (Iy,Im,Id,Ih,Im,Ds)=t2ymdhms(D)  D=ymdhms2t(Iy,Im,Id,Ih,Im,Ds)    [ +0 UTC ]\n");
		eprin("                  (Iy,Im,Id)=t2ymd(D)              D=ymd2t(Iy,Im,Id)                [ +0 UTC ]\n");
		eprin("                  (Ih,Im,Ds)=t2hms(D)              D=hms2t(Ih,Im,Ds)                [ +0 UTC ]\n");
		eprin("  UNIX値<>文字列: S=sdate(D)  S=stime(D)  S=strftime(FMT,D)                         [ +0 UTC ]\n");
		eprin("                  D=vdate(S)  D=vtime(S)  D=strptime(FMT,S)                         [ +0 UTC ]\n");
		eprin("  UNIX値<>構造体: A=t2tm (D)  D=tm2t (A)                                            [ +0 UTC ]\n");
		eprin("  構造体<>構造体: A=tm_norm(A)                                                      [ ****** ]\n");
		eprin("  うるう年の判定: I=isleap (I)                                                      [ ****** ]\n");
	}
	if( mode=='6' ){					// Mathematics
		eprin("%s[Manual表題]%s %s\n",r_blu,langfv_title[mode-'0']);
		eprin("%s[System変数]%s\n",r_gre);
		eprin("  SYS_ANGLE={RAD|DEG}  M_PI  M_E {INT|DBL}_{MAX|MIN|QUANT|EPSILON}  INF  NAN\n");
		eprin("%s[System関数]%s\n",r_red);
		eprin("  三角と双曲: D=[a]sin[h](D)  D=[a]cos[h](D)  D=[a]tan[h](D)  D=atan2(Dy,Dx)\n");
		eprin("  角度と座標: D={deg|rad}(D)  (I,I,D)={rad|deg}2dms(D)  D=dms2{rad|deg}(I,I,D)  (X,Y,Z)={x|y|z}rot(X,Y,Z,D)\n");
		eprin("  指数と対数: D={exp|log}{ |e|2|10}(D)  D={pow|mod}(Dx,Dy)  D={l|t}gamma(D)  D={sqrt|qbrt}(D)  D={lin|dbi}(D)\n");
		eprin("  ベッセル  : D={j0|y0}(D)  D={j1|y1}(D)  D={jn|yn}(In,Dx)\n");
		eprin("  統計と乱数: Dd=dnorm(Dx[,Dave,Dsig])  Dp=pnorm(Dx[,Dave,Dsig])  Dx=qnorm(Dp[,Dave,Dsig])\n");
		eprin("              D={max|med|min}(V)  I=arg{max|med|min}(V)  D={sum|ave}(V)  D={s|u}{var|dev}(V)  D=erf[c](D)\n");
		eprin("              I=rand(I)  D=urand()  D=nrand(Ave,Dev)  U=seed(I)\n");
		eprin("  整数と実数: I=int(*)  D=dbl(*)  {I|D}=atov(*)  D=abs(D)  D={ceil|floor|trunc}(D)  D={rint|round}(D)\n");
		eprin("              (Dint,Dfra)=modf(D)  D=Dint+Dfra  (Dman,Iexp)=frexp(D)  D=ldexp(Dman,Iexp)\n");
		eprin("  無限と非数: I=isinf(D)  I=isnan(D)\n");
	}
	if( mode=='7' ){					// Proc & Intr+GC
		eprin("%s[Manual表題]%s %s\n",r_blu,langfv_title[mode-'0']);
		eprin("%s[System変数]%s\n",r_gre);
		eprin("  $$  $?  PID  EXT_SHELL  SIG_{DFL|IGN|ERR}  NSIG\n");
		eprin("  SIG{ABRT|ALRM|CHLD|CONT|FPE|HUP|ILL|INT|KILL|PIPE|QUIT|SEGV|STOP|TERM|TSTP|TTIN|TTOU|USR1|USR2}\n");
		eprin("%s[System関数]%s\n",r_red);
		eprin("  プロセス関数: D=sleep(D)  U=pause()  U=exit(I)  I=system(S)  A=syscmd(s)  S=`S`\n");
		eprin("  割り込み制御: I=tx_sig(Isig,Ipid)    P=rx_sig(Isig,Func)\n");
		eprin("  メモリ管理  : P=alloc(I)  U=free(P)  U=gc_collect()\n");
	}
}
