/*** I_SORTRD.C ***/					#include	"main.h"

ctree 	*_p_fcalctr=NULL;				/* Pointer to Compare Function ( Option )				*/
int		 _p_fcalamp=   0;				/* Sort Direction { +1=Normal / -1=Reverse }			*/

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *do_sort(ctree *ctr,int dir){
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/

ctree	*ans,*fxt,*par;	dtab	*a,*f,*x,*e;	int		cnt,off;
int		pos,idx,n_total=0,mode='?';		/* Index / Array Index / Total Data Count / Data Type	*/
dtab	**p_sort=NULL;					/* Pointer to DTAB Pointer Array[] ( for qsort(3) )		*/

/* Check Sort() in Sort() */
	if( _p_fcalctr!=NULL || _p_fcalamp!=0 ){ flag_exerr=SortInSort; return NULL; }

/* Set Param(s) & Check Type(s) */
	cnt = lcnt(ctr);					/* CNT = ARGC of this Func()							*/
	if( cnt<1 )     { flag_exerr=NgARGCmm; epar[0]=cnt,epar[1]=1,epar[2]=INVA; return NULL; }

	f = ctr2p_dtab( fxt=lptr(ctr,0) ); chk_vtype(f,"SIDAX",0);
	off = (f->type=='X') ? 1:0;			/* OFF = Data Offset Count								*/
	if( cnt-off==0 ){ flag_exerr=NgARGCmm; epar[0]=cnt,epar[1]=1,epar[2]=INVA; return NULL; }

	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

/* Make Sort Func() for X_CALL() */
	if(f->type=='X'){					// FCAL: file/line/colm 情報は、Sort Func() のものとする。
		_p_fcalctr    = mk_ctree(FCAL,fxt->file,fxt->line,fxt->colm,NULL,NULL,NULL);
		_p_fcalctr->l = fxt;															// .L -> FNAM
		_p_fcalctr->r = mk_ctree(',' ,fxt->file,fxt->line,fxt->colm,NULL,NULL,NULL);	// .R -> (ARG1,ARG2)
		_p_fcalctr->r->l = mk_cgap();													// .R.L -> ARG1 = <CGAP>
		_p_fcalctr->r->r = mk_cgap();													// .R.R -> ARG1 = <CGAP>
		_p_fcalamp = ( dir=='N' ? +1:-1 );
	}

/* Do SORT()!! */
//+++ Make List +++//
	for( pos=off ; pos<cnt ; pos++ ){	/* For All Param(s)										*/
		x = ctr2p_dtab( par=lptr(ctr,pos) ); chk_vtype(x,"SIDA",pos);
		if( x->type=='A' ){				/* >Param => 'A' ( Arry & Hash )						*/
			for( idx=0 ; (e=p_elmt(x,idx))!=NULL ; idx++ ){		// For All Elmt(s)
				chk_vtype(e,"SIDA",pos);
				switch( mode ){
					case '?': mode = e->type; break;
					case 'I':
					case 'D': if( e->type!='I'&&e->type!='D' ){ flag_exerr=NgARGCMB; return NULL; } break;
					case 'S': if( e->type!='S'               ){ flag_exerr=NgARGCMB; return NULL; } break;
					case 'A': if( e->type!='A'               ){ flag_exerr=NgARGCMB; return NULL; } break;
				}
				n_total++; p_sort=X_RALL(p_sort,sizeof(dtab*)*n_total);
				p_sort[n_total-1]=e;
			}
		}
		else{							/* >Param => 'S' 'I' 'D'								*/
			switch( mode ){
				case '?': mode = e->type; break;
				case 'I':
				case 'D': if( e->type!='I'&&e->type!='D' ){ flag_exerr=NgARGCMB; return NULL; } break;
				case 'S': if( e->type!='S'               ){ flag_exerr=NgARGCMB; return NULL; } break;
				case 'A': if( e->type!='A'               ){ flag_exerr=NgARGCMB; return NULL; } break;
			}
			n_total++; p_sort=X_RALL(p_sort,sizeof(dtab*)*n_total);
			p_sort[n_total-1]=x;
		}
	}

//+++ Quick Sort +++//
	if( _p_fcalctr==NULL ){				/* Simple  Sort - No Sort Func()						*/
		if( mode!='S' ) qsort( p_sort , n_total , sizeof(dtab*) , dir=='N' ? nval_compare:rval_compare );
		if( mode=='S' ) qsort( p_sort , n_total , sizeof(dtab*) , dir=='N' ? nstr_compare:rstr_compare );
	}
	else{								/* General Sort											*/
		qsort( p_sort , n_total , sizeof(dtab*) , func_compare );
		if(flag_exerr){					// { X_CALL() modify info !! }
			flag_exerr=(flag_exerr==SortInSort?flag_exerr:SortFxExec); last_ct=ctr; epos=0; return NULL;
		}
		_p_fcalctr=NULL;				/* Clear !! */
		_p_fcalamp=   0;				/* Clear !! */
	}

//+++ Set Result +++//
	for( idx=0 ; idx<n_total ; idx++ ){ e=di2p_dtab(a,idx); cpy_dtab(e,p_sort[idx]); }
	return ans;

}

ctree *i_sort (ctree *ctr){ return do_sort(ctr,'N'); }	/*** TT-Lang: A = SORT ([F,]X,...) ***/
ctree *i_rsort(ctree *ctr){ return do_sort(ctr,'R'); }	/*** TT-Lang: A = RSORT([F,]X,...) ***/
// i_argsort() & i_argrsort() code are in math.call/i_m3calc.c

/*------------------+-------------------+-------------------+-------------------+---------------*/
int func_compare(const void *vx,const void *vy){	// Compare Dtab Ival|Dval for QSORT(3)
ctree	*arg1,*arg2,*fret;			/* Pointer to (ARG1,ARG2) & RetnValue						*/
dtab	*px=*(dtab**)vx,*py=*(dtab**)vy,*r;
/* Set ARG1&ARG2 */
	arg1 = _p_fcalctr->r->l; arg1->op=0xFF; arg1->x=(void*)px;	/* px = Direct Pointer */
	arg2 = _p_fcalctr->r->r; arg2->op=0xFF; arg2->x=(void*)py;	/* py = Direct Pointer */
/* Call X_CALL() */
	fret = x_call(_p_fcalctr,FALS); if(flag_exerr) return 0x00;
/* Set RetnValue */
	r = ctr2p_dtab( lptr(fret,0) );		// 1st RETN() Value
	if( r->type!='I' && r->type!='D' ){ flag_exerr=SortFxRetn; return 0x00; }
	return(cint(r)*_p_fcalamp);
}

/*------------------+-------------------+-------------------+-------------------+---------------*/
int nval_compare(const void *vx,const void *vy){	// Compare Dtab Ival|Dval for QSORT(3)
dtab	*px=*(dtab**)vx,*py=*(dtab**)vy;
	if( cdbl(px) < cdbl(py) ){ return(-1); }		/* N */
	if( cdbl(px) > cdbl(py) ){ return(+1); }		/* N */
	return(0);
}

/*------------------+-------------------+-------------------+-------------------+---------------*/
int rval_compare(const void *vx,const void *vy){	// Compare Dtab Ival|Dval for QSORT(3)
dtab	*px=*(dtab**)vx,*py=*(dtab**)vy;
	if( cdbl(px) < cdbl(py) ){ return(+1); }		/* R */
	if( cdbl(px) > cdbl(py) ){ return(-1); }		/* R */
	return(0);
}

/*------------------+-------------------+-------------------+-------------------+---------------*/
int nstr_compare(const void *vx,const void *vy){	// Compare Dtab Str for QSORT(3)
dtab	*px=*(dtab**)vx,*py=*(dtab**)vy;
	return( +strcmp(px->str,py->str) );				/* N */
}

/*------------------+-------------------+-------------------+-------------------+---------------*/
int rstr_compare(const void *vx,const void *vy){	// Compare Dtab Str for QSORT(3)
dtab	*px=*(dtab**)vx,*py=*(dtab**)vy;
	return( -strcmp(px->str,py->str) );				/* R */
}
