/*** I_PRIN.C ***/						#include	"main.h"

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_print(ctree *ctr){				/*** TT-Lang: A = PRINT(X,...) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x;			int		cnt;
FILE	*fp=stdout;		char	*prin_str;

/* Set Param(s) & Check Type(s) */
	cnt = lcnt(ctr);										// ARGC
	x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"S",0);	// FRMT
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

/* Do PRINT()!! */
	prin_str = make_outstr( x->str, ctr, /*Start*/1, /*End*/cnt );
	if( prin_str==NULL ){ return NULL; }
	prin_str = proc_ansicolor(1,prin_str);					// STDOUT

	a->type='I'; a->ival=fprintf(fp,"%s",prin_str); return ans;
}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_eprint(ctree *ctr){			/*** TT-Lang: A = EPRINT(X,...) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x;			int		cnt;
FILE	*fp=stderr;		char	*prin_str;

/* Set Param(s) & Check Type(s) */
	cnt = lcnt(ctr);										// ARGC
	x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"S",0);	// FRMT
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

/* Do EPRINT()!! */
	prin_str = make_outstr( x->str, ctr, /*Start*/1, /*End*/cnt );
	if( prin_str==NULL ){ return NULL; }
	prin_str = proc_ansicolor(2,prin_str);					// STDERR

	a->type='I'; a->ival=fprintf(fp,"%s",prin_str); return ans; 
}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_fprint(ctree *ctr){			/*** TT-Lang: A = FPRINT(F,X,...) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*f,*x;		int		cnt;
FILE	*fp=NULL;		char	*prin_str;

/* Set Param(s) & Check Type(s) */
	cnt = lcnt(ctr);										// ARGC
	f = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(f,"SP",0);	// FILE

	fp = ret_fp(par,"w+");

	x = ctr2p_dtab( par=lptr(ctr,1) ); chk_vtype(x,"S" ,1);	// FRMT
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

/* Do FPRINT()!! */
	prin_str = make_outstr( x->str, ctr, /*Start*/2, /*End*/cnt );
	if( prin_str==NULL ){ return NULL; }
	prin_str = proc_ansicolor(fileno(fp),prin_str);			// FILENO

	a->type='I'; a->ival=fprintf(fp,"%s",prin_str); return ans; 
}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_sprint(ctree *ctr){			/*** TT-Lang: A = SPRINT(X,...) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x;			int		cnt;
/* FILE	*fp=NULL; */	char	*prin_str;

/* Set Param(s) & Check Type(s) */
	cnt = lcnt(ctr);										// ARGC
	x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"S",0);	// FRMT
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

/* Do SPRINT()!! */
	prin_str = make_outstr( x->str, ctr, /*Start*/1, /*End*/cnt );
	if( prin_str==NULL ){ return NULL; }

	a->type='S'; a->str=prin_str;                   return ans; 
}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_dying(ctree *ctr){				/*** TT-Lang: A = DYING(X,...) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans;

/* Do DYING()!! */
	ans=i_eprint(ctr); if(!flag_exerr){ exit(1); }else{ return ans; }
}

/************************************************************************************************/
// MAKE_OUTSTR() make & retun XPRINTF(3) output string or NULL.  ( Set flag_exerr & LAST_* )
// { Format = FMT / Params = CTR(S_POS) - CTR(E_POS) }
/************************************************************************************************/
char *make_outstr(char *fmt,ctree *ctr,int s_pos,int e_pos){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
ctree	*par;			dtab	*x;
char	fmtbuf[BUFSIZ],tmpbuf[BUFSIZ];	/* Buffer for Format String ( for Single '%' )			*/
char	outbuf[BUFSIZ];					/* Buffer for Output String ( for Single '%' )			*/
char	*p_ans=NULL,*p_tmp=NULL;		/* Pointer to XPRINTF(3) Output String					*/
int		idx,node,r_type,o_type,e_type;	/* '%' Index / CTR Index / {Return|Orig|Expect} Type	*/

/* FMT = BOL - .'%'|EOL ( IDX=0 ) */
	r_type = set_prnfmt(fmtbuf,fmt, 0 );		// FMTBUF <- FMT
	o_type = (r_type>>8)&0xFF; e_type = r_type&0xFF;
	sprintf(outbuf,fmtbuf); p_ans = X_SDUP(outbuf);

/* FMT = '%' - .'%'|EOL ( IDX>0 ) */
	for( idx=1,node=s_pos ; node<e_pos ; idx++,node++ ){

	/* >Set IDX'th Format String */
		r_type = set_prnfmt(fmtbuf,fmt,idx);	// FMTBUF <- FMT
		o_type = (r_type>>8)&0xFF; e_type = r_type&0xFF;
		if( e_type=='-' ){						// FMT '%' Count << Params Count
			flag_exerr=PRiNARGC; epar[0]=node; epar[1]='-';
			return(NULL);
		}

	/* >Set NODE'th DTAB Param */
		x = ctr2p_dtab( par=lptr(ctr,node) ); chk_vtype(x,"*",node);

	/* >Call SPRINTF(3) */
		switch( e_type ){ int i;		/* E_TYPE = Expected Type ( FMT '%' Type )				*/
		case 'S':
			switch( x->type ){			/* >Passed Type			*/
				case 'S':
				case 'P': p_tmp=X_ATOM(strlen2(cstr(x))+BUFSIZ); sprintf(p_tmp,fmtbuf,cstr(x)); break;
				default:
					flag_exerr=PRiNTYPE; epar[0]=node,epar[1]=o_type,epar[2]=x->type; epos=node; return NULL;
			} break;
		case 'I':
			switch( x->type ){			/* >Passed Type			*/
				case 'I': case 'P':
				case 'D':			sprintf(outbuf,fmtbuf,cint(x)); break;
				default:
					flag_exerr=PRiNTYPE; epar[0]=node,epar[1]=o_type,epar[2]=x->type; epos=node; return NULL;
			} break;
		case 'D':
			switch( x->type ){			/* >Passed Type			*/
				case 'I': case 'P':
				case 'D':			sprintf(outbuf,fmtbuf,cdbl(x)); break;
				default:
					flag_exerr=PRiNTYPE; epar[0]=node,epar[1]=o_type,epar[2]=x->type; epos=node; return NULL;
			} break;
		case 'V':
			switch( x->type ){			/* >Passed Type			*/
// 整数型の場合は、整数型 %d で print する。
				case 'I': case 'P':		// Replace "%*[vV]" into "%*d"      !! ( Replace 1st [vV] !! )
					for( i=0 ; fmtbuf[i]!='v' && fmtbuf[i]!='V' ; i++ ){ tmpbuf[i]=fmtbuf[i]; } tmpbuf[i]='\0';
					strcat2(tmpbuf,PRIdTINT    );							/* Replace!! */
					strcat2(tmpbuf,&fmtbuf[i+1]);							/*           */
					sprintf(outbuf,tmpbuf,cint(x)); break;
				case 'D':				// Replace "%*[vV]" into "%*[eEfF]" !! ( Replace 1st [vV] !! )
// 実数型の場合は、実数型 %[eE] 又は %[fF] で print する。
// 絶対値が、大き過ぎる値＆（0ではない）小さすぎる値は、%[eE] とし、それ以外の値は、%[fF] とする。
					for( i=0 ; fmtbuf[i]!='v' && fmtbuf[i]!='V' ; i++ ){ tmpbuf[i]=fmtbuf[i]; } tmpbuf[i]='\0';
					strcat2(tmpbuf,PFX_TDBL    );							/* Insert!!  */
					if( (0.0<fabs(cdbl(x)) && fabs(cdbl(x))<1.0E-6) || +1.0E+6<=fabs(cdbl(x)) )
						strcat2( tmpbuf , fmtbuf[i]=='v' ? "e" : "E" );		/* Replace!! */
					else
						strcat2( tmpbuf , fmtbuf[i]=='v' ? "f" : "F" );		/* Replace!! */
					strcat2( tmpbuf , &fmtbuf[i+1] );
					sprintf(outbuf,tmpbuf,cdbl(x)); break;
				default:
					flag_exerr=PRiNTYPE; epar[0]=node,epar[1]=o_type,epar[2]=x->type; epos=node; return NULL;
			} break;
		case 'P':
			switch( x->type ){			/* >Passed Type			*/
				case 'S':
				case 'P': sprintf(outbuf,fmtbuf,cptr(x)); break;
				default:
					flag_exerr=PRiNTYPE; epar[0]=node,epar[1]=o_type,epar[2]=x->type; epos=node; return NULL;
			} break;
		case 'B':
			switch( x->type ){			/* >Passed Type			*/
				case 'I':
				case 'D': sprintf(outbuf,"%s",ival2binstr(fmtbuf,cint(x))); break;
				default:
					flag_exerr=PRiNTYPE; epar[0]=node,epar[1]=o_type,epar[2]=x->type; epos=node; return NULL;
			} break;
		default:
			assert(FALS);
		}

	/* >Allocate & Copy */
		if( e_type=='S' )
			p_ans = X_SCAT(p_ans,p_tmp );
		else
			p_ans = X_SCAT(p_ans,outbuf);

	}

/* Check Extra Format */
	set_prnfmt(fmtbuf,fmt,e_pos);
	if( fmtbuf[0]!='\0' ){						// FMT % Count >> Params Count
		flag_exerr=PRiNARGC; epar[0]=node; epar[1]='+';
		return(NULL);
	}

/* Return Result */
	return p_ans;
}
