/*** X_AWKS.C ***/						#include	"main.h"

static int set_dolawk(dtab *p_awk,char *p_str);

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *x_awks(ctree *ptr){				/*** TT-Lang: AWK{R=STMT} | AWK(L=PARA){R=STMT} ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*para,*stmt;					dtab	*file,*p_awk,*p_elmt,*p_nr,*p_nf;
char	buf[BUFSIZ],*p_str;				int		cnt,idx=0;

FILE	*fp = stdin;

/* Do X_AWKS()!! */						chk_point(ptr);

/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
// Set & Init Param ( *file,*fp )
	switch( cnt=lcnt(ptr->l) ){			/* CNT = ARGC of this Func()							*/
		case 1:	file = ctr2p_dtab( para=lptr(ptr->l,idx) ); chk_vtype(file,"SP",idx++);
				if( (fp=ret_fp(para,"r+")) == NULL ){ flag_exerr=FileOpen; return NULL; }
		case 0:							// AWK{...} | AWK(){...}
				break;
		/* 複数は有り得ない by BISON */
	}

// Set & Init Param ( $[],NR,NF )
	p_awk = PTR2DOL(); null_dtab(p_awk);
	p_nr  = PTR2NR (); null_dtab(p_nr ); p_nr->type = 'I'; p_nr->ival = 0;
	p_nf  = PTR2NF (); null_dtab(p_nf ); p_nf->type = 'I'; p_nf->ival = 0;
	for( idx=0 ; idx<MAX_SAIDX ; idx++ ){
		p_elmt = di2p_dtab(p_awk,idx);			/*** $0,$1,$2, ... ***/
		null_dtab(p_elmt);						// NULL
	}

/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
//  Main Loop
	while(TRUE){ strace(ptr);

	/*** PARA ***/
	// P_STR = GETS(FILE)
		p_str = NULL;
		while( fgets(buf,BUFSIZ,fp)!=NULL ){
			p_str = X_SCAT(p_str,buf);
			if( buf[strlen2(buf)-1]=='\n' ) break;
		}
		if( p_str==NULL ){ break; }		// EOF -> FIN AWK()

	// NR
		(p_nr->ival) += 1;

	// NF & $0,$1,$2, ... ,$NF
		(p_nf->ival) = set_dolawk(p_awk,p_str);

	/*** STMT ***/
		if( flag_retning||flag_next||flag_last ){ goto L_LAST; }
		stmt = exe_tlvlstmt(ptr->r); if(flag_exerr) return NULL;
	/*--------------------------------------------------*/
		if( flag_next>0 ){ flag_next--; goto L_NEXT; }
		if( flag_last>0 ){ flag_last--; goto L_LAST; }
	/*--------------------------------------------------*/

L_NEXT:	if( flag_retning||flag_next||flag_last ){ goto L_LAST; }

	}

L_LAST:	return NULL;
}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
// 文字列をSCANしてAWK配列（$0,$1,$2, ... ,$NF）にセットする。単語区切りはisspace()で判定する。
// 戻り値 = NF
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
static int set_dolawk(dtab *p_awk,char *p_str){

dtab	*p_elmt;
char	*ps,*pe;
int		idx,ctmp,nf;

/* $0 の設定 */
	p_elmt = di2p_dtab(p_awk,0);		/*** $0 ($[0]) ***/
	p_elmt->type = 'S';
	p_elmt->str  = p_str;				// 利用可能

/* $1,$2,$3, ... $NF の設定 */
// 文字列を構成する全文字について...
	ps = p_str;									// ps -> 先  頭
	for( idx=nf= 0 ; TRUE ; idx++,nf++ ){		// nf -> 単語数

	// 先頭の空白をスキップ
		while(  isspace(*ps) && (*ps)!='\0' )	// *ps = 単語の先頭、又は、行末'\0'
			ps++;
	// 単語をスキップ
		pe = ps;
		while( !isspace(*pe) && (*pe)!='\0' )	// *pe = 空白の先頭、又は、行末'\0'
			pe++;
	// 単語の設定
		if( ps != pe ){							// 単語が有る
			ctmp = *pe; *pe = '\0';				// 一時的に区切って...
			p_elmt = di2p_dtab(p_awk,idx+1);	/*** $1,$2,$3, ... ***/
			p_elmt->type = 'S';
			p_elmt->str  = X_SDUP(ps);
			*pe = (char)ctmp;					// 元に戻す
		}
		else									// 単語が無い
			break;
	// 次の単語に進む
		ps = pe;

	}

/* NF+1 〜 MAX_SAIDX-1 の消去（NULL化） */
	for(       ; idx<MAX_SAIDX ; idx++ ){
		p_elmt = di2p_dtab(p_awk,idx+1);		/*** $[NF+1],$[NF+2],$[NF+3], ... ***/
		if( isnull(p_elmt) )
			break;
		else
			null_dtab(p_elmt);
	}

/* NF を戻す */
	return(nf);

}
