/*** X_XCMD.C ***/						#include    "main.h"

// 1) EXT_SHELL を、（PIPE接続し）外部コマンドとして起動する。（１度目のみ！２度目からは再利用！）
// 2) 指定された文字列を、外部コマンドの標準入力に（PIPE経由で）出力する。

#define	R	(0)
#define	W	(1)

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
// 関数：SIGPIPE 用シグナルハンドラ（シグナルを受信した記録を flag_exerr にセットする）
// ＞入力＝シグナル番号
// ＞出力＝なし
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
extern void pipe_handler(int sig){ flag_exerr = TRUE; }

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
// 関数：外部コマンド cmd を子プロセスとして実行する。なお、子プロセスの STDIN & STDOUT & STDERR
// を親プロセスと PIPE 経由で相互に接続する。（注意：対応する引数がNULLで無い場合）
// ＞入力＝外部コマンド名 cmd 、親側の fd_w & fd_r & fd_e へのポインタ
// ＞出力＝結果（成功=子PID／失敗=INVA）、親側の fd_w & fd_r & fd_e （ファイルディスクリプタ）
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
extern int popen3( char *cmd[], int *fd_w, int *fd_r, int *fd_e ){

int		p2c[2],c2p[2],err[2];			// PIPE ( P = Parent / C = Child )
int		pid;							// PID of Child

// Note: パイプ単体は単方向（ pipe[0] が読み込み用 pipe[1] が書き込み用のファイルディスクリプタ）
// 子にとっての読み込み用は、親にとっての書き込み用。逆も同様。

/* Create 3 Pipe(s) */
	if( pipe(p2c)<0 || pipe(c2p)<0 || pipe(err)<0 ){	// pipe() 実行エラー -> Unlikely
		flag_exerr = PipeFork;
		return(INVA);
	}
/* Invoke Child Processs */
	if( (pid=fork())<0 ){								// fork() 実行エラー -> Unlikely
		flag_exerr = PipeFork;
		return(INVA);
	}

/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
/*** Child ***/
	if( pid==0 ){
		close(p2c[W]); close(c2p[R]); close(err[R]);	// 不要 fd のクローズ
		if( fd_w!=NULL ) dup2(p2c[R],0);				// 子側 STDIN (0) の設定
		if( fd_r!=NULL ) dup2(c2p[W],1);				// 子側 STDOUT(1) の設定
		if( fd_e!=NULL ) dup2(err[W],2);				// 子側 STDERR(2) の設定
		close(p2c[R]); close(c2p[W]); close(err[W]);	// 不要 fd のクローズ
		if( execvp( cmd[0], cmd )<0 ){					// exec() 実行エラー【コマンド名ミス】
			fprintf(stderr,"Warning[%s]: Cannot Execvp() EXT_SHELL [%s]\n",TTdeAM_CMD,cmd[0]);
			fprintf(stderr,"> Check & Assign EXT_SHELL again!!\n");
			exit(1);
		}
		/* NEVER REACH HERE */
	}

/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
/*** Parent ***/
	close(p2c[R]); close(c2p[W]); close(err[W]);		// 不要 fd のクローズ
	if( fd_w!=NULL ) *fd_w=p2c[W];						// 親側 fd_w のセット -> 子側 STDIN (0)
	if( fd_r!=NULL ) *fd_r=c2p[R];						// 親側 fd_r のセット <- 子側 STDOUT(1)
	if( fd_e!=NULL ) *fd_e=err[R];						// 親側 fd_w のセット -> 子側 STDERR(2)
	return(pid);										// 子のPID

}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *x_xcmd(ctree *ptr){				/*** TT-Lang: ! X ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans;			dtab	*a,*x,*p_shell;
int		fd_w; 	FILE	*fp_w;			// 親側：書き込み用 -> 子側 STDIN (0) に接続
//int	fd_r; 	FILE	*fp_r;			// 親側：読み出し用 <- 子側 STDOUT(1) に接続
//int	fd_e; 	FILE	*fp_e;			// 親側：読み出し用 <- 子側 STDERR(2) に接続
int		pid;							// PID of Child
char	*argv4exec[MAX_ARGC+1];			// EXECV(3) 用の引数配列

/* Debug & PreCheck */
	chk_point(ptr);

/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( eva_expr(ptr->l,1) ); chk_error(ptr); chk_vtype(x,"S",0);
	a = ctr2p_dtab( ans=ext_ctrdtab(ptr) );

/* Set PIPE ( FORK & EXEC ) */
	p_shell = EXT_SHELL();				// 外部実行コマンド名
	fp_w    = p_shell->ptr;				// PIPE が設定済みであれば、PTR  に保存 or NULL
//	fp_r    = NULL;						// 未実装
//	fp_e    = NULL;						// 未実装
	if( fp_w==NULL ){					// 初回アクセス時 -> 子プロセスを起動し PIPE を設定する!!

		argv4exec[0] = p_shell->str;
		argv4exec[1] = NULL;
		pid = popen3( argv4exec, &fd_w, NULL, NULL );

		if( pid==INVA || flag_exerr ){ /*** flag_exerr is set by popen3() ***/ return NULL; }
		p_shell->ptr = fp_w = fdopen(fd_w,"w");
		signal(SIGPIPE,pipe_handler);	// SIGPIPE 用シグナルハンドラのセット
//		fcntl(fd_r,F_SETFL,O_NONBLOCK);	// fd_r 側をノンブロック化する
	}

/* Do XCMD()!! */
/*** Write (1/3) ***/
	fprintf(fp_w,"%s",cstr(x));			// PIPE へ書き込み  （SIGPIPE 発生の可能性有り）
	fflush (fp_w);						// PIPE のフラッシュ（SIGPIPE 発生の可能性有り）
	if( flag_exerr ){					/*** flag_exerr is set by pipe_handler() ***/
		fprintf(stderr,"Warning[%s]: Broken Pipe [SIGPIPE]\n",TTdeAM_CMD);
		fprintf(stderr,"> Assign EXT_SHELL again!! ( This will restart EXT_SHELL and reestablish pipe!! )\n");
		flag_exerr = FALS;				/*** Clear flag_exerr                    ***/
		void_dtab(a); return ans;
	}
/*** Read (2/3) ***/
	;
/*** Void (3/3) ***/
	void_dtab(a); return ans;
}
