/*** I_M3CALC.C ***/					#include	"main.h"

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
static ctree *do_m3(ctree *ctr,int mode,int flag_argfunc){
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x,*e;		int		cnt,i_arg=0,i_left,i_righ;
int		idx,sub,n_total=0;				/* Index / Sub Index / Total Data Count					*/
dtab	**p_sort=NULL;					/* Pointer to DTAB Pointer Array[] ( for qsort(3) )		*/

/* Set Param(s) & Check Type(s) */
	cnt = lcnt(ctr);					/* CNT = ARGC of this Func()							*/
	if( cnt==0 ){ flag_exerr=NgARGCmm; epar[0]=cnt,epar[1]=1,epar[2]=INVA; return NULL; }
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

/* Do M3()!! */

//+++ Seek Dtab || Make List +++//
	for( idx=0 ; idx<cnt ; idx++ ){		/* For All Param(s)										*/
		x = ctr2p_dtab( par=lptr(ctr,idx) ); chk_vtype(x,"IDA",idx);
		if( x->type=='A' ){				/* >Param => 'A' ( Arry & Hash )						*/
			for( sub=0 ; (e=p_elmt(x,sub))!=NULL ; sub++ ){		// For All Elmt(s)
				chk_vtype(e,"ID",idx);
				if( mode=='+' ){ if( n_total==0 || cdbl(a)<cdbl(e) ){ i_arg=n_total; cpy_dtab(a,e); } n_total++; }
				if( mode=='-' ){ if( n_total==0 || cdbl(a)>cdbl(e) ){ i_arg=n_total; cpy_dtab(a,e); } n_total++; }
			/* Make Pointer Array */
				if( mode=='0'||mode=='S'||mode=='R' ){ n_total++; p_sort=X_RALL(p_sort,sizeof(dtab*)*n_total); p_sort[n_total-1]=e; }
			}
		}
		else{							/* >Param => 'I' & 'D'									*/
				if( mode=='+' ){ if( n_total==0 || cdbl(a)<cdbl(x) ){ i_arg=n_total; cpy_dtab(a,x); } n_total++; }
				if( mode=='-' ){ if( n_total==0 || cdbl(a)>cdbl(x) ){ i_arg=n_total; cpy_dtab(a,x); } n_total++; }
			/* Make Pointer Array */
				if( mode=='0'||mode=='S'||mode=='R' ){ n_total++; p_sort=X_RALL(p_sort,sizeof(dtab*)*n_total); p_sort[n_total-1]=x; }
		}
	}

//+++ Quick Sort +++//
// トータルインデックス値（ソート対象データの通し番号）を、元DTABの ptr フィールドに一時保存する。
// ソート対象データは、整数型＆実数型に限られるので問題は発生しない。（使用後は、クリアーする。）
	if( mode=='0'||mode=='S'||mode=='R' ){
		for( tint t=0 ; t<n_total ; t++ ){ p_sort[t]->ptr=(void*)t; }	/*** Temp SetUp!! ***/
		if( mode=='0'||mode=='S' )
			qsort( p_sort , n_total , sizeof(dtab*) , nval_compare );
		else
			qsort( p_sort , n_total , sizeof(dtab*) , rval_compare );
	}

/* ( Medidan {Value|Index} ) */
	if( mode=='0' ){				// (Left,Righ) = ARGMED()
		if( n_total%2==1 ){				/* Odd : Index = (N_TOTAL/2)							*/
			cpy_dtab(a,p_sort[n_total/2]);					/* Value */
			i_left = (tint)p_sort[n_total/2  ]->ptr;		/* Index */
			i_righ = (tint)p_sort[n_total/2  ]->ptr;		/* Index */
		}
		else{							/* Even: Index = (N_TOTAL/2) & (N_TOTAL/2-1)			*/
			a->type = 'D';									/* Value */
			a->dval = ( cdbl(p_sort[n_total/2]) + cdbl(p_sort[n_total/2-1]) ) / 2.0;
			i_left = (tint)p_sort[n_total/2  ]->ptr;		/* Index */
			i_righ = (tint)p_sort[n_total/2-1]->ptr;		/* Index */
		}
	}

/* Set Answer & Return */
	if( !flag_argfunc )					// MAX() | MIN() | MED()
		return ans;
	if( mode=='+'||mode=='-' ){			// ARGMAX() | ARGMIN()
		udef_dtab(a); a->type='I'; a->ival=i_arg;
	}
	else{								// ARGMED() | ARGSORT() | ARGRSORT()
		if( mode=='0' ){
			ans = ext_ctrdtabmult(ctr,2);
			a = ctr2p_dtab(lptr(ans,0)); a->type='I'; a->ival=i_left;
			a = ctr2p_dtab(lptr(ans,1)); a->type='I'; a->ival=i_righ;
		}
		if( mode=='S'||mode=='R' ){
			for( idx=0 ; idx<n_total ; idx++ ){
				e=di2p_dtab(a,idx); e->type='I'; e->ival=(tint)(p_sort[idx]->ptr);
			}
		}
		for( tint t=0 ; t<n_total ; t++ ){ p_sort[t]->ptr=NULL    ; }	/*** Temp Clear!! ***/
	}
	return ans;
}

ctree *i_max     (ctree *ctr){ /*** TT-Lang: A = MAX     (X,...) ***/ return do_m3(ctr,'+',FALS); }
ctree *i_min     (ctree *ctr){ /*** TT-Lang: A = MIN     (X,...) ***/ return do_m3(ctr,'-',FALS); }
ctree *i_med     (ctree *ctr){ /*** TT-Lang: A = MED     (X,...) ***/ return do_m3(ctr,'0',FALS); }
ctree *i_argmax  (ctree *ctr){ /*** TT-Lang: A = ARGMAX  (X,...) ***/ return do_m3(ctr,'+',TRUE); }
ctree *i_argmin  (ctree *ctr){ /*** TT-Lang: A = ARGMIN  (X,...) ***/ return do_m3(ctr,'-',TRUE); }
ctree *i_argmed  (ctree *ctr){ /*** TT-Lang: A = ARGMED  (X,...) ***/ return do_m3(ctr,'0',TRUE); }
ctree *i_argsort (ctree *ctr){ /*** TT-Lang: A = ARGSORT (X,...) ***/ return do_m3(ctr,'S',TRUE); }
ctree *i_argrsort(ctree *ctr){ /*** TT-Lang: A = ARGRSORT(X,...) ***/ return do_m3(ctr,'R',TRUE); }

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_sum(ctree *ctr){				/*** TT-Lang: A = SUM(X,...) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans;			dtab	*a;				tint	n_total=0;
tdbl	sum=0.0;

/* Set Param(s) & Check Type(s) */
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

/* Do SUM()!! */
	n_total=(tint)do_lqsum(ctr,'L',&sum);
	a->type='D'; a->dval = n_total==0?0.0:sum        ; return ans;
}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_ave(ctree *ctr){				/*** TT-Lang: A = AVE(X,...) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans;			dtab	*a;				tint	n_total=0;
tdbl	sum=0.0;

/* Set Param(s) & Check Type(s) */
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

/* Do AVE()!! */
	n_total=(tint)do_lqsum(ctr,'L',&sum);
	a->type='D'; a->dval = n_total==0?0.0:sum/n_total; return ans;
}
