/*** I_STATRD.C ***/					#include	"main.h"

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_svar(ctree *ctr){				/*** TT-Lang: A = SVAR(X,...) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans;			dtab	*a;				tint	n_total=0;
tdbl	sum=0.0,sqr=0.0;

/* Set Param(s) & Check Type(s) */
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

/* Do SVAR()!! */
	n_total=(tint)do_lqsum(ctr,'L',&sum); if( n_total==0 ) return NULL;
	n_total=(tint)do_lqsum(ctr,'Q',&sqr); if( n_total==0 ) return NULL;
	a->type='D'; a->dval=    ( (sqr/n_total-pow(sum/n_total,2.0))                     ); return ans;
}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_uvar(ctree *ctr){				/*** TT-Lang: A = UVAR(X,...) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans;			dtab	*a;				tint	n_total=0;
tdbl	sum=0.0,sqr=0.0;

/* Set Param(s) & Check Type(s) */
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

/* Do UVAR()!! */
	n_total=(tint)do_lqsum(ctr,'L',&sum); if( n_total==0 ) return NULL;
	n_total=(tint)do_lqsum(ctr,'Q',&sqr); if( n_total==0 ) return NULL;
	a->type='D'; a->dval=    ( (sqr/n_total-pow(sum/n_total,2.0))*n_total/(n_total-1) ); return ans;
}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_sdev(ctree *ctr){				/*** TT-Lang: A = SDEV(X,...) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans;			dtab	*a;				tint	n_total=0;
tdbl	sum=0.0,sqr=0.0;

/* Set Param(s) & Check Type(s) */
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

/* Do SDEV()!! */
	n_total=(tint)do_lqsum(ctr,'L',&sum); if( n_total==0 ) return NULL;
	n_total=(tint)do_lqsum(ctr,'Q',&sqr); if( n_total==0 ) return NULL;
	a->type='D'; a->dval=sqrt( (sqr/n_total-pow(sum/n_total,2.0))                     ); return ans;
}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_udev(ctree *ctr){				/*** TT-Lang: A = UDEV(X,...) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans;			dtab	*a;				tint	n_total=0;
tdbl	sum=0.0,sqr=0.0;

/* Set Param(s) & Check Type(s) */
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

/* Do UDEV()!! */
	n_total=(tint)do_lqsum(ctr,'L',&sum); if( n_total==0 ) return NULL;
	n_total=(tint)do_lqsum(ctr,'Q',&sqr); if( n_total==0 ) return NULL;
	a->type='D'; a->dval=sqrt( (sqr/n_total-pow(sum/n_total,2.0))*n_total/(n_total-1) ); return ans;
}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_dnorm(ctree *ctr){				/*** TT-Lang: A = DNORM(X[,Y,Z]) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x,*y,*z;	int		cnt;
tdbl	ave,dev;

/* Set Param(s) & Check Type(s) */
	cnt = lcnt(ctr);					/* CNT = ARGC of this Func()							*/
	if( cnt!=1 && cnt!=3 ){ flag_exerr=NgARGCnn; epar[0]=cnt,epar[1]=0,epar[2]=2,epar[3]=INVA; return NULL; }

	x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"ID",0);
	switch( cnt ){
		case 1: ave=0.0; dev=1.0; break;		// Standard Normal Distribution //
		case 3:									// General  Normal Distribution //
			y = ctr2p_dtab( par=lptr(ctr,1) ); chk_vtype(y,"ID",1);
			z = ctr2p_dtab( par=lptr(ctr,2) ); chk_vtype(z,"ID",2);
			ave = cdbl(y); dev = cdbl(z); break;
	}
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

/* Do DNORM()!! */						// Ans = PDF of Normal Dist { Y=Ave / Z=StdDev }
	a->type='D'; a->dval=1.0/sqrt(2.0*M_PIx)/dev*exp(-pow(cdbl(x)-ave,2.0)/2.0/dev/dev); return ans;
}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_pnorm(ctree *ctr){				/*** TT-Lang: A = PNORM(X[,Y,Z]) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x,*y,*z;	int		cnt;
tdbl	ave,dev;

/* Set Param(s) & Check Type(s) */
	cnt = lcnt(ctr);					/* CNT = ARGC of this Func()							*/
	if( cnt!=1 && cnt!=3 ){ flag_exerr=NgARGCnn; epar[0]=cnt,epar[1]=0,epar[2]=2,epar[3]=INVA; return NULL; }

	x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"ID",0);
	switch( cnt ){
		case 1: ave=0.0; dev=1.0; break;		// Standard Normal Distribution //
		case 3:									// General  Normal Distribution //
			y = ctr2p_dtab( par=lptr(ctr,1) ); chk_vtype(y,"ID",1);
			z = ctr2p_dtab( par=lptr(ctr,2) ); chk_vtype(z,"ID",2);
			ave = cdbl(y); dev = cdbl(z); break;
	}
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

/* Do PNORM()!! */						// Ans = CDF of Normal Dist { Y=Ave / Z=StdDev }
	a->type='D'; a->dval=0.5*erf((cdbl(x)-ave)/dev/sqrt(2.0))+0.5; return ans;
}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_qnorm(ctree *ctr){				/*** TT-Lang: A = QNORM(X[,Y,Z]) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x,*y,*z;	int		cnt;
tdbl	ave,dev;
tdbl	b0,b1,b2,b3,b4,b5,b6,b7,b8,b9,b10,c,d,e;

/* Set Param(s) & Check Type(s) */
	cnt = lcnt(ctr);					/* CNT = ARGC of this Func()							*/
	if( cnt!=1 && cnt!=3 ){ flag_exerr=NgARGCnn; epar[0]=cnt,epar[1]=0,epar[2]=2,epar[3]=INVA; return NULL; }

	x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"ID",0);
	switch( cnt ){
		case 1: ave=0.0; dev=1.0; break;		// Standard Normal Distribution //
		case 3:									// General  Normal Distribution //
			y = ctr2p_dtab( par=lptr(ctr,1) ); chk_vtype(y,"ID",1);
			z = ctr2p_dtab( par=lptr(ctr,2) ); chk_vtype(z,"ID",2);
			ave = cdbl(y); dev = cdbl(z); break;
	}
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
/* Do QNORM()!! - 戸田(1967) */			// Ans = INVCDF of Normal Dist { Y=Ave / Z=StdDev }
	if( cdbl(x)<0.0 || 1.0<cdbl(x) ){ a->type='D'; a->dval=nan("");       return ans; }
	if( cdbl(x)==0.5               ){ a->type='D'; a->dval=(ave+dev*0.0); return ans; }

	b0  =  1.570796288;
	b1  =  3.706987906E-2;
	b2  = -8.364353589E-4;
	b3  = -2.250947176E-4;
	b4  =  6.841218299E-6;
	b5  =  5.824238515E-6;
	b6  = -1.045274970E-6;
	b7  =  8.360937017E-8;
	b8  = -3.231081277E-9;
	b9  =  3.657763036E-11;
	b10 =  6.936233982E-13;

	c = -log( 4.0 * cdbl(x) * (1.0-cdbl(x)) );
	d = c * (b0 + c * (b1 + c * (b2 + c * (b3 + c * (b4 + c * (b5 + c * (b6 + c * (b7 + c * (b8 + c * (b9 + c * b10))))))))));
	e = ( 0.5 < cdbl(x) ) ? +sqrt(d):-sqrt(d);

	a->type='D'; a->dval=(ave+dev*e); return ans;
}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_erf (ctree *ctr){				/*** TT-Lang: A = ERF (X) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x;

/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"ID",0);
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

/* Do ERF ()!! */
	a->type='D'; a->dval=erf (cdbl(x)); return ans; 
}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_erfc(ctree *ctr){				/*** TT-Lang: A = ERFC(X) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x;

/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"ID",0);
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

/* Do ERFC()!! */
	a->type='D'; a->dval=erfc(cdbl(x)); return ans; 
}

/************************************************************************************************/
// DO_LQSUM calculates 'L'=LinearSum | 'Q'=SquareSum for CSL, and saves the result into P_RSLT.
// It also updates flag_ecexerr & last params then returns N_TOTAL or NULL on error.
/************************************************************************************************/
void *do_lqsum(ctree *ctr,char mode,tdbl *p_rslt){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/

ctree	*par;			dtab	*x,*e;			int		cnt;
int		idx,sub;		tint	n_total=0;
tdbl	sum=0.0;

/* Set Param(s) & Check Type(s) */
	cnt = lcnt(ctr);					/* CNT = ARGC of this Func()							*/
	if( cnt==0 ){ flag_exerr=NgARGCmm; epar[0]=cnt,epar[1]=1,epar[2]=INVA; return NULL; }

/* Do SUM()|AVE()|VAR()|DEV()!! */
	for( idx=0 ; idx<cnt ; idx++ ){		/* For All Param(s)										*/
		x = ctr2p_dtab( par=lptr(ctr,idx) ); chk_vtype(x,"IDA",idx);
		if( x->type=='A' ){				/* >Param => 'A' ( Arry & Hash )						*/
			for( sub=0 ; (e=p_elmt(x,sub))!=NULL ; sub++ ){		// For All Elmt(s)
				chk_vtype(e,"ID",idx);
				n_total++;
				sum += (mode=='L'?cdbl(e):cdbl(e)*cdbl(e));
			}
		}
		else{							/* >Param => 'I' & 'D'									*/
			n_total++;
			sum += (mode=='L'?cdbl(x):cdbl(x)*cdbl(x));
		}
	}

/* Save & Return */
	*p_rslt=sum;
	return (void *)n_total;
}
