/*** I_HOSTSERV.C ***/					#include	"main.h"

/************************************************************************************************/
// CONV_IPHN2TINT() convert {IP-Address|Host-Name}[S] into IP-Address[I].  ERROR = INVA
// {"127.0.0.1"|"localhost"} -> 0x7F000001
/************************************************************************************************/
tint conv_iphn2tint(char *p2str){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
struct hostent *p_hostent;				// Pointer to STRUCT HOSTENT for GETHOSTBYNAME(3)
struct in_addr **addr;					// IP-Address for STRUCT HOSTENT
tint	t_ip = INVA;					// IP-Address

char	buf[BUFSIZ],*s,*d;
int		flag_ns2s = FALS;				// Flag for None Space -> Space Transition
int		c_type    = '*';				// ( Current ) Char Type [ '*'=INIT/'S'=Space/'N'=NonSp ]

/* Check IP-Address [ "127 3" -> NG ] <- Check Only !! */
	for( s=p2str ; *s!='\0' ; s++ ){
		/***** SPACE *****/
		if( isspace(*s) ){
			if( c_type=='N' )			// 127  -> [sp]
				flag_ns2s = TRUE;
			else						// 先頭 -> [sp]  ||  [sp] -> [sp]
				;
			c_type = 'S';				// ' ' = Space
			continue;
		}
		/***** NONSP *****/
		if( *s=='.' ){
			flag_ns2s = FALS;			// Reset !!
			c_type    = '*';			// Reset !!
		}
		else{
			if( flag_ns2s==TRUE )		//                                  127  -> [sp] -> 333
				return INVA;
			else						// 先頭 -> 333  ||  333 -> 333  ||  先頭 -> [sp] -> 333
				;
			c_type='N';					// 'N' = None Space
		}
	}

/* Pack & Copy IP-Address [ " 127 . 0 . 0 . 1 " -> "127.0.0.1" ] */
	s = p2str;
	d = &buf[0];
	while( *s != '\0' ){						// Convert " 127 ." -> "127."
		if( isspace(*s) ){ s++; continue; }		// Skip Space
		*d = *s; s++; d++;						// Copy NonSp
	}
	*d = '\0';

/* Convert {IP-Address|HostName}[S] into IP-Address[I] */
	p_hostent = gethostbyname(buf);
	if( p_hostent==NULL || p_hostent->h_addrtype!=AF_INET )
		return INVA;

// (1) 127.0.0.1 以外で最初に見つかったIPアドレスを戻します。
// (2) ただし、127.0.0.1 しか存在しない場合は、127.0.0.1 を戻します。
	addr = (struct in_addr **)p_hostent->h_addr_list;
	for( int i=0 ; addr!=NULL && addr[i]!=NULL ; i++ ){
		t_ip = ntohl(addr[i]->s_addr);			// Network -> Host (32[bit])
		if( t_ip!=0x7F000001 ) break;			// 0x7F000001 = 127.0.0.1
	}
	return t_ip;
}

/************************************************************************************************/
// CONV_POSN2TINT() convert {Port-Number|Service-Name}[S] into Port-Number[I].  ERROR = INVA
// {"7"|"echo"} -> 7
/************************************************************************************************/
tint conv_posn2tint(int proto,char *p2str){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
struct servent *p_servent;				// Pointer to STRUCT SERVENT for GETSERVBYNAME(3)
tint	t_port = INVA;					// Port-Number

char	buf[BUFSIZ],*s,*d,*p;
int		flag_allnum = TRUE;				// TRUE = Port-Number[S] / FALS = Service-Name[S]
int		flag_ns2s = FALS;				// Flag for None Space -> Space Transition
int		c_type    = '*';				// ( Current ) Char Type [ '*'=INIT/'S'=Space/'N'=NonSp ]

/* Check Port-Number [ "7 3" -> NG ] <- Check Only !! */
	for( s=p2str ; *s!='\0' ; s++ ){
		/***** SPACE *****/
		if( isspace(*s) ){
			if( c_type=='N' )			// 127  -> [sp]
				flag_ns2s = TRUE;
			else						// 先頭 -> [sp]  ||  [sp] -> [sp]
				;
			c_type = 'S';				// ' ' = Space
			continue;
		}
		/***** NONSP *****/
		else{
			if( flag_ns2s==TRUE )		//                                  127  -> [sp] -> 333
				return INVA;
			else						// 先頭 -> 333  ||  333 -> 333  ||  先頭 -> [sp] -> 333
				;
			c_type='N';					// 'N' = None Space
		}
	}

/* Pack & Copy Port-Number [ " 7 " -> "7" ] */
	s = p2str;
	d = &buf[0];
	while( *s != '\0' ){						// Convert " 7 " -> "7"
		if( isspace(*s) ){ s++; continue; }		// Skip Space
		*d = *s; s++; d++;						// Copy NonSp
	}
	*d = '\0';

/* Check String Type {Port-Number|Service-Name} */
	for( p=p2str ; *p!='\0' ; p++ ){			// Service-Name contain at least 1 Alphabet!!
		if( isalpha(*p) ){ flag_allnum=FALS; break; }
	}

/* Convert {Port-Number|Service-Name}[S] into Port-Number[I] */
	if( flag_allnum ){
		t_port = atoi2(p2str);
		if( t_port<0 || 65535<t_port )
			t_port = INVA;
	}
	else{
		p_servent = getservbyname( buf , proto=='N'?NULL:(proto=='U'?"udp":"tcp") );
		if( p_servent==NULL )
			t_port = INVA;
		else
			t_port = ntohs(p_servent->s_port);	// Network -> Host (16[bit])
	}
	return t_port;
}

/************************************************************************************************/
// DTAB_IPHN2TINT() - DTAB Version of CONV_IPHN2TINT() + TINT2TINT
// DTAB_POSN2TINT() - DTAB Version of CONV_POSN2TINT() + TINT2TINT
/************************************************************************************************/
tint dtab_iphn2tint(          dtab *x){ return (x->type=='S') ? conv_iphn2tint(      cstr(x)) : cint(x) ; }
tint dtab_posn2tint(int proto,dtab *x){ return (x->type=='S') ? conv_posn2tint(proto,cstr(x)) : cint(x) ; }

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_ip2str(ctree *ctr){			/*** TT-Lang: A = IP2STR(X) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x;
char	buf[BUFSIZ],*fmt;
tint	t_ip;			uint	ip[4];

/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"ID",0);		// 0x7F000001 ( = 127.0.0.1 )
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );						// "127.0.0.1"

	if( cint(x) < 0 || 0xFFFFFFFF < cint(x) ){ flag_exerr=IpAddr ; epos=0; return NULL; }

/* Do IP2STR()!! */
	t_ip  = cint(x);
	ip[0] =  ( (t_ip    ) & 0xFF );
	ip[1] =  ( (t_ip>> 8) & 0xFF );
	ip[2] =  ( (t_ip>>16) & 0xFF );
	ip[3] =  ( (t_ip>>24) & 0xFF );

	fmt = FMT_IP2STR();

	sprintf( buf, fmt, ip[3], ip[2], ip[1], ip[0] );
	a->type='S'; a->str=X_SDUP(buf); return ans;
}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_str2ip(ctree *ctr){			/*** TT-Lang: A = STR2IP(X) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x;
tint	t_ip;

/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"S",0);		// "127.0.0.1" 
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );						// 0x7F000001 ( = 127.0.0.1 )

/* Do STR2IP()!! */
	t_ip = conv_iphn2tint( cstr(x) );
	if( t_ip == INVA ){
		flag_exerr=IpAddr ; epos=0; return NULL;
	}
	a->type = 'I';
	a->ival = t_ip;
	return ans;
}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_port2serv(ctree *ctr){			/*** TT-Lang: A = PORT2SERV(X,Y) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x,*y;
struct servent *p_servent;				// Pointer for getservby{port|name}()
int		n_port;							// Port Number in Network Byte Order
int		proto='*';						// 'U'=UDP | 'T'=TCP | 'N'=NULL

/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"ID",0);		// 7
	y = ctr2p_dtab(     lptr(ctr,1) ); chk_vtype(y,"SP",1);		// "udp"|NULL
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );						// "echo"

	n_port = htons(cint(x));			// Host -> Network ( 16[BIT] )
	if( isnull(y) )
		proto = 'N';
	else{
		if( strcasecmp(cstr(y),"UDP")==0 ) proto = 'U';
		if( strcasecmp(cstr(y),"TCP")==0 ) proto = 'T';
	}
	if( cint(x) < 0 || 65535 < cint(x) ){ flag_exerr=PortNo ; epos=0; return NULL; }
	if( proto=='*'                     ){ flag_exerr=ProtoID; epos=1; return NULL; }

/* Do PORT2SERV()!! */
	if( proto=='N' )
		p_servent = getservbyport( n_port, NULL                   );
	else
		p_servent = getservbyport( n_port, proto=='U'?"udp":"tcp" );
	if( p_servent==NULL ){ null_dtab(a); return ans; }
	a->type = 'S';
	a->str  = X_SDUP(p_servent->s_name);
	return ans;
}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_serv2port(ctree *ctr){			/*** TT-Lang: A = SERV2PORT(X,Y) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x,*y;
tint	t_port;
int		proto='*';						// 'U'=UDP | 'T'=TCP | 'N'=NULL

/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"S" ,0);		// "echo"
	y = ctr2p_dtab(     lptr(ctr,1) ); chk_vtype(y,"SP",1);		// "udp"|NULL
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );						// 7

	if( isnull(y) )
		proto = 'N';
	else{
		if( strcasecmp(cstr(y),"UDP")==0 ) proto = 'U';
		if( strcasecmp(cstr(y),"TCP")==0 ) proto = 'T';
	}
	if( proto=='*' ){ flag_exerr=ProtoID; epos=1; return NULL; }

/* Do SERV2PORT()!! */
	t_port = conv_posn2tint( proto, cstr(x) );
	if( t_port == INVA ){
		flag_exerr=PortNo ; epos=0; return NULL;
	}
	a->type = 'I';
	a->ival = t_port;
	return ans;
}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_ip2host(ctree *ctr){			/*** TT-Lang: A = IP2HOST(X) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x;
struct hostent *p_hostent;				// Pointer for gethostby{addr|name}()
struct in_addr ip_addr;					// IP-Address for hostent
int		n_ip;							// IP-Address in Network Byte Order

/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"ID",0);		// 0x7F000001 ( = 127.0.0.1 )
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );						// "cpc"

	n_ip = htonl(cint(x));				// Host -> Network ( 32[BIT] )
	ip_addr.s_addr = n_ip;

/* Do IP2HOST()!! */
	p_hostent = gethostbyaddr( &ip_addr, sizeof(ip_addr), AF_INET );
	if( p_hostent==NULL ){ null_dtab(a); return ans; }
	a->type = 'S';
	a->str  = X_SDUP(p_hostent->h_name);
	return ans;
}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_host2ip(ctree *ctr){			/*** TT-Lang: A = HOST2IP(X) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x;
tint	t_ip;

/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"S" ,0);		// "cpc"
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );						// 0x7F000001 ( = 127.0.0.1 )

/* Do HOST2IP()!! */
	t_ip = conv_iphn2tint( cstr(x) );
	if( t_ip == INVA ){
		flag_exerr=IpAddr ; epos=0; return NULL;
	}
	a->type = 'I';
	a->ival = t_ip;
	return ans;
}
