/*** I_LINKCTRL.C ***/					#include	"main.h"

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_listen(ctree *ctr){			/*** TT-Lang: A = LISTEN([S]) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*s;						int		cnt,flag_mode;
struct sockaddr_in re_addr;				// {*****|Remote} Internet Address (IP+Port)
int		sock_ls,sock_ac;				// Socket for LISTEN(2) / Returned Socket from ACCEPT(2)
int		len,opt,ret;					// Length of Data / Option Value / Return Value

dtab	*p_timeout;						// Time Out for TCP_SOCKET [Sec]

/* Set Param(s) & Check Type(s) */

// Mode-A(ARGC=1): Sock(I)	ソケットが指定された場合：
//   指定されたソケット値を L&A_SOCKET に設定して、その値で listen() & accept() を実行します。
//   又、新規に生成されたソケット値を TCP_SOCKET に設定して、それを戻り値とします。
// Mode-B(ARGC=0):			ソケットが省略された場合：
// (B-1) TCP_SOCKET が有効の場合は、
//   そのソケット値が指定されたものと見なして、以下 Mode-A と同様の処理を行います。
// (B-3) TCP_SOCKET が無効の場合は、新規に tcp ソケットを生成し、
//   そのソケット値が指定されたものと見なして、以下 Mode-A と同様の処理を行います。

	switch( cnt=lcnt(ctr) ){			/* CNT = ARGC of this Func()							*/
		case 1: flag_mode='A';
			s = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(s,"ID"  ,0);	// Sock(I)
			break;
		case 0: flag_mode='B';
			s = TCP_SOCKET();
			if( cint(s)>0 ){			// TCP_SOCKET 有効
				;
			}
			else{						// TCP_SOCKET 無効
				s->type='I'; s->ival=mk_socket('T',TRUE,NULL,NULL); /*** Must Bind!! ***/
			}
			break;
		default:
			flag_exerr=NgARGCmm; epar[0]=cnt,epar[1]=0,epar[2]=1; return NULL;
	}
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

/* Do LISTEN()!! [ Listen-Part!! ] */
	sock_ls = cint(s);

/* { Do TRACE()!! ( if required ) } */
	if( flag_debug&DF_NETWK ){ eprin("[%sNw%s] listen(sock=%d) ", C_CYA(2), C_DEF(2), sock_ls ); }

/* [ Function Call ] */
	ret = listen( sock_ls, MAX_LISTEN );

/* { Do TRACE()!! ( if required ) } */
	if( flag_debug&DF_NETWK ){ eprin("-> ret=%d\n", ret ); }

	if( ret<0 ){						// Error!!
		flag_exerr=LisnAcc; /*last_ct=par;*/ return(NULL);
	}

/* { Do TRACE()!! ( if required ) } */
	if( flag_debug&DF_NETWK ){ eprin("[%sNw%s] accept(sock=%d) ", C_CYA(2), C_DEF(2), sock_ls ); }

/* Do LISTEN()!! [ Accept-Part!! ] */
	len = sizeof(re_addr);

/* [ SetUp TimeOut ] */
	p_timeout=TCP_TIMEOUT();
	if( isinfv(p_timeout) )				// +INF = Block Forever!!
		;
	else{								// IVAL = Time Out [Sec]
		opt = (cdbl(p_timeout)==0.0) ? O_NONBLOCK:0 ;
		ret = fcntl( sock_ls, F_SETFL, opt );
		if( ret<0 ){					// Error!!
			flag_exerr=LisnAcc; /*last_ct=par;*/ return(NULL);
		}
		set_alarm( cdbl(p_timeout) );	// SetUp Alarm!!
	}

/* [ Function Call ] */
	sock_ac = accept( sock_ls, (struct sockaddr *)&re_addr, (uint *)&len );

/* [ Clear TimeOut ] */
	opt = 0;
	ret = fcntl( sock_ls, F_SETFL, opt );
	if( ret<0 ){						// Error!!
		flag_exerr=LisnAcc; /*last_ct=par;*/ return(NULL);
	}
	set_alarm(0.0);						// Clear Alarm!!

/* { Do TRACE()!! ( if required ) } */
	if( flag_debug&DF_NETWK ){ eprin("-> ret=%d\n", sock_ac ); }

	if( sock_ac<0 ){					// Network Error!!
		if( errno==EINTR || errno==EWOULDBLOCK ){			/* Time Out!! || Non-Blocking!!	*/
			null_dtab(a); return ans;
		}
		flag_exerr=LisnAcc; /*last_ct=par;*/ return(NULL);
	}

	a->type = TCP_SOCKET()->type = 'I';			/*** Save to Default TCP_SOCKET!! ***/
	a->ival = TCP_SOCKET()->ival = sock_ac;		/*** Save to Default TCP_SOCKET!! ***/
	return ans;
}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_connect(ctree *ctr){			/*** TT-Lang: A = CONNECT([S,]X,Y) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*s,*x,*y;				int		cnt,flag_mode;
struct sockaddr_in re_addr;				// {*****|Remote} Internet Address (IP+Port)
tint	t_ip,t_port;					// IP Address / Port Number
int		/*len,*/opt,ret;				// Length of Data / Option Value / Return Value

dtab	*p_timeout;						// Time Out for TCP_SOCKET [Sec]

/* Set Param(s) & Check Type(s) */

// Mode-A(ARGC=3): Sock(I) IP(I) Port(I)
// Mode-B(ARGC=2):         IP(I) Port(I)

	switch( cnt=lcnt(ctr) ){			/* CNT = ARGC of this Func()							*/
		case 3: flag_mode='A';
			s = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(s,"ID"  ,0);	// Sock(I)
			x = ctr2p_dtab(     lptr(ctr,1) ); chk_vtype(x,"SID" ,1);	// IP  (I)
			y = ctr2p_dtab(     lptr(ctr,2) ); chk_vtype(y,"SID" ,2);	// Port(I)
			break;
		case 2: flag_mode='B';
			s = TCP_SOCKET(); if( cint(s)<=0 ){ s->type='I'; s->ival=mk_socket('T',FALS,NULL,NULL); }
			x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"SID" ,0);	// IP  (I)
			y = ctr2p_dtab(     lptr(ctr,1) ); chk_vtype(y,"SID" ,1);	// Port(I)
			break;
		default:
			flag_exerr=NgARGCmm; epar[0]=cnt,epar[1]=2,epar[2]=3; return NULL;
	}
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

/* Do CONNECT()!! */
	t_ip  = dtab_iphn2tint(    x);
	t_port= dtab_posn2tint('T',y);
	if( t_ip  <0 ){ flag_exerr=IpAddr; epos=(flag_mode=='A')?1:0; return NULL; }
	if( t_port<0 ){ flag_exerr=PortNo; epos=(flag_mode=='A')?2:1; return NULL; }

	re_addr.sin_family      = AF_INET;
	re_addr.sin_addr.s_addr = htonl(t_ip  );
	re_addr.sin_port        = htons(t_port);

/* { Do TRACE()!! ( if required ) } */
	if( flag_debug&DF_NETWK ){ eprin("[%sNw%s] connect(sock=%d) ", C_CYA(2), C_DEF(2), (int)cint(s) ); }

/* [ SetUp TimeOut ] */
	p_timeout=TCP_TIMEOUT();
	if( isinfv(p_timeout) )				// +INF = Block Forever!!
		;
	else{								// IVAL = Time Out [Sec]
		opt = (cdbl(p_timeout)==0.0) ? O_NONBLOCK:0 ;
		ret = fcntl( cint(s), F_SETFL, opt );
		if( ret<0 ){					// Error!!
			flag_exerr=LisnAcc; /*last_ct=par;*/ return(NULL);
		}
		set_alarm( cdbl(p_timeout) );	// SetUp Alarm!!
	}

/* [ Function Call ] */
	ret = connect( cint(s), (struct sockaddr *)&re_addr, sizeof(re_addr) );
	if( ret<0 ){						// Error!!
		null_dtab(a); return ans;
	}

/* [ Clear TimeOut ] */
	opt = 0;
	ret = fcntl( cint(s), F_SETFL, opt );
	if( ret<0 ){						// Error!!
		if( errno==EINTR || errno==EINPROGRESS ){			/* Time Out!! || Non-Blocking!!	*/
			null_dtab(a); return ans;
		}
		flag_exerr=Connect; /*last_ct=par;*/ return(NULL);
	}
	set_alarm(0.0);						// Clear Alarm!!

/* { Do TRACE()!! ( if required ) } */
	if( flag_debug&DF_NETWK ){ eprin("-> ret=%d\n", ret ); }

	if( ret<0 ){						// Error!!
		null_dtab(a);
		return ans;
	}

	a->type = 'I';
	a->ival = ret;
	return ans;
}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_disconn(ctree *ctr){			/*** TT-Lang: A = DISCONN([S]) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*s;			int		cnt,flag_mode;
int		ret;							// Return Value

/* Set Param(s) & Check Type(s) */

// Mode-A(ARGC=1): Sock(I)
// Mode-B(ARGC=0):

	switch( cnt=lcnt(ctr) ){			/* CNT = ARGC of this Func()							*/
		case 1: flag_mode='A';
			s = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(s,"ID"  ,0);	// Sock(I)
			break;
		case 0: flag_mode='B';
			s = TCP_SOCKET();	// 値が0であってもソケットの新規作成は行わない！
			break;
		default:
			flag_exerr=NgARGCmm; epar[0]=cnt,epar[1]=0,epar[2]=1; return NULL;
	}
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

/* Do DISCONN()!! */

/* { Do TRACE()!! ( if required ) } */
	if( flag_debug&DF_NETWK ){ eprin("[%sNw%s] disconn(sock=%d) ", C_CYA(2), C_DEF(2), (int)cint(s) ); }

	ret = close(cint(s));

/* { Do TRACE()!! ( if required ) } */
	if( flag_debug&DF_NETWK ){ eprin("-> ret=%d\n", ret ); }

	a->type = 'I';
	a->ival = ret;
	if( a->ival!=0 ){ null_dtab(a); }
	return ans;
}
