/*** I_RAWIP.C ***/						#include	"main.h"

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_raw_socket(ctree *ctr){		/*** TT-Lang: A = RAW_SOCKET(X) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x;						int		cnt;
int		sock,flag_bind;					// Socket for Network / Flag for BIND(2)

/* Set Param(s) & Check Type(s) */
	switch( cnt=lcnt(ctr) ){			/* CNT = ARGC of this Func()							*/
		case 1:	x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"SID",0);	// IP  (I)
				flag_bind = TRUE; break;
		case 0:
				flag_bind = FALS; break;
		default:
			flag_exerr=NgARGCnn; epar[0]=cnt,epar[1]=0,epar[2]=1,epar[3]=INVA; return NULL;
	}
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

/* Do RAW_SOCKET()!! */
	if( flag_bind )
		sock = mk_socket('R',TRUE,   x,NULL);
	else
		sock = mk_socket('R',FALS,NULL,NULL);

/* { Do TRACE()!! ( if required ) } */
	if( flag_debug&DF_NETWK ){ eprin("[%sNw%s] raw_socket() -> socket=%d\n", C_CYA(2), C_DEF(2), sock ); }

	if( sock<0 ){						// Error!!
		null_dtab(a);
		return ans;
	}

	a->type = RAW_SOCKET()->type = 'I';			/*** Save to Default RAW_SOCKET!! ***/
	a->ival = RAW_SOCKET()->ival = sock;		/*** Save to Default RAW_SOCKET!! ***/
	return ans;
}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_ping(ctree *ctr){				/*** TT-Lang: A = PING(S,X) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*s,*x;					int		cnt,flag_mode;
struct sockaddr_in re_addr;				// {*****|Remote} Internet Address (IP+Port)
struct iphdr   *p_iphdr;				// Struct for IP   Header
struct icmphdr *p_icmphdr;				// Struct for ICMP Header
struct timeval *p_timeval;				// Struct for TIMEVAL - tv_sec[Sec] & tv_usec[uSec]
struct timeval tx_time,rx_time,diff;
char	buf[MAX_PACKET+1];				// Buffer for ICMP/IP Frame ( +1 for NULL )
tint	t_ip,t_port;					// IP Address / Port Number
int		len,opt,ret;					// Length of Data / Option Value / Return Value

dtab	*p_timeout;						// Time Out for RAW_SOCKET [Sec]

       uint16_t t_pid=0xFFFF&getpid();	// ICMP ID       ( 0xFFFF & PID )
static uint16_t t_seq=0,t_coh=0;		// ICMP Sequence ( 0,1,2,3, ... )

/* Set Param(s) & Check Type(s) */

// Mode-A(ARGC=2): Sock(I) IP(I)
// Mode-B(ARGC=1):         IP(I)

	switch( cnt=lcnt(ctr) ){			/* CNT = ARGC of this Func()							*/
		case 2: flag_mode='A';
			s = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(s,"ID"  ,0);	// Sock(I)
			x = ctr2p_dtab(     lptr(ctr,1) ); chk_vtype(x,"SID" ,1);	// IP  (I)
			break;
		case 1: flag_mode='B';
			s = RAW_SOCKET(); if( cint(s)<=0 ){ s->type='I'; s->ival=mk_socket('R',FALS,NULL,NULL); }
			x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"SID" ,0);	// IP  (I)
			break;
		default:
			flag_exerr=NgARGCmm; epar[0]=cnt,epar[1]=1,epar[2]=2; return NULL;
	}
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

/* Do PING()!! [ TX-Part ] */
	t_ip  = dtab_iphn2tint(    x);
	t_port= 0;							// Not Used!!
	if( t_ip  <0 ){ flag_exerr=IpAddr; epos=(flag_mode=='A')?1:0; return NULL; }

	len   = 0;
// MSG_NOSIGNAL は、不正なソケットを利用した場合に発生する Broken Socket Error (SIGPIPE) によって
// プログラムが異常停止することを阻止します。（エラー処理を可能にします。）
	opt   = MSG_NOSIGNAL;
	re_addr.sin_family      = AF_INET;
	re_addr.sin_addr.s_addr = htonl(t_ip  );
	re_addr.sin_port        = htons(t_port);

// Make ICMP Header
	p_icmphdr = (struct icmphdr *)&buf[0];
	p_icmphdr->type             = ICMP_ECHO;
	p_icmphdr->code             = 0;
	p_icmphdr->checksum         = 0;
	p_icmphdr->un.echo.id       = t_pid;
	p_icmphdr->un.echo.sequence = t_coh = t_seq++;
	len += sizeof(struct icmphdr);

	if( gettimeofday(&tx_time,NULL)==-1 ){ flag_exerr=NullSYS; return NULL; }
	p_timeval  = (struct timeval *)&buf[len];
	*p_timeval = tx_time;				// Write TIMEVAL into Data Area
	len += sizeof(struct timeval);

//	for( int i=0x10 ; i<=0x37 ; i++,len++ ){ buf[len]=(0xFF&i); }

	p_icmphdr->checksum = net_checksum((uint16_t *)&buf[0],len);
/* -------------------  */

/* { Do TRACE()!! ( if required ) } */
	if( flag_debug&DF_NETWK ){ eprin("[%sNw%s] TX ping(sock=%d) ", C_CYA(2), C_DEF(2), (int)cint(s) ); }

/* [ SetUp TimeOut ] */
	p_timeout=RAW_TIMEOUT();
	if( isinfv(p_timeout) )				// +INF = Block Forever!!
		;
	else{								// IVAL = Time Out [Sec]
		opt |= (cdbl(p_timeout)==0.0) ? MSG_DONTWAIT:0 ;
		set_alarm( cdbl(p_timeout) );	// SetUp Alarm!!
	}

/* [ Function Call ] */
	ret = sendto( cint(s), buf, len, opt, (struct sockaddr *)&re_addr, sizeof(re_addr) );

/* { Do TRACE()!! ( if required ) } */
	if( flag_debug&DF_NETWK ){
		eprin("-> ret=%d { ICMP_HDR = ", ret ); for( int x=0 ; x<8 ; x++ ){ eprin("%02X ", buf[x+00]&0xFF ); } eprin("}\n");
	}

	if( ret<0 ){						// Network Error!!
		if( errno==EINTR || errno==EWOULDBLOCK ){			/* Time Out!! || Non-Blocking!!	*/
			null_dtab(a); return ans;
		}
		flag_exerr=RawRecv; /*last_ct=par;*/ return(NULL);
	}

RECVFROM_AGAIN:

/* Do PING()!! [ RX-Part ] */
	len = sizeof(re_addr);

/* { Do TRACE()!! ( if required ) } */
	if( flag_debug&DF_NETWK ){ eprin("[%sNw%s] RX ping(sock=%d) ", C_CYA(2), C_DEF(2), (int)cint(s) ); }

/* [ Function Call ] */
	ret = recvfrom( cint(s), buf, MAX_PACKET, opt, (struct sockaddr *)&re_addr, (uint *)&len );

/* [ Clear TimeOut ] */
	set_alarm(0.0);						// Clear Alarm!!

/* { Do TRACE()!! ( if required ) } */
	if( flag_debug&DF_NETWK ){
		int v20; p_iphdr = (struct iphdr *)&buf[0]; v20 = (p_iphdr->ihl)*4;
		eprin("-> ret=%d { ICMP_HDR = ", ret ); for( int x=0 ; x<8 ; x++ ){ eprin("%02X ", buf[x+v20]&0xFF ); } eprin("}\n");
	}

	if( ret<0 ){						// Network Error!!
		if( errno==EINTR || errno==EWOULDBLOCK ){			/* Time Out!! || Non-Blocking!!	*/
			null_dtab(a); return ans;
		}
		flag_exerr=RawRecv; /*last_ct=par;*/ return(NULL);
	}

// Check ICMP Header
	p_iphdr   = (struct iphdr   *)&buf[               0];
	if( re_addr.sin_family != AF_INET || re_addr.sin_addr.s_addr != htonl(t_ip) ){ goto RECVFROM_AGAIN; }
	if( ret < (p_iphdr->ihl)*4+ICMP_MINLEN                                      ){ goto RECVFROM_AGAIN; }

	p_icmphdr = (struct icmphdr *)&buf[(p_iphdr->ihl)*4];
	if( p_icmphdr->type             != ICMP_ECHOREPLY                           ){ goto RECVFROM_AGAIN; }
	if( p_icmphdr->un.echo.id       != t_pid                                    ){ goto RECVFROM_AGAIN; }
	if( p_icmphdr->un.echo.sequence != t_coh                                    ){ goto RECVFROM_AGAIN; }

// Calculate RTT ( Round Trip Time )
	if( gettimeofday(&rx_time,NULL)==-1 ){ flag_exerr=NullSYS; return NULL; }
	diff.tv_sec  = rx_time.tv_sec  - tx_time.tv_sec ;
	diff.tv_usec = rx_time.tv_usec - tx_time.tv_usec;
	if( diff.tv_usec < 0 ){ diff.tv_usec+=1000000; diff.tv_sec--; }

	a->type = 'D';
	a->dval = diff.tv_sec + diff.tv_usec/1000000.0;			/*** [Second] ***/
	return ans;
}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
// NET_CHECKSUM() calcurate & return {TCP|UDP|ICMP} Checksum.
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
uint16_t net_checksum(uint16_t *buf,int len){
uint64_t sum=0;

	while( len>1 ){
		sum += *buf;					// Add as 16[Bit] UINT
		buf++;							// Goto Next Word
		len-=2;							// -2[Byte]
	}
	if( len==1 )
		sum += *(uint8_t*)buf;			// Add as  8[Bit] UINT
	sum = (sum&0xFFFF)+(sum>>16);
	sum = (sum&0xFFFF)+(sum>>16);
	return ~sum;
}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
void net_alarmhandler(int signo){		// Alarm Hadler!! ( TCP/UDP/ICMP )
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
/* { Do TRACE()!! ( if required ) } */
	if( flag_debug&DF_SIGNO ){
		eprin("[%sSg%s] Signal %02d Detected!! [Iall=%d,Tall=%d,Icnt=%d,Tcnt=%d]\n",
		C_MAG(2), C_DEF(2), signo, sig_iall, sig_tall, sig_icnt[signo], sig_tcnt[signo] );
	}
}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
int set_alarm(tdbl t){					// Set Alarm!! ( T[Sec] )
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
struct itimerval tmval;					// Struct for SETITIMER(2)
tdbl	d_int,d_fra;					/* 整数部分と少数部分									*/
	d_fra = modf(t,&d_int);				// t -> d_int + d_fra
	tmval.it_interval.tv_sec  = 0;
	tmval.it_interval.tv_usec = 0;
	tmval.it_value   .tv_sec  = (tint)(d_int        );
	tmval.it_value   .tv_usec = (tint)(d_fra*1000000);
	return setitimer(ITIMER_REAL,&tmval,NULL);
}
