/*** I_SOCKET.C ***/					#include	"main.h"

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
// MK_SOCKET() - make & return {TCP|UDP|RAW} socket with BIND(2).  On error -1 is returned.
// If possilbe, it will enable broadcast TX for UDP. ( Pointer NULL is treated as integer 0. )
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
int mk_socket(int proto,int flag_bind,dtab *p2ip,dtab *p2port){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
struct sockaddr_in lo_addr;				// {Local|******} Internet Address (IP+Port)
struct ip_mreq mreq;					// Struct for Multicast Address
tint	t_ip,t_port;					// IP Address / Port Number
int		sock,opt,ret;					// Socket for Network / Option Value / Return Value

/*** [0] Assign IP Address & Port Number ***/
	if( p2ip  ==NULL ){ t_ip  =0; }else{ t_ip  =(p2ip  ->type=='S')?conv_iphn2tint(      p2ip  ->str):cint(p2ip  ); }
	if( p2port==NULL ){ t_port=0; }else{ t_port=(p2port->type=='S')?conv_posn2tint(proto,p2port->str):cint(p2port); }
	if( t_ip<0 || t_port<0 )			// Error!!
		return INVA;

/*** [1] Make {TCP|UDP|RAW} Socket ***/
	switch(proto){
		case 'U': sock = socket(PF_INET,SOCK_DGRAM ,IPPROTO_UDP ); break;
		case 'T': sock = socket(PF_INET,SOCK_STREAM,IPPROTO_TCP ); break;
		case 'R': sock = socket(PF_INET,SOCK_RAW   ,IPPROTO_ICMP); break;
		default: return INVA;
	}
	if( sock<0 )						// Error!!
		return INVA;

/*** [2] Enable Broad Cast ( UDP Only!! ) ***/
// 可能であれば、ブロードキャスト送信ができるようにしておく。(送信用。なお、できなくても構わない。)
	if( proto=='U' ){
		opt = 1;							// Enable
		setsockopt( sock, SOL_SOCKET, SO_BROADCAST, &opt, sizeof(opt) );
	}

/*** [3] Do Bind ( Option!! ) ***/
// バインドが指定されている時は、作成したソケットに対してバインドする。(これは、ローカルアドレス。)
	if( flag_bind ){
		memset(&lo_addr,0,sizeof(lo_addr));		/* Zero Clear!!									*/
		lo_addr.sin_family      = AF_INET;		/* Address Family = Intenet						*/
		lo_addr.sin_addr.s_addr = htonl(t_ip  );/* IP Address  (32Bit) [ Network Byte Order ]	*/
		lo_addr.sin_port        = htons(t_port);/* Port Number (16Bit) [ Network Byte Order ]	*/
		ret = bind( sock, (struct sockaddr *)&lo_addr, sizeof(lo_addr) );
		if( ret<0 )
			return INVA;
	}

/*** [4] Enable Multi Cast ( UDP Only!! ) ***/
// もし、IPアドレスがマルチキャストアドレスならば、それを受信できるようにしておく。(受信用。)
	if( (t_ip&0xF0000000)==0xE0000000 ){		/* IP = 1110.XXXX.XXXX.XXXX						*/
		memset(&mreq,0,sizeof(mreq));			/* Zero Clear!!									*/
		mreq.imr_interface.s_addr = INADDR_ANY;	/* IP Address  (32Bit) [ Network Byte Order ]	*/
		mreq.imr_multiaddr.s_addr = htonl(t_ip);/* IP Address  (32Bit) [ Network Byte Order ]	*/
		ret = setsockopt( sock, IPPROTO_IP, IP_ADD_MEMBERSHIP, (char *)&mreq, sizeof(mreq) );
		if( ret<0 )
			return INVA;
	}

/* { Do TRACE()!! ( if required ) } */
	if( flag_debug&DF_NETWK ){ eprin("[%sNw%s] mk_socket() -> socket=%d\n", C_CYA(2), C_DEF(2), sock ); }

/*** [5] Return Socket ***/
	return sock;
}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *do_xsock(ctree *ctr,char mode){
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a[3],*s;					int		cnt;
struct sockaddr_in addr;				// {Local|Remote} Ineternet Address (IP+Port)
int		len,opt,ret;					// Length of Data / Option Value / Return Value

/* Set Param(s) & Check Type(s) */
	switch( cnt=lcnt(ctr) ){			/* CNT = ARGC of this Func()							*/
		case 1:	s = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(s,"ID",0);
				break;
		default:
			flag_exerr=NgARGCmm; epar[0]=cnt,epar[1]=1,epar[2]=1; return NULL;
	}
	ans = ext_ctrdtabmult(ctr,3);
	for( int i=0 ; i<3 ; i++ )
		a[i] = ctr2p_dtab(lptr(ans,i));

/* Do XSOCK()!! */

/*** {Local|Remote} Info ***/
	len = sizeof(addr);					// {LO|RE} IP&Port
	if( mode=='L' )						// Local
		ret = getsockname( cint(s), &addr, (uint *)&len );
	if( mode=='R' )						// Remote
		ret = getpeername( cint(s), &addr, (uint *)&len );

	if( ret<0 || addr.sin_family!=AF_INET )
		for( int i=0 ; i< 3 ; i++ ){ null_dtab(a[i]); }
	else{								// Ret[3] = {IP(I),Port(I),Type(I)}
	/* ( IP   ) */
		a[0]->type='I'; a[0]->ival=ntohl           (addr.sin_addr.s_addr) ;
	/* ( Port ) */
		a[1]->type='I'; a[1]->ival=ntohs           (addr.sin_port       ) ;

		opt = 0; len = sizeof(opt);		// LO Option
		ret = getsockopt( cint(s), SOL_SOCKET, SO_TYPE, &opt, (uint *)&len );
	/* ( Type ) */
		if( ret<0                  ){ null_dtab(a[2]); }
		else{
			if( opt==SOCK_DGRAM || opt==SOCK_STREAM )
				{ a[2]->type='I'; a[2]->ival =(opt==SOCK_DGRAM)?'U':'T';                  }
			else						// On raw sockets sin_port is set to the IP protocol. ( See: man 7 ip )
				{ a[2]->type='I'; a[2]->ival =(opt==SOCK_RAW  )?'R':'?'; null_dtab(a[1]); }
		}
	}

	return ans;
}

ctree *i_lsock(ctree *ctr){ return do_xsock(ctr,'L'); /*** TT-Lang: A = LSOCK(I) ***/ }
ctree *i_rsock(ctree *ctr){ return do_xsock(ctr,'R'); /*** TT-Lang: A = RSOCK(I) ***/ }
