/*** I_TCPIP.C ***/						#include	"main.h"

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_tcp_socket(ctree *ctr){		/*** TT-Lang: A = TCP_SOCKET([X,Y]) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x,*y;					int		cnt;
int		sock,flag_bind;					// Socket for Network / Flag for BIND(2)

/* Set Param(s) & Check Type(s) */
	switch( cnt=lcnt(ctr) ){			/* CNT = ARGC of this Func()							*/
		case 2:	x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"SID",0);	// IP  (I)
				y = ctr2p_dtab(     lptr(ctr,1) ); chk_vtype(y,"SID",1);	// Port(I)
				flag_bind = TRUE; break;
		case 0:
				flag_bind = FALS; break;
		default:
			flag_exerr=NgARGCnn; epar[0]=cnt,epar[1]=0,epar[2]=2,epar[3]=INVA; return NULL;
	}
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

/* Do TCP_SOCKET()!! */
	if( flag_bind )
		sock = mk_socket('T',TRUE,   x,   y);
	else
		sock = mk_socket('T',FALS,NULL,NULL);

/* { Do TRACE()!! ( if required ) } */
	if( flag_debug&DF_NETWK ){ eprin("[%sNw%s] tcp_socket() -> socket=%d\n", C_CYA(2), C_DEF(2), sock ); }

	if( sock<0 ){						// Error!!
		null_dtab(a);
		return ans;
	}

	a->type = TCP_SOCKET()->type = 'I';			/*** Save to Default TCP_SOCKET!! ***/
	a->ival = TCP_SOCKET()->ival = sock;		/*** Save to Default TCP_SOCKET!! ***/
	return ans;
}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_tx_tcp(ctree *ctr){			/*** TT-Lang: A = TX_TCP(S,Z,B) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*s,*z,*b;				int		cnt,flag_mode;
char	*p_data;						// Pointer to Payload Data
int		len,opt,ret;					// Length of Data / Option Value / Return Value

dtab	*p_timeout;						// Time Out for TCP_SOCKET [Sec]

/* Set Param(s) & Check Type(s) */

// Mode-A(ARGC=2): Sock(I) Data(S)
// Mode-B(ARGC=1):         Data(S)
// Mode-C(ARGC=3): Sock(I) Data(P) Byte(I)
// Mode-D(ARGC=2):         Data(P) Byte(I)

	switch( cnt=lcnt(ctr) ){			/* CNT = ARGC of this Func()							*/
		case 3: flag_mode='C';
			s = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(s,"ID"  ,0);	// Sock(I)
			z = ctr2p_dtab(     lptr(ctr,1) ); chk_vtype(z,"SP"  ,1);	// Data(P)
			b = ctr2p_dtab(     lptr(ctr,2) ); chk_vtype(b,"ID"  ,2);	// Byte(I)
			break;
		case 2:
			s = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(s,"SIDP",0);	// Sock(I) | Data(P)
			z = ctr2p_dtab(     lptr(ctr,1) ); chk_vtype(z,"SIDP",1);	// Data(S) | Byte(I)
			if( issptr(z) ){	/*** Mode-A ***/
				flag_mode='A'; chk_vtype(s,"ID",0); chk_vtype(z,"SP",1);
			}
			else{				/*** Mode-D ***/
				flag_mode='D'; chk_vtype(s,"SP",0); chk_vtype(z,"ID",1);
				b = z;
				z = s;
				s = TCP_SOCKET(); if( cint(s)<=0 ){ s->type='I'; s->ival=mk_socket('T',FALS,NULL,NULL); }
			}
			break;
		case 1: flag_mode='B';
			s = TCP_SOCKET(); if( cint(s)<=0 ){ s->type='I'; s->ival=mk_socket('T',FALS,NULL,NULL); }
			z = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(z,"SP"  ,0);	// Data(S)
			break;
		default:
			flag_exerr=NgARGCmm; epar[0]=cnt,epar[1]=1,epar[2]=3; return NULL;
	}
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

/* Do TX_TCP()!! */
	len   = (flag_mode=='A'||flag_mode=='B') ? strlen2(cstr(z)) : cint(b) ;
// MSG_NOSIGNAL は、不正なソケットを利用した場合に発生する Broken Socket Error (SIGPIPE) によって
// プログラムが異常停止することを阻止します。（エラー処理を可能にします。）
	opt   = MSG_NOSIGNAL;

/* { Do TRACE()!! ( if required ) } */
	if( flag_debug&DF_NETWK ){ eprin("[%sNw%s] tx_tcp(sock=%d) ", C_CYA(2), C_DEF(2), (int)cint(s) ); }

/* [ SetUp TimeOut ] */
	p_timeout=TCP_TIMEOUT();
	if( isinfv(p_timeout) )				// +INF = Block Forever!!
		;
	else{								// IVAL = Time Out [Sec]
		opt |= (cdbl(p_timeout)==0.0) ? MSG_DONTWAIT:0 ;
		set_alarm( cdbl(p_timeout) );	// SetUp Alarm!!
	}

/* [ Function Call ] */
	ret = send( cint(s), p_data=cptr(z), len, opt );

/* [ Clear TimeOut ] */
	set_alarm(0.0);						// Clear Alarm!!

/* { Do TRACE()!! ( if required ) } */
	if( flag_debug&DF_NETWK ){ eprin("-> ret=%d ", ret );
		eprin("{ TCP_HDR = ");
		for( int x=0 ; x<20 ; x++ ){ eprin("%02X ",p_data[x+00]&0xFF); }	/* No IP-Header!!	*/
		eprin("}\n");
	}

	if( ret<0 ){						// Network Error!!
		flag_exerr=TcpSend; /*last_ct=par;*/ return(NULL);
	}

	a->type = 'I';
	a->ival = ret;
	return ans;
}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_rx_tcp(ctree *ctr){			/*** TT-Lang: A = RX_TCP(S) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*s;						int		cnt,flag_mode;
struct sockaddr_in re_addr;				// {*****|Remote} Internet Address (IP+Port)
char	buf[MAX_PACKET+1];				// Buffer for TCP/IP Frame ( +1 for NULL )
int		len,opt,ret;					// Length of Data / Option Value / Return Value

dtab	*p_timeout;						// Time Out for TCP_SOCKET [Sec]

/* Set Param(s) & Check Type(s) */

// Mode-A(ARGC=1): Sock(I)
// Mode-B(ARGC=0):

	switch( cnt=lcnt(ctr) ){			/* CNT = ARGC of this Func()							*/
		case 1: flag_mode='A';
			s = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(s,"ID"  ,0);	// Sock(I)
			break;
		case 0: flag_mode='B';
			s = TCP_SOCKET(); if( cint(s)<=0 ){ s->type='I'; s->ival=mk_socket('T',TRUE,NULL,NULL); } /*** Must Bind!! ***/
			break;
		default:
			flag_exerr=NgARGCmm; epar[0]=cnt,epar[1]=0,epar[2]=1; return NULL;
	}
	ans = ext_ctrdtabmult(ctr,2);

/* Do RX_TCP()!! */
	len = sizeof(re_addr);
	opt = 0;

/* { Do TRACE()!! ( if required ) } */
	if( flag_debug&DF_NETWK ){ eprin("[%sNw%s] rx_tcp(sock=%d) ", C_CYA(2), C_DEF(2), (int)cint(s) ); }

/* [ SetUp TimeOut ] */
	p_timeout=TCP_TIMEOUT();
	if( isinfv(p_timeout) )				// +INF = Block Forever!!
		;
	else{								// IVAL = Time Out [Sec]
		opt = (cdbl(p_timeout)==0.0) ? MSG_DONTWAIT:0 ;
		set_alarm( cdbl(p_timeout) );	// SetUp Alarm!!
	}

/* [ Function Call ] */
	ret = recv( cint(s), buf, MAX_PACKET, opt );

/* [ Clear TimeOut ] */
	set_alarm(0.0);						// Clear Alarm!!

/* { Do TRACE()!! ( if required ) } */
	if( flag_debug&DF_NETWK ){
		eprin("-> ret=%d { TCP_HDR = ", ret );
		for( int x=0 ; x<20 ; x++ ){ eprin("%02X ", buf[x+00]&0xFF ); }
		eprin("}\n");
	}

	if( ret<0 ){						// Network Error!!
		flag_exerr=TcpRecv; /*last_ct=par;*/ return(NULL);
	}
	if( ret==0 ){						// Peer Closed!!
		a = ctr2p_dtab(lptr(ans,0)); null_dtab(a);										// Data(S)
		a = ctr2p_dtab(lptr(ans,1)); null_dtab(a);										// Size(I)
		return ans;
	}

	buf[ret] = '\0';
	a = ctr2p_dtab(lptr(ans,0)); a->type='S'; a->str =X_NDUP(buf,ret);					// Data(S)
	a = ctr2p_dtab(lptr(ans,1)); a->type='I'; a->ival=ret;								// Size(I)
	return ans;
}
