/*** I_UDPIP.C ***/						#include	"main.h"

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_udp_socket(ctree *ctr){		/*** TT-Lang: A = UDP_SOCKET(X,Y) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x,*y;					int		cnt;
int		sock,flag_bind;					// Socket for Network / Flag for BIND(2)

/* Set Param(s) & Check Type(s) */
	switch( cnt=lcnt(ctr) ){			/* CNT = ARGC of this Func()							*/
		case 2:	x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"SID",0);	// IP  (I)
				y = ctr2p_dtab(     lptr(ctr,1) ); chk_vtype(y,"SID",1);	// Port(I)
				flag_bind = TRUE; break;
		case 0:
				flag_bind = FALS; break;
		default:
			flag_exerr=NgARGCnn; epar[0]=cnt,epar[1]=0,epar[2]=2,epar[3]=INVA; return NULL;
	}
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

/* Do UDP_SOCKET()!! */
	if( flag_bind )
		sock = mk_socket('U',TRUE,   x,   y);
	else
		sock = mk_socket('U',FALS,NULL,NULL);

/* { Do TRACE()!! ( if required ) } */
	if( flag_debug&DF_NETWK ){ eprin("[%sNw%s] udp_socket() -> socket=%d\n", C_CYA(2), C_DEF(2), sock ); }

	if( sock<0 ){						// Error!!
		null_dtab(a);
		return ans;
	}

	a->type = UDP_SOCKET()->type = 'I';			/*** Save to Default UDP_SOCKET!! ***/
	a->ival = UDP_SOCKET()->ival = sock;		/*** Save to Default UDP_SOCKET!! ***/
	return ans;
}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_tx_udp(ctree *ctr){			/*** TT-Lang: A = TX_UDP(S,X,Y,Z,B) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*s,*x,*y,*z,*b;			int		cnt,flag_mode;
struct sockaddr_in re_addr;				// {*****|Remote} Internet Address (IP+Port)
tint	t_ip,t_port;					// IP Address / Port Number
char	*p_data;						// Pointer to Payload Data
int		len,opt,ret;					// Length of Data / Option Value / Return Value

dtab	*p_timeout;						// Time Out for UDP_SOCKET [Sec]

/* Set Param(s) & Check Type(s) */

// Mode-A(ARGC=4): Sock(I) IP(I) Port(I) Data(S)
// Mode-B(ARGC=3):         IP(I) Port(I) Data(S)
// Mode-C(ARGC=5): Sock(I) IP(I) Port(I) Data(P) Byte(I)
// Mode-D(ARGC=4):         IP(I) Port(I) Data(P) Byte(I)

	switch( cnt=lcnt(ctr) ){			/* CNT = ARGC of this Func()							*/
		case 5: flag_mode='C';
			s = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(s,"ID"  ,0);	// Sock(I)
			x = ctr2p_dtab(     lptr(ctr,1) ); chk_vtype(x,"SID" ,1);	// IP  (I)
			y = ctr2p_dtab(     lptr(ctr,2) ); chk_vtype(y,"SID" ,2);	// Port(I)
			z = ctr2p_dtab(     lptr(ctr,3) ); chk_vtype(z,"SP"  ,3);	// Data(P)
			b = ctr2p_dtab(     lptr(ctr,4) ); chk_vtype(b,"ID"  ,4);	// Byte(I)
			break;
		case 4:
			s = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(s,"SID" ,0);	// Sock(I) | IP  (I)
			x = ctr2p_dtab(     lptr(ctr,1) ); chk_vtype(x,"SID" ,1);	// IP  (I) | Port(I)
			y = ctr2p_dtab(     lptr(ctr,2) ); chk_vtype(y,"SIDP",2);	// Port(I) | Data(P)
			z = ctr2p_dtab(     lptr(ctr,3) ); chk_vtype(z,"SIDP",3);	// Data(S) | Byte(I)
			if( issptr(z) ){	/*** Mode-A ***/
				flag_mode='A'; chk_vtype(y,"SID",2);
			}
			else{				/*** Mode-D ***/
				flag_mode='D'; chk_vtype(y,"SP" ,2);
				b = z;
				z = y;
				y = x;
				x = s;
				s = UDP_SOCKET(); if( cint(s)<=0 ){ s->type='I'; s->ival=mk_socket('U',FALS,NULL,NULL); }
			}
			break;
		case 3: flag_mode='B';
			s = UDP_SOCKET(); if( cint(s)<=0 ){ s->type='I'; s->ival=mk_socket('U',FALS,NULL,NULL); }
			x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"SID" ,0);	// IP  (I)
			y = ctr2p_dtab(     lptr(ctr,1) ); chk_vtype(y,"SID" ,1);	// Port(I)
			z = ctr2p_dtab(     lptr(ctr,2) ); chk_vtype(z,"SP"  ,2);	// Data(S)
			break;
		default:
			flag_exerr=NgARGCmm; epar[0]=cnt,epar[1]=3,epar[2]=5; return NULL;
	}
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

/* Do TX_UDP()!! */
	t_ip  = dtab_iphn2tint(    x);
	t_port= dtab_posn2tint('U',y);
	if( t_ip  <0 ){ flag_exerr=IpAddr; epos=(flag_mode=='A'||flag_mode=='C')?2:1; return NULL; }
	if( t_port<0 ){ flag_exerr=PortNo; epos=(flag_mode=='A'||flag_mode=='C')?3:2; return NULL; }

	len   = (flag_mode=='A'||flag_mode=='B') ? strlen2(cstr(z)) : cint(b) ;
// MSG_NOSIGNAL は、不正なソケットを利用した場合に発生する Broken Socket Error (SIGPIPE) によって
// プログラムが異常停止することを阻止します。（エラー処理を可能にします。）
	opt   = MSG_NOSIGNAL;
	re_addr.sin_family      = AF_INET;
	re_addr.sin_addr.s_addr = htonl(t_ip  );
	re_addr.sin_port        = htons(t_port);

/* { Do TRACE()!! ( if required ) } */
	if( flag_debug&DF_NETWK ){ eprin("[%sNw%s] tx_udp(sock=%d) ", C_CYA(2), C_DEF(2), (int)cint(s) ); }

/* [ SetUp TimeOut ] */
	p_timeout=UDP_TIMEOUT();
	if( isinfv(p_timeout) )				// +INF = Block Forever!!
		;
	else{								// IVAL = Time Out [Sec]
		opt |= (cdbl(p_timeout)==0.0) ? MSG_DONTWAIT:0 ;
		set_alarm( cdbl(p_timeout) );	// SetUp Alarm!!
	}

/* [ Function Call ] */
	ret = sendto( cint(s), p_data=cptr(z), len, opt, (struct sockaddr *)&re_addr, sizeof(re_addr) );

/* [ Clear TimeOut ] */
	set_alarm(0.0);						// Clear Alarm!!

/* { Do TRACE()!! ( if required ) } */
	if( flag_debug&DF_NETWK ){
		eprin("-> ret=%d { UDP_HDR = ", ret ); for( int x=0 ; x<8 ; x++ ){ eprin("%02X ", p_data[x+00]&0xFF ); } eprin("}\n");
	}

	if( ret<0 ){						// Network Error!!
		if( errno==EINTR || errno==EWOULDBLOCK ){			/* Time Out!! || Non-Blocking!!	*/
			null_dtab(a); return ans;
		}
		flag_exerr=UdpSend; /*last_ct=par;*/ return(NULL);
	}

	a->type = 'I';
	a->ival = ret;
	return ans;
}


/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_rx_udp(ctree *ctr){			/*** TT-Lang: A = RX_UDP(S) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*s;						int		cnt,flag_mode;
struct sockaddr_in re_addr;				// {*****|Remote} Internet Address (IP+Port)
char	buf[MAX_PACKET+1];				// Buffer for UDP/IP Frame ( +1 for NULL )
int		len,opt,ret;					// Length of Data / Option Value / Return Value

dtab	*p_timeout;						// Time Out for UDP_SOCKET [Sec]

/* Set Param(s) & Check Type(s) */

// Mode-A(ARGC=1): Sock(I)
// Mode-B(ARGC=0):

	switch( cnt=lcnt(ctr) ){			/* CNT = ARGC of this Func()							*/
		case 1: flag_mode='A';
			s = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(s,"ID"  ,0);	// Sock(I)
			break;
		case 0: flag_mode='B';
			s = UDP_SOCKET(); if( cint(s)<=0 ){ s->type='I'; s->ival=mk_socket('U',TRUE,NULL,NULL); } /*** Must Bind!! ***/
			break;
		default:
			flag_exerr=NgARGCmm; epar[0]=cnt,epar[1]=0,epar[2]=1; return NULL;
	}
	ans = ext_ctrdtabmult(ctr,4);

/* Do RX_UDP()!! */
	len = sizeof(re_addr);
	opt = 0;

/* { Do TRACE()!! ( if required ) } */
	if( flag_debug&DF_NETWK ){ eprin("[%sNw%s] rx_udp(sock=%d) ", C_CYA(2), C_DEF(2), (int)cint(s) ); }

/* [ SetUp TimeOut ] */
	p_timeout=UDP_TIMEOUT();
	if( isinfv(p_timeout) )				// +INF = Block Forever!!
		;
	else{								// IVAL = Time Out [Sec]
		opt = (cdbl(p_timeout)==0.0) ? MSG_DONTWAIT:0 ;
		set_alarm( cdbl(p_timeout) );	// SetUp Alarm!!
	}

/* [ Function Call ] */
	ret = recvfrom( cint(s), buf, MAX_PACKET, opt, (struct sockaddr *)&re_addr, (uint *)&len );

/* [ Clear TimeOut ] */
	set_alarm(0.0);						// Clear Alarm!!

/* { Do TRACE()!! ( if required ) } */
	if( flag_debug&DF_NETWK ){
		eprin("-> ret=%d { UDP_HDR = ", ret ); for( int x=0 ; x<8 ; x++ ){ eprin("%02X ", buf[x+00]&0xFF ); } eprin("}\n");
	}

	if( ret<0 ){						// Network Error!!
		if( errno==EINTR || errno==EWOULDBLOCK ){			/* Time Out!! || Non-Blocking!!	*/
			for( int idx=0 ; idx<4 ; idx++ ){ a = ctr2p_dtab(lptr(ans,idx)); null_dtab(a); } return ans;
		}
		flag_exerr=UdpRecv; /*last_ct=par;*/ return(NULL);
	}

	buf[ret] = '\0';
	a = ctr2p_dtab(lptr(ans,0)); a->type='I'; a->ival=ntohl(re_addr.sin_addr.s_addr);	// IP  (I)
	a = ctr2p_dtab(lptr(ans,1)); a->type='I'; a->ival=ntohs(re_addr.sin_port       );	// Port(I)
	a = ctr2p_dtab(lptr(ans,2)); a->type='S'; a->str =X_NDUP(buf,ret);					// Data(S)
	a = ctr2p_dtab(lptr(ans,3)); a->type='I'; a->ival=ret;								// Size(I)
	return ans;
}
