/*** CMDSTR2ARGV.C ***/					#include	"main.h"
/************************************************************************************************/
// cmdstr2argv() - コマンド文字列内に含まれるエスケープシーケンス ( \r \n ) と引用囲み ( ""[[]] )
// を正しく解釈しつつ、トークンに分解し ARGV[] 配列を作成する。戻り値：ARGV[] 配列 or NULL
/************************************************************************************************/
extern char **cmdstr2argv(char *orig){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
char	**p_argv;						/* Token Array ( ARGV[] Array )							*/
char	*ebuf, xbuf[3];					/* Buffer for Eval Token & Eval "\xFF"					*/
int		flag_q = FALS;					/* Flag for "~" Inside (T/F)							*/
int		len, t, s, d;					/* Length & {Token|Src|Dst} Index						*/

/*** DEBUG ***/
//printf( "cmdstr2argv(): orig=\"%s\"\n",orig);

/* NULL Check */
	if( orig==NULL ) return NULL;

/* Eval & Sepa Orig into Token */
	p_argv = X_ATOM( sizeof(char*)*(MAX_ARGC+1) );

	len  = strlen2(orig);
	ebuf = X_ATOM(len+1);
	t = s = d = 0;

/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
	while( s<=len ){					// For all Chars in Orig (+NUL)
	/*** ESC ***						A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
		if( orig[s]=='\\' ){
			switch( orig[s+1] ){
				case 0x00: return NULL;			// 文字不足
				case '0': ebuf[d++]='\0'; s+=2; break;
				case 'a': ebuf[d++]='\a'; s+=2; break;
				case 'b': ebuf[d++]='\b'; s+=2; break;
				case 'e': ebuf[d++]=0x1B; s+=2; break;
				case 'f': ebuf[d++]='\f'; s+=2; break;
				case 'n': ebuf[d++]='\n'; s+=2; break;
				case 'r': ebuf[d++]='\r'; s+=2; break;
				case 't': ebuf[d++]='\t'; s+=2; break;
				case 'v': ebuf[d++]='\v'; s+=2; break;
				case 'x':
					if( s+3<len ){
						xbuf[0] = orig[s+2];
						xbuf[1] = orig[s+3];
						xbuf[2] = '\0';
						 ebuf[d++] = strtol(xbuf,NULL,16); s+=4; break;
					}
					else{ return NULL; }		// 文字不足
				default: ebuf[d++] = orig[s+1];            s+=2; break;
			}
			continue;
		}
	/*** "~" ***						A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
		if( orig[s]=='\"' ){
			flag_q = (flag_q==FALS) ? TRUE:FALS ;
			s++;
			continue;
		}
	/*** [[ ]] ***						A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
		if( flag_q!=TRUE && orig[s]=='[' && orig[s+1]=='[' ){	// 開始条件
			s+=2;
			while( TRUE ){
				if( orig[s]=='\0' || orig[s+1]=='\0' )			// 文字不足
					return NULL;
				if( orig[s]==']'  && orig[s+1]==']'  ){			// 終了条件
					s+=2;
					break;
				}
				ebuf[d++] = orig[s++];
			}
			continue;
		}
	/*** SP|TAB ***						A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
		if( flag_q!=TRUE && (orig[s]==' '||orig[s]=='\t') ){	// 開始条件
		// トークン配列へのセット
			if( d==0 ){					// 空トークン
				s++; continue;
			}
			if( ! (t<MAX_ARGC) )		// 文字過剰
				return NULL;
			ebuf  [d++] = '\0'; d = 0;	// NUL Term
			p_argv[t++] = X_SDUP(ebuf);	// Set Array
			continue;
		}
	/*** '\0' ***						A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
		if( orig[s]=='\0' ){									// 終了条件
		// トークン配列へのセット
			if( d==0 ){ break; }		// 空トークン
			if( ! (t<MAX_ARGC) )		// 文字過剰
				return NULL;
			ebuf  [d++] = '\0'; d = 0;	// NUL Term
			p_argv[t++] = X_SDUP(ebuf);	// Set Array
			break;
		}
	/*** C ***							A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
		ebuf[d++] = orig[s++];
	}
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/

/* Check Status */
	if( flag_q==TRUE )					// "~ 閉じ忘れ
		return NULL;

/* Term & Return */
	p_argv[t] = NULL;					// p_argv[argc] = NULL

/*** DEBUG ***/
//for( int idx=0 ; idx<t ; idx++ )
//	printf( "cmdstr2argv(): p_argv[%d]=\"%s\"\n", idx, p_argv[idx] );

	return p_argv;
}
