/*** I_PROC.C ***/						#include	"main.h"

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_pause(ctree *ctr){				/*** TT-Lang: VOID = PAUSE(VOID) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans;			dtab	*a;

/* Set Param(s) & Check Type(s) */
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

/* Do PAUSE()!! */
	void_dtab(a); pause(); return ans;
}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_sleep(ctree *ctr){				/*** TT-Lang: A = SLEEP(X) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x;
struct timespec req,rem;				// Struct TIMESPEC for NANOSLEEP(3)
tdbl	dint,dfra;						// Integral Part & Fractional Part of TDBL
int		ret;

/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"ID",0);
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

/* Do SLEEP()!! */
	dfra = modf(cdbl(x),&dint);
	req.tv_sec  = (tint)(dint           );
	req.tv_nsec = (tint)(dfra*1000000000);
	ret = nanosleep(&req,&rem);
	if( ret<0 ){						// Wake Up by Signal!!
		a->type='D'; a->dval=rem.tv_sec+rem.tv_nsec/1000000000; return ans;
	}
	else{								// Wake Up by Normal!!
		a->type='D'; a->dval=0.0;                               return ans;
	}
}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_exit(ctree *ctr){				/*** TT-Lang: VOID = EXIT(X) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x;

/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"ID",0);
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

/* Do EXIT()!! */
	void_dtab(a); exit(cint(x)); return ans;
}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_system(ctree *ctr){			/*** TT-Lang: A = SYSTEM(X) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x;

/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"S",0);
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

/* Do SYSTEM()!! */						// Exit Status => A & $?
	a->type='I'; a->ival=WEXITSTATUS(system(x->str)); cpy_dtab(PTR2DOLQ(),a); return ans;
}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_syscmd(ctree *ctr){			/*** TT-Lang: A = SYSCMD(X) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*e,*x;
//int	fd_w; 	FILE	*fp_w=NULL;		// 未実装
int		fd_r; 	FILE	*fp_r=NULL;		// 親側：読み出し用 <- 子側 STDOUT(1) に接続
int		fd_e; 	FILE	*fp_e=NULL;		// 親側：読み出し用 <- 子側 STDERR(2) に接続
int		pid,status;						// PID & Status Code of Child
char	**p_argv;						// EXECV(3) 用の引数配列
char	*p_out,*p_err,buf[BUFSIZ];

/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"S",0);
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

	p_argv = cmdstr2argv(cstr(x));	// NULL ( Error ) will be detected by popen3()

/* Set PIPE ( FORK & EXEC ) */
	pid = popen3( p_argv, NULL, &fd_r, &fd_e );
	if( pid==INVA || flag_exerr ){ /*** flag_exerr is set by popen3() ***/ null_dtab(a); return ans; }

//	fp_w = fdopen(fd_w,"w");
	fp_r = fdopen(fd_r,"r");
	fp_e = fdopen(fd_e,"r");

	signal(SIGPIPE,pipe_handler);		// SIGPIPE 用シグナルハンドラのセット

/* Do SYSCMD()!! */

/*** Write (1/5) ***/
	;

/*** Wait (2/5) ***/
	waitpid( pid, &status, 0 );

/*** Read (3/5) ***/
	p_out = NULL;
	p_err = NULL;
	while( fgets(buf,BUFSIZ,fp_r)!=NULL )
		p_out = X_SCAT(p_out,buf);
	while( fgets(buf,BUFSIZ,fp_e)!=NULL )
		p_err = X_SCAT(p_err,buf);

/*** Sets (4/5) ***/
// STAT   - Status Code of Child
// STDOUT - STDOUT of Child
// STDERR - STDERR of Child
	e=ds2p_dtab(a,"stat"  ); e->type='I'; e->ival=WEXITSTATUS(status);
	e=ds2p_dtab(a,"stdout"); e->type='S'; e->str =p_out; if( p_out==NULL ){ null_dtab(e); }
	e=ds2p_dtab(a,"stderr"); e->type='S'; e->str =p_err; if( p_err==NULL ){ null_dtab(e); }

/*** Retn (5/5) ***/
	a->attr |= ATTR_STID; return ans;	/*** Arry&Hash => StId ***/
}
