/*** I_SIGNAL.C ***/					#include	"main.h"

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_tx_sig(ctree *ctr){			/*** TT-Lang: A = TX_SIG(X,Y) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x,*y;

/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"ID",0);	// SIG
	y = ctr2p_dtab( par=lptr(ctr,1) ); chk_vtype(y,"ID",1);	// PID
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

/* Do TX_SIG()!! */
	a->type = 'I';
	a->ival = kill(cint(y),cint(x));	// KILL(PID,SIG)
	if( a->ival!=0 ){ null_dtab(a); }	// Error!!
	return ans;
}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_rx_sig(ctree *ctr){			/*** TT-Lang: A = RX_SIG(X,Y) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x,*y;

void	(*rt_prev)(int);				/* <RT> Signal-Handler									*/
void	*ud_prev;						/* <UD> Signal-Handler { MEM[] Addr (>FX_UNIT) }		*/

/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"ID",0);	// SIG
	y = ctr2p_dtab( par=lptr(ctr,1) ); chk_vtype(y,"PX",1);	// SIG_DFL | SIG_IGN | (UsrFunc)DTAB
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

// Note: SIG_DFL & SIG_IGN are 'P'ointer, and their values are 0 & 1 respectively.
// &UsrFunc() generates 'X' DTAB.

/* Do RX_SIG()!! */

// ( Get Prev Handler & Set Next Handler ) //
	ud_prev = sig_vect[cint(x)];
	if( y->type=='P' ){								/*** SIG_DFL|SIG_IGN   -> Handled by OS	***/
		sig_vect[cint(x)] = 0;								// <UD> Clear!!
		rt_prev = signal(cint(x),cptr(y)   );				// <RT> SetUp!! (SIG_DFL|SIG_IGN)
	}
	else{											/*** &UsrFunc()        -> Handled by TT	***/
		sig_vect[cint(x)] = (void *)(tint)(GL_DTAB+((y->attr)&ATTR_FXID)*FX_UNIT);	// <UD> SetUP!! ( MEM[] Addr )
		rt_prev = signal(cint(x),rt_handler);				// <RT> SetUp!!
	}

	if( rt_prev==SIG_ERR ){ null_dtab(a); return ans; }		/*** Error!! ***/

// ( Set Prev Handler for Return ) //
	if( rt_prev==SIG_DFL || rt_prev==SIG_IGN ){		/*** OS Handler ***/
		a->type = 'P';
		a->ptr  = rt_prev;									// SIG_DFL(0)|SIG_IGN(1)
	}
	else{											/*** TT Handler ***/
		a->type = 'P';
		a->ptr  = ud_prev;									// MEM[] Addr (>FX_UNIT)
	}

	return ans;
}
