/*** I_ACONV.C ***/						#include	"main.h"

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *do_t2tm(ctree *ctr,int mode){
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x,*e;
struct	tm *p_tm;		time_t	tsec=0;			tdbl	frac=0.0L;

/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"ID",0);
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

/* Do T2TM()!! */
	tsec=cint(x); frac=fmod(cdbl(x),1.0L);
	if( mode=='U' ){                     p_tm=gmtime(&tsec); asgn_tm2dtab(p_tm,a,'A'); /* 'A'=All  */ }
	if( mode=='L' ){ tsec+=LTZ_OFFSET(); p_tm=gmtime(&tsec); asgn_tm2dtab(p_tm,a,'A'); /* 'A'=All  */ }
	e=ds2p_dtab(a,"sec"); e->dval+=frac;

	a->attr |= ATTR_STID; return ans;	/*** Arry&Hash => StId ***/
}
ctree *i_t2tm (ctree *ctr){ /*** TT-Lang: A = T2TM (X) ***/ return do_t2tm(ctr,'U'); }
ctree *i_t2ltm(ctree *ctr){ /*** TT-Lang: A = T2LTM(X) ***/ return do_t2tm(ctr,'L'); }

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *do_tm2t(ctree *ctr,int mode){
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x,*e;
struct	tm tm;			time_t	tsec=0;			tdbl	frac=0.0L;

/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"A",0);
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

/* Do TM2T()!! */
	if( mode=='U' ){ asgn_dtab2tm(x,&tm,'M'); /* 'M'=Make */ tsec=mktime(&tm)+gl_gmtoff;				}
	if( mode=='L' ){ asgn_dtab2tm(x,&tm,'M'); /* 'M'=Make */ tsec=mktime(&tm)+gl_gmtoff-LTZ_OFFSET();	}
	e=ds2p_dtab(x,"sec"); frac=fmod(cdbl(e),1.0L);

	a->type='D'; a->dval=tsec+frac; return ans;
}
ctree *i_tm2t (ctree *ctr){ /*** TT-Lang: A =  TM2T(X) ***/ return do_tm2t(ctr,'U'); }
ctree *i_ltm2t(ctree *ctr){ /*** TT-Lang: A = LTM2T(X) ***/ return do_tm2t(ctr,'L'); }

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_tm_norm(ctree *ctr){			/*** TT-Lang: A = TM_NORM(X) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x,*e,*p_year,*p_mon,*p_day;
struct	tm *p_tm,tm;	time_t	tsec=0;			tdbl	frac=0.0L;

/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"A",0);
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

/* Do TM_NORM()!! */

// ( Arry&Hash -> Tsec )
	p_year=ds2p_dtab(x,"year"); 
	p_mon =ds2p_dtab(x,"mon" ); 
	p_day =ds2p_dtab(x,"day" ); 
	if( p_year->type=='U' && p_mon->type=='U' && p_day->type!='U' ){	/*** TM_NORM('E') ***/
		asgn_dtab2tm(x,&tm,'E'); /* 'E'=Elp  */
		tsec = (tm.tm_mday)*24*60*60+(tm.tm_hour)*60*60+(tm.tm_min)*60+(tm.tm_sec);
	}
	else{
		asgn_dtab2tm(x,&tm,'M'); /* 'M'=Make */
		tsec = mktime(&tm)+gl_gmtoff;
	}
	e=ds2p_dtab(x,"sec"); frac=fmod(cdbl(e),1.0L);

// ( Tsec -> Arry&Hash )
	if( p_year->type=='U' && p_mon->type=='U' && p_day->type!='U' ){	/*** TM_NORM('E') ***/
		tm.tm_mday=tsec/(24*60*60); tsec =tsec%(24*60*60);
		tm.tm_hour=tsec/(60*60);    tsec =tsec%(60*60);
		tm.tm_min =tsec/(60);       tsec =tsec%(60);
		tm.tm_sec =tsec;             p_tm=&tm;           asgn_tm2dtab(p_tm,a,'E'); /* 'E'=Elp  */ }
	else{                            p_tm=gmtime(&tsec); asgn_tm2dtab(p_tm,a,'A'); /* 'A'=All  */ }
	e=ds2p_dtab(a,"sec"); e->dval+=frac;

	a->attr |= ATTR_STID; return ans;	/*** Arry&Hash => StId ***/
}
