/*** I_ICONV.C ***/						#include	"main.h"

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *do_t2para(ctree *ctr,int zone,int mode){	// UNIXTIME -> YYYY,MM,DD | HH,MM,SS
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x;
struct	tm *p_tm;		time_t	tsec=0;			tdbl	frac=0.0L;

/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"ID",0);		// PARAM = UNIXTIME
	switch(mode){
		case 'A': ans = ext_ctrdtabmult(ctr,6); break;	// ANS[6] = YYYY,MM,DD,HH,MM,SS
		case 'D': ans = ext_ctrdtabmult(ctr,3); break;	// ANS[3] = YYYY,MM,DD
		case 'T': ans = ext_ctrdtabmult(ctr,3); break;	// ANS[3] =            HH,MM,SS
	}

// 与えられた UNIXTIME に対し（変換前に）時差調整を行い、gmtime() にて (struct)tm に変換し、
// 必要な日付｜日時を割り当て＆戻り値とする。
// ※gmtime() は、UNIXTIME を GMT (struct)tm に変換する。！時差調整は変換前！

/* Do T2PARA()!! */						// UPPER: T=>UTC | LOWER: T=>LTZ
	tsec = cint(x) + ( zone=='G' ? 0:LTZ_OFFSET() ); frac = fmod(cdbl(x),1.0L);
	p_tm = gmtime(&tsec);
	switch(mode){
		case 'A':						// All : T -> {UTC|LTZ} YYYY,MM,DD,HH,MM,SS
			a=ctr2p_dtab(lptr(ans,0)); a->type='I'; a->ival=(p_tm->tm_year)+1900;	/* year */
			a=ctr2p_dtab(lptr(ans,1)); a->type='I'; a->ival=(p_tm->tm_mon )+   1;	/* mon  */
			a=ctr2p_dtab(lptr(ans,2)); a->type='I'; a->ival=(p_tm->tm_mday);		/* day  */
			a=ctr2p_dtab(lptr(ans,3)); a->type='I'; a->ival=(p_tm->tm_hour);		/* hour */
			a=ctr2p_dtab(lptr(ans,4)); a->type='I'; a->ival=(p_tm->tm_min );		/* min  */
			a=ctr2p_dtab(lptr(ans,5)); a->type='D'; a->dval=(p_tm->tm_sec )+frac;	/* sec! */
			break;
		case 'D':						// Date: T -> {UTC|LTZ} YYYY,MM,DD
			a=ctr2p_dtab(lptr(ans,0)); a->type='I'; a->ival=(p_tm->tm_year)+1900;	/* year */
			a=ctr2p_dtab(lptr(ans,1)); a->type='I'; a->ival=(p_tm->tm_mon )+   1;	/* mon  */
			a=ctr2p_dtab(lptr(ans,2)); a->type='I'; a->ival=(p_tm->tm_mday);		/* day  */
			break;
		case 'T':						// Time: T -> {UTC|LTZ} HH,MM,SS
			a=ctr2p_dtab(lptr(ans,0)); a->type='I'; a->ival=(p_tm->tm_hour);		/* hour */
			a=ctr2p_dtab(lptr(ans,1)); a->type='I'; a->ival=(p_tm->tm_min );		/* min  */
			a=ctr2p_dtab(lptr(ans,2)); a->type='D'; a->dval=(p_tm->tm_sec )+frac;	/* sec! */
			break;
	}
	return ans;
}
ctree *i_t2ymd    (ctree *ctr){ /*** TT-Lang: A = T2 YMD   (X) ***/ return do_t2para(ctr,'G','A'); }
ctree *i_t2lymd   (ctree *ctr){ /*** TT-Lang: A = T2LYMD   (X) ***/ return do_t2para(ctr,'L','A'); }
ctree *i_t2hms    (ctree *ctr){ /*** TT-Lang: A = T2 HMS   (X) ***/ return do_t2para(ctr,'G','T'); }
ctree *i_t2lhms   (ctree *ctr){ /*** TT-Lang: A = T2LHMS   (X) ***/ return do_t2para(ctr,'L','T'); }

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *do_para2t(ctree *ctr,int zone,int mode){	// YYYY,MM,DD | HH,MM,SS -> UNIXTIME
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x,*y,*z,*p,*q,*r,*s;				int		cnt;
struct	tm tm;			time_t	tsec=0;			tdbl	frac=0.0L;

/* Set Param(s) & Check Type(s) */		/* [l]ymd2t(A:INVA->6|3) [l]hms2t(T:3)					*/
	if( mode=='D' ){
		switch( cnt=lcnt(ctr) ){		/* CNT = ARGC of this Func()							*/
			case 6:						// PARAM[6] = YYYY,MM,DD,HH,MM,SS
				x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"ID",0);
				y = ctr2p_dtab( par=lptr(ctr,1) ); chk_vtype(y,"ID",1);
				z = ctr2p_dtab( par=lptr(ctr,2) ); chk_vtype(z,"ID",2);
				p = ctr2p_dtab( par=lptr(ctr,3) ); chk_vtype(p,"ID",3);
				q = ctr2p_dtab( par=lptr(ctr,4) ); chk_vtype(q,"ID",4);
				r = ctr2p_dtab( par=lptr(ctr,5) ); chk_vtype(r,"ID",5); break;
			case 3:						// PARAM[3] = YYYY,MM,DD
				x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"ID",0);
				y = ctr2p_dtab( par=lptr(ctr,1) ); chk_vtype(y,"ID",1);
				z = ctr2p_dtab( par=lptr(ctr,2) ); chk_vtype(z,"ID",2); break;
			case 1:						// PARAM[1] = "YYYY-MM-DD"
				s = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(s,"S" ,0); break;
			default:
				flag_exerr=NgARGCnn; epar[0]=cnt,epar[1]=1,epar[2]=3,epar[3]=6;    return NULL;
		}
	}
	else{
		switch( cnt=lcnt(ctr) ){		/* CNT = ARGC of this Func()							*/
			case 3:						// PARAM[3] = HH,MM,SS
				x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"ID",0);
				y = ctr2p_dtab( par=lptr(ctr,1) ); chk_vtype(y,"ID",1);
				z = ctr2p_dtab( par=lptr(ctr,2) ); chk_vtype(z,"ID",2); break;
			case 1:						// PARAM[1] = "HH:MM:SS"
				s = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(s,"S" ,0); break;
			default:
				flag_exerr=NgARGCnn; epar[0]=cnt,epar[1]=1,epar[2]=3,epar[3]=INVA; return NULL;
		}
	}
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );		// ANS = UNIXTIME


// Init (struct)TM = 1970-01-01 00:00:00 - This seems to be required by STRPTIME().
	tm.tm_year = (1970)-1900;			/*** ! ***/
	tm.tm_mon  = (   1)-   1;			/*** ! ***/
	tm.tm_mday = 1;
	tm.tm_hour = 0;	tm.tm_min  = 0;	tm.tm_sec  = 0;
	tm.tm_yday = 0;	tm.tm_wday = 0;	tm.tm_isdst= FALS;

	if( cnt==1 ) goto STR2T;
	if( cnt==1 ) goto INT2T;

/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
INT2T:
// ｛日付｜時刻｝の数値を (struct)tm に設定し、mktime() にて UNIXTIME に変換し、
// （変換後に）時差調整を行い得られた UNIXTIME 戻り値とする。
// ※mktime() は、LTZ (struct)tm を UNIXTIME に変換する。！時差調整は変換後！

// {Date|Time} -> (struct)TM
	if( mode=='D' && cnt==6 ){			// YYYY,MM,DD,HH,MM,SS -> T
		tm.tm_year = cint(x)-1900;			/*** ! ***/
		tm.tm_mon  = cint(y)-1;				/*** ! ***/
		tm.tm_mday = cint(z);				frac = 0.0L;
		tm.tm_hour = cint(p);
		tm.tm_min  = cint(q);
		tm.tm_sec  = cdbl(r);				frac = fmod(cdbl(z),1.0L);
	}
	if( mode=='D' && cnt==3 ){			// YYYY,MM,DD          -> T
		tm.tm_year = cint(x)-1900;			/*** ! ***/
		tm.tm_mon  = cint(y)-1;				/*** ! ***/
		tm.tm_mday = cint(z);				frac = 0.0L;
	}
	if( mode=='T' && cnt==3 ){			// HH,MM,SS            -> T
		tm.tm_hour = cint(x);
		tm.tm_min  = cint(y);
		tm.tm_sec  = cdbl(z);				frac = fmod(cdbl(z),1.0L);
	}

// (struct)TM -> UNIXTIME
	switch(zone){
		case 'G':						// UTC -> T
			tsec = mktime(&tm) + gl_gmtoff - 0;
			break;
		case 'L':						// LTZ -> T
			if( mode=='T' )				// 理由：UTC＆LTZ共に、当日00:00:00からのOFFSET値を戻す為
				tsec = mktime(&tm) + gl_gmtoff - 0;
			else
				tsec = mktime(&tm) + gl_gmtoff - LTZ_OFFSET();
			break;
	}

// Return UNIXTIME
	a->type='D'; a->dval=tsec+frac; return ans;	// ANS = UNIXTIME

/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
STR2T:
// ｛日付｜時刻｝の文字列を strptime() にて (struct)tm に設定し、mktime() にて UNIXTIME に変換し、
// （変換後に）時差調整を行い得られた UNIXTIME 戻り値とする。
// ※mktime() は、LTZ (struct)tm を UNIXTIME に変換する。！時差調整は変換後！

// {Date|Time} -> (struct)TM
	if( mode=='D' ){
		if( strptime(cstr(s),FMT_SDATE(),&tm)==NULL ){ flag_exerr=NullSYS; return NULL; }
	}
	if( mode=='T' ){
		if( strptime(cstr(s),FMT_STIME(),&tm)==NULL ){ flag_exerr=NullSYS; return NULL; }
	}

// (struct)TM -> UNIXTIME
	switch(zone){
		case 'G':						// UTC -> T
			tsec = mktime(&tm) + gl_gmtoff - 0;
			break;
		case 'L':						// LTZ -> T
			if( mode=='T' )				// 理由：UTC＆LTZ共に、当日00:00:00からのOFFSET値を戻す為
				tsec = mktime(&tm) + gl_gmtoff - 0;
			else
				tsec = mktime(&tm) + gl_gmtoff - LTZ_OFFSET();
			break;
	}

// Return UNIXTIME
	a->type='D'; a->dval=tsec; return ans;		// UNIXTIME
}

ctree *i_ymd2t (ctree *ctr){ /*** TT-Lang: A =  YMD2T() ***/ return do_para2t(ctr,'G','D'); }
ctree *i_lymd2t(ctree *ctr){ /*** TT-Lang: A = LYMD2T() ***/ return do_para2t(ctr,'L','D'); }
ctree *i_hms2t (ctree *ctr){ /*** TT-Lang: A =  HMS2T() ***/ return do_para2t(ctr,'G','T'); }
ctree *i_lhms2t(ctree *ctr){ /*** TT-Lang: A = LHMS2T() ***/ return do_para2t(ctr,'L','T'); }
