/*** I_SCONV.C ***/						#include	"main.h"

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *do_t2str(ctree *ctr,int zone,int mode){
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x;
struct	tm *p_tm;		time_t	tsec=0;			char	buf[BUFSIZ];

/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"ID",0);
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

/* Do T2STR()!! */
	tsec = cint(x) + ( zone=='G' ? 0:LTZ_OFFSET() );
	p_tm = gmtime(&tsec);
	if( mode=='D' ){ if( strftime(buf,sizeof(buf),FMT_SDATE(),p_tm)==0 ){ flag_exerr=NullSYS; return NULL; } }
	if( mode=='T' ){ if( strftime(buf,sizeof(buf),FMT_STIME(),p_tm)==0 ){ flag_exerr=NullSYS; return NULL; } }

	a->type='S'; a->str=X_SDUP(buf); return ans;
}
ctree *i_sdate (ctree *ctr){ /*** TT-Lang: A = SDATE0(X) ***/ return do_t2str(ctr,'G','D'); }
ctree *i_lsdate(ctree *ctr){ /*** TT-Lang: A = SDATE (X) ***/ return do_t2str(ctr,'L','D'); }
ctree *i_stime (ctree *ctr){ /*** TT-Lang: A = STIME0(X) ***/ return do_t2str(ctr,'G','T'); }
ctree *i_lstime(ctree *ctr){ /*** TT-Lang: A = STIME (X) ***/ return do_t2str(ctr,'L','T'); }

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *do_strftime(ctree *ctr,int zone){
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x,*y;
struct	tm *p_tm;		time_t	tsec=0;			char	buf[BUFSIZ];

/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"S" ,0);	// Format String
	y = ctr2p_dtab( par=lptr(ctr,1) ); chk_vtype(y,"ID",1);	// Unix Time
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

/* Do STRFTIME()!! */
	tsec = cint(y) + ( zone=='G' ? 0:LTZ_OFFSET() );
	p_tm = gmtime(&tsec);
	if( strftime(buf,BUFSIZ,x->str,p_tm)==0 ){ flag_exerr=NullSYS; return NULL; }

	a->type='S'; a->str=X_SDUP(buf); return ans;
}
ctree *i_strftime (ctree *ctr){ /*** TT-Lang: A = STR FTIME(X,Y) ***/ return do_strftime(ctr,'G'); }
ctree *i_strlftime(ctree *ctr){ /*** TT-Lang: A = STRLFTIME(X,Y) ***/ return do_strftime(ctr,'L'); }

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *do_strptime(ctree *ctr,int zone){
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x,*y;
struct	tm tm;			time_t	tsec=0;

/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"S",0);	// Format String
	y = ctr2p_dtab( par=lptr(ctr,1) ); chk_vtype(y,"S",1);	// Date&Time String
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

/* Do STRPTIME()!! */

// Init (struct)TM = 1970-01-01 00:00:00 - This seems to be required by STRPTIME().
	tm.tm_year = (1970)-1900;			/*** ! ***/
	tm.tm_mon  = (   1)-   1;			/*** ! ***/
	tm.tm_mday = 1;
	tm.tm_hour = 0;	tm.tm_min  = 0;	tm.tm_sec  = 0;
	tm.tm_yday = 0;	tm.tm_wday = 0;	tm.tm_isdst= FALS;

	if( strptime(y->str,x->str,&tm)==NULL ){ flag_exerr=NullSYS; return NULL; }
	if( zone=='G' ){ tsec=mktime(&tm)+gl_gmtoff;              }
	if( zone=='L' ){ tsec=mktime(&tm)+gl_gmtoff-LTZ_OFFSET(); }

	a->type='D'; a->dval=tsec; return ans;		// UNIXTIME
}
ctree *i_strptime (ctree *ctr){ /*** TT-Lang: A = STR PTIME(X,Y) ***/ return do_strptime(ctr,'G'); }
ctree *i_strlptime(ctree *ctr){ /*** TT-Lang: A = STRLPTIME(X,Y) ***/ return do_strptime(ctr,'L'); }
