/*** I_TIME.C ***/						#include	"main.h"

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_time(ctree *ctr){				/*** TT-Lang: A = TIME(VOID) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans;			dtab	*a;
struct	timeval timeval;				/* Struct TIMEVAL - tv_sec[Sec] & tv_usec[uSec]			*/

/* Set Param(s) & Check Type(s) */
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

/* Do TIME()!! */
	if( gettimeofday(&timeval,NULL)==-1 ){ flag_exerr=NullSYS; return NULL; }
	a->type='D'; a->dval=timeval.tv_sec+timeval.tv_usec/1000000.0; return ans;
}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_ptime(ctree *ctr){				/*** TT-Lang: A = PTIME(VOID) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans;			dtab	*a,*e;
struct	tms tms;						/* Struct TMS - tms_{utime,cutime,stime,cstime} [N/A]	*/
clock_t	clk_ticks;						/* Clock Ticks [N/A]									*/

/* Set Param(s) & Check Type(s) */
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

/* Do PTIME()!! */
	if( (clk_ticks=times(&tms))==-1 ){ flag_exerr=NullSYS; return NULL; }

// PTIME - Process Time => CurrTime - InitTime [Sec]
// UTIME - Usr CPU Time => UTIME + CUTIME      [Sec]
// STIME - Sys CPU Time => STIME + CSTIME      [Sec]
	e=ds2p_dtab(a,"ptime"); e->type='D'; e->dval=(clk_ticks                   )/(tdbl)sysconf(_SC_CLK_TCK)-gl_uptime;
	e=ds2p_dtab(a,"utime"); e->type='D'; e->dval=(tms.tms_utime+tms.tms_cutime)/(tdbl)sysconf(_SC_CLK_TCK);
	e=ds2p_dtab(a,"stime"); e->type='D'; e->dval=(tms.tms_stime+tms.tms_cstime)/(tdbl)sysconf(_SC_CLK_TCK);

	a->attr |= ATTR_STID; return ans;	/*** Arry&Hash => StId ***/
}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_isleap(ctree *ctr){			/*** TT-Lang: A = ISLEAP(X) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x;
int		year;

/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"ID",0);
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

/* Do ISLEAP()!! */
	year = cint(x);
	a->type='I'; a->ival=( year%4==0 && !(year%100==0 && year%400!=0) ); return ans;
}
